/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.client;

import net.minecraft.client.color.item.ItemColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import su.terrafirmagreg.core.common.data.TFGItems;

@Mod.EventBusSubscriber(modid="tfg", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class SyringeClientHandler {
    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        ItemColor colorProvider = (stack, tintIndex) -> {
            if (tintIndex == 0) {
                return 0xFFFFFF;
            }
            if (stack.m_41782_()) {
                assert (stack.m_41783_() != null);
                if (stack.m_41783_().m_128441_("mob_type")) {
                    String mobId = stack.m_41783_().m_128461_("mob_type");
                    if (mobId.isEmpty()) {
                        return 0xFFFFFF;
                    }
                    EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.parse((String)mobId));
                    if (type == null) {
                        return 0xFFFFFF;
                    }
                    SpawnEggItem egg = SpawnEggItem.m_43213_((EntityType)type);
                    if (egg != null) {
                        int eggColor = tintIndex == 1 ? egg.m_43211_(0) : egg.m_43211_(1);
                        return eggColor & 0xFFFFFF;
                    }
                    for (Item item : ForgeRegistries.ITEMS.getValues()) {
                        if (!(item instanceof SpawnEggItem)) continue;
                        SpawnEggItem se = (SpawnEggItem)item;
                        try {
                            EntityType eggType = se.m_43228_(null);
                            if (eggType != type) continue;
                            int eggColor = tintIndex == 1 ? se.m_43211_(0) : se.m_43211_(1);
                            return eggColor & 0xFFFFFF;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
            }
            return 0xFFFFFF;
        };
        event.register(colorProvider, new ItemLike[]{(ItemLike)TFGItems.FILLED_DNA_SYRINGE.get()});
    }
}

