/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data;

import java.util.Locale;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.wanmine.wab.entity.render.EntityRenderer;
import net.wanmine.wab.entity.render.model.SurferModel;
import su.terrafirmagreg.core.common.data.entities.glacianram.TFCGlacianRam;
import su.terrafirmagreg.core.common.data.entities.glacianram.TFCGlacianRamModel;
import su.terrafirmagreg.core.common.data.entities.glacianram.TFCGlacianRamRenderer;
import su.terrafirmagreg.core.common.data.entities.moonrabbit.MoonRabbit;
import su.terrafirmagreg.core.common.data.entities.moonrabbit.MoonRabbitRenderer;
import su.terrafirmagreg.core.common.data.entities.sniffer.TFCSniffer;
import su.terrafirmagreg.core.common.data.entities.sniffer.TFCSnifferRenderer;
import su.terrafirmagreg.core.common.data.entities.surfer.TFCSurfer;
import su.terrafirmagreg.core.common.data.entities.wraptor.TFCWraptor;
import su.terrafirmagreg.core.common.data.entities.wraptor.TFCWraptorRenderer;

public class TFGEntities {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"tfg");
    public static final RegistryObject<EntityType<MoonRabbit>> MOON_RABBIT = TFGEntities.register("moon_rabbit", EntityType.Builder.m_20704_(MoonRabbit::makeMoonRabbit, (MobCategory)MobCategory.CREATURE).m_20699_(1.0f, 1.3f).m_20702_(10));
    public static final RegistryObject<EntityType<TFCGlacianRam>> GLACIAN_RAM = TFGEntities.register("glacian_ram", EntityType.Builder.m_20704_(TFCGlacianRam::makeTFCGlacianRam, (MobCategory)MobCategory.CREATURE).m_20699_(1.0f, 0.9f).m_20702_(10));
    public static final RegistryObject<EntityType<TFCSniffer>> SNIFFER = TFGEntities.register("sniffer", EntityType.Builder.m_20704_(TFCSniffer::makeTFCSniffer, (MobCategory)MobCategory.CREATURE).m_20699_(1.9f, 1.75f).m_20702_(10));
    public static final RegistryObject<EntityType<TFCWraptor>> WRAPTOR = TFGEntities.register("wraptor", EntityType.Builder.m_20704_(TFCWraptor::makeTFCWraptor, (MobCategory)MobCategory.CREATURE).m_20699_(0.8f, 2.2f).m_20702_(10));
    public static final RegistryObject<EntityType<TFCSurfer>> SURFER = TFGEntities.register("surfer", EntityType.Builder.m_20704_(TFCSurfer::makeTFCSurfer, (MobCategory)MobCategory.WATER_CREATURE).m_20699_(1.2f, 0.7f).m_20702_(10));

    public static <E extends Entity> RegistryObject<EntityType<E>> register(String name, EntityType.Builder<E> builder) {
        return TFGEntities.register(name, builder, true);
    }

    public static <E extends Entity> RegistryObject<EntityType<E>> register(String name, EntityType.Builder<E> builder, boolean serialize) {
        String id = name.toLowerCase(Locale.ROOT);
        return ENTITIES.register(id, () -> {
            if (!serialize) {
                builder.m_20716_();
            }
            return builder.m_20712_("tfg:" + id);
        });
    }

    public static void onAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)MOON_RABBIT.get(), MoonRabbit.m_29717_().m_22265_());
        event.put((EntityType)GLACIAN_RAM.get(), TFCGlacianRam.m_21552_().m_22265_());
        event.put((EntityType)SNIFFER.get(), TFCSniffer.m_21552_().m_22265_());
        event.put((EntityType)WRAPTOR.get(), TFCWraptor.m_21552_().m_22265_());
        event.put((EntityType)SURFER.get(), TFCSurfer.getDefaultAttributes().m_22265_());
    }

    public static void onSpawnPlacement(SpawnPlacementRegisterEvent event) {
        event.register((EntityType)MOON_RABBIT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MoonRabbit::spawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)GLACIAN_RAM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TFCGlacianRam::spawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)SNIFFER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TFCSniffer::spawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)WRAPTOR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TFCWraptor::spawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)SURFER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.OCEAN_FLOOR, TFCSurfer::spawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static void onEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)MOON_RABBIT.get(), MoonRabbitRenderer::new);
        event.registerEntityRenderer((EntityType)GLACIAN_RAM.get(), TFCGlacianRamRenderer::new);
        event.registerEntityRenderer((EntityType)SNIFFER.get(), TFCSnifferRenderer::new);
        event.registerEntityRenderer((EntityType)WRAPTOR.get(), TFCWraptorRenderer::new);
        event.registerEntityRenderer((EntityType)SURFER.get(), EntityRenderer.create(SurferModel::new, (float)0.6f));
    }

    public static void onEntityLayerRegister(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(TFCGlacianRamModel.LAYER_LOCATION, TFCGlacianRamModel::createBodyLayer);
    }
}

