/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.blocks;

import javax.annotation.Nullable;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.BottomSupportedDeviceBlock;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.entities.misc.Seat;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import su.terrafirmagreg.core.common.data.TFGBlockEntities;
import su.terrafirmagreg.core.common.data.blockentity.LargeNestBoxBlockEntity;

public class LargeNestBoxBlock
extends BottomSupportedDeviceBlock {
    public static final IntegerProperty NEST_PART = IntegerProperty.m_61631_((String)"nest_part", (int)0, (int)3);
    public static final IntegerProperty HAS_EGG_TYPE = IntegerProperty.m_61631_((String)"has_egg_type", (int)0, (int)2);
    private static final VoxelShape[] SHAPE_0 = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)15.0), Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)15.0)}));
    private static final VoxelShape[] SHAPE_1 = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)4.0, (double)4.0), Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)4.0, (double)16.0)}));
    private static final VoxelShape[] SHAPE_2 = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)12.0, (double)15.0, (double)4.0, (double)15.0), Helpers.rotateShape((Direction)dir, (double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)4.0, (double)15.0)}));
    private static final VoxelShape[] SHAPE_3 = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)4.0), Helpers.rotateShape((Direction)dir, (double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)16.0)}));
    private static final VoxelShape[] SHAPE_0_S = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)15.0), Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)15.0), Helpers.rotateShape((Direction)dir, (double)6.0, (double)1.0, (double)1.0, (double)15.0, (double)14.0, (double)11.0)}));
    private static final VoxelShape[] SHAPE_1_S = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)4.0, (double)4.0), Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)4.0, (double)16.0), Helpers.rotateShape((Direction)dir, (double)5.0, (double)1.0, (double)9.0, (double)14.0, (double)12.0, (double)16.0)}));
    private static final VoxelShape[] SHAPE_2_S = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)12.0, (double)15.0, (double)4.0, (double)15.0), Helpers.rotateShape((Direction)dir, (double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)4.0, (double)15.0), Helpers.rotateShape((Direction)dir, (double)0.0, (double)1.0, (double)0.0, (double)8.0, (double)13.0, (double)9.0)}));
    private static final VoxelShape[] SHAPE_3_S = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)4.0), Helpers.rotateShape((Direction)dir, (double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)16.0), Helpers.rotateShape((Direction)dir, (double)0.0, (double)1.0, (double)6.0, (double)10.0, (double)14.0, (double)15.0)}));
    private static final VoxelShape[] SHAPE_0_W = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0, (double)15.0), Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)4.0, (double)15.0), Helpers.rotateShape((Direction)dir, (double)6.0, (double)1.0, (double)1.0, (double)14.0, (double)11.0, (double)9.0)}));
    private static final VoxelShape[] SHAPE_1_W = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)4.0, (double)4.0), Helpers.rotateShape((Direction)dir, (double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)4.0, (double)16.0), Helpers.rotateShape((Direction)dir, (double)7.0, (double)1.0, (double)8.0, (double)14.0, (double)10.0, (double)15.0)}));
    private static final VoxelShape[] SHAPE_2_W = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)12.0, (double)15.0, (double)4.0, (double)15.0), Helpers.rotateShape((Direction)dir, (double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)4.0, (double)15.0), Helpers.rotateShape((Direction)dir, (double)0.0, (double)1.0, (double)1.0, (double)6.0, (double)9.0, (double)7.0)}));
    private static final VoxelShape[] SHAPE_3_W = Helpers.computeHorizontalShapes(dir -> Shapes.m_83124_((VoxelShape)Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Helpers.rotateShape((Direction)dir, (double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)4.0), Helpers.rotateShape((Direction)dir, (double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)16.0), Helpers.rotateShape((Direction)dir, (double)2.0, (double)1.0, (double)8.0, (double)9.0, (double)11.0, (double)15.0)}));
    private static final VoxelShape[][] SHAPES_EMPTY = new VoxelShape[][]{SHAPE_0, SHAPE_1, SHAPE_2, SHAPE_3};
    private static final VoxelShape[][] SHAPES_SNIFFER = new VoxelShape[][]{SHAPE_0_S, SHAPE_1_S, SHAPE_2_S, SHAPE_3_S};
    private static final VoxelShape[][] SHAPES_WRAPTOR = new VoxelShape[][]{SHAPE_0_W, SHAPE_1_W, SHAPE_2_W, SHAPE_3_W};
    public static final VoxelShape[][][] SHAPES = new VoxelShape[][][]{SHAPES_EMPTY, SHAPES_SNIFFER, SHAPES_WRAPTOR};

    public LargeNestBoxBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NEST_PART, (Comparable)Integer.valueOf(0))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_EGG_TYPE, (Comparable)Integer.valueOf(0)));
    }

    private static boolean canPlaceLargeNest(Level level, BlockPos pos, BlockState state, Direction facing) {
        for (BlockPos testPos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_121945_(facing).m_121945_(facing.m_122427_()))) {
            if (level.m_8055_(testPos).m_247087_()) continue;
            return false;
        }
        return true;
    }

    public static BlockPos findZeroPos(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        int part = (Integer)state.m_61143_((Property)NEST_PART);
        return switch (part) {
            case 1 -> pos.m_121945_(facing.m_122424_());
            case 2 -> pos.m_121945_(facing.m_122428_());
            case 3 -> pos.m_121945_(facing.m_122428_()).m_121945_(facing.m_122424_());
            default -> pos;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos zero = LargeNestBoxBlock.findZeroPos(level, pos, state);
        return this.useZeroBlock(level.m_8055_(zero), level, zero, player, hand, hit.m_82430_(zero));
    }

    public InteractionResult useZeroBlock(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_6144_() && level.m_7702_(pos) instanceof LargeNestBoxBlockEntity) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                level.m_141902_(pos, (BlockEntityType)TFGBlockEntities.LARGE_NEST_BOX.get()).ifPresent(nest -> Helpers.openScreen((ServerPlayer)serverPlayer, (MenuProvider)nest, (BlockPos)pos));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{NEST_PART}).m_61104_(new Property[]{BlockStateProperties.f_61374_}).m_61104_(new Property[]{HAS_EGG_TYPE}));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return LargeNestBoxBlock.canPlaceLargeNest(ctx.m_43725_(), ctx.m_8083_(), this.m_49966_(), ctx.m_8125_()) ? (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)ctx.m_8125_()) : null;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        return LargeNestBoxBlock.canPartSurvive((LevelReader)level, pos, state) ? state : Blocks.f_50016_.m_49966_();
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)HAS_EGG_TYPE)][(Integer)state.m_61143_((Property)NEST_PART)][((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122416_()];
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        Direction forward = placer != null ? placer.m_6350_() : Direction.NORTH;
        Direction back = forward.m_122424_();
        Direction right = forward.m_122427_();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)forward);
        cursor.m_122173_(forward);
        level.m_46597_((BlockPos)cursor, (BlockState)state.m_61124_((Property)NEST_PART, (Comparable)Integer.valueOf(1)));
        cursor.m_122173_(right).m_122173_(back);
        level.m_46597_((BlockPos)cursor, (BlockState)state.m_61124_((Property)NEST_PART, (Comparable)Integer.valueOf(2)));
        cursor.m_122173_(forward);
        level.m_46597_((BlockPos)cursor, (BlockState)state.m_61124_((Property)NEST_PART, (Comparable)Integer.valueOf(3)));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        Entity sitter = Seat.getSittingEntity((Level)level, (BlockPos)pos);
        if (sitter != null) {
            sitter.m_8127_();
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return super.m_142194_(pos, state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)NEST_PART) == 0 || LargeNestBoxBlock.canPartSurvive(level, pos, state);
    }

    private static boolean canPartSurvive(LevelReader level, BlockPos pos, BlockState state) {
        if (!(state.m_60734_() instanceof LargeNestBoxBlock)) {
            return false;
        }
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        Direction cw = facing.m_122427_();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        int dx = facing.m_122429_();
        int cdx = cw.m_122429_();
        int dz = facing.m_122431_();
        int cdz = cw.m_122431_();
        return switch ((Integer)state.m_61143_((Property)NEST_PART)) {
            case 0 -> {
                if (LargeNestBoxBlock.stageAtPos(dx, 0, dz, level, pos, cursor, 1) && LargeNestBoxBlock.stageAtPos(cdx, 0, cdz, level, pos, cursor, 2)) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (LargeNestBoxBlock.stageAtPos(-dx, 0, -dz, level, pos, cursor, 0) && LargeNestBoxBlock.stageAtPos(cdx, 0, cdz, level, pos, cursor, 3)) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (LargeNestBoxBlock.stageAtPos(dx, 0, dz, level, pos, cursor, 3) && LargeNestBoxBlock.stageAtPos(-cdx, 0, -cdz, level, pos, cursor, 0)) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (LargeNestBoxBlock.stageAtPos(-dx, 0, -dz, level, pos, cursor, 2) && LargeNestBoxBlock.stageAtPos(-cdx, 0, -cdz, level, pos, cursor, 1)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean stageAtPos(int dx, int dy, int dz, LevelReader level, BlockPos origin, BlockPos.MutableBlockPos cursor, int stageWanted) {
        cursor.m_122190_((Vec3i)origin).m_122184_(dx, dy, dz);
        BlockState state = level.m_8055_((BlockPos)cursor);
        return state.m_60734_() instanceof LargeNestBoxBlock && (Integer)state.m_61143_((Property)NEST_PART) == stageWanted;
    }
}

