/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.blocks;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import su.terrafirmagreg.core.common.data.blocks.LunarChorusPlantBlock;

public class LunarChorusFlowerBlock
extends Block {
    public static final IntegerProperty AGE = BlockStateProperties.f_61408_;
    private final Supplier<? extends Block> plant;

    public LunarChorusFlowerBlock(BlockBehaviour.Properties pProperties, Supplier<? extends Block> plantBlock) {
        super(pProperties);
        this.plant = plantBlock;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE});
    }

    public boolean m_222958_(BlockState state, BlockGetter view, BlockPos pos) {
        return false;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pState.m_60710_((LevelReader)pLevel, pPos)) {
            pLevel.m_46961_(pPos, true);
        }
    }

    private void setBodyBlock(LevelAccessor level, BlockPos pos) {
        LunarChorusPlantBlock plantBlock = (LunarChorusPlantBlock)this.plant.get();
        level.m_7731_(pos, plantBlock.m_51710_((BlockGetter)level, pos), 2);
    }

    public static boolean isGroundBlock(BlockState state) {
        return state.m_204336_(Tags.Blocks.STONE) || state.m_204336_(Tags.Blocks.COBBLESTONE) || state.m_204336_(Tags.Blocks.GRAVEL) || state.m_204336_(Tags.Blocks.SAND);
    }

    public static boolean isGroundBlock(Block block) {
        return Helpers.isBlock((Block)block, (TagKey)Tags.Blocks.STONE) || Helpers.isBlock((Block)block, (TagKey)Tags.Blocks.COBBLESTONE) || Helpers.isBlock((Block)block, (TagKey)Tags.Blocks.GRAVEL) || Helpers.isBlock((Block)block, (TagKey)Tags.Blocks.SAND);
    }

    public boolean m_6724_(BlockState pState) {
        return (Integer)pState.m_61143_((Property)AGE) < 5;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int i;
        BlockPos abovePos = pPos.m_7494_();
        if (pLevel.m_46859_(abovePos) && abovePos.m_123342_() < pLevel.m_151558_() && (i = ((Integer)pState.m_61143_((Property)AGE)).intValue()) < 5 && ForgeHooks.onCropsGrowPre((Level)pLevel, (BlockPos)abovePos, (BlockState)pState, (boolean)true)) {
            boolean shouldPlaceNewBody = false;
            boolean foundGroundFurtherDown = false;
            BlockState belowState = pLevel.m_8055_(pPos.m_7495_());
            Block belowBlock = belowState.m_60734_();
            if (LunarChorusFlowerBlock.isGroundBlock(belowState)) {
                shouldPlaceNewBody = true;
            } else if (belowBlock == this.plant) {
                int j = 1;
                for (int k = 0; k < 4; ++k) {
                    Block belowBlockOffset = pLevel.m_8055_(pPos.m_6625_(j + 1)).m_60734_();
                    if (belowBlockOffset != this.plant) {
                        if (!LunarChorusFlowerBlock.isGroundBlock(belowBlockOffset)) break;
                        foundGroundFurtherDown = true;
                        break;
                    }
                    ++j;
                }
                if (j < 2 || j <= pRandom.m_188503_(foundGroundFurtherDown ? 5 : 4)) {
                    shouldPlaceNewBody = true;
                }
            } else if (belowState.m_60795_()) {
                shouldPlaceNewBody = true;
            }
            if (shouldPlaceNewBody && LunarChorusFlowerBlock.allNeighborsEmpty((LevelReader)pLevel, abovePos, null) && pLevel.m_46859_(pPos.m_6630_(2))) {
                this.setBodyBlock((LevelAccessor)pLevel, pPos);
                this.placeGrownFlower((Level)pLevel, abovePos, i);
            } else if (i < 4) {
                int l = pRandom.m_188503_(4);
                if (foundGroundFurtherDown) {
                    ++l;
                }
                boolean foundValidGrowthSpace = false;
                for (int j = 0; j < l; ++j) {
                    Direction direction = Direction.Plane.HORIZONTAL.m_235690_(pRandom);
                    BlockPos blockpos1 = pPos.m_121945_(direction);
                    if (!pLevel.m_46859_(blockpos1) || !pLevel.m_46859_(blockpos1.m_7495_()) || !LunarChorusFlowerBlock.allNeighborsEmpty((LevelReader)pLevel, blockpos1, direction.m_122424_())) continue;
                    this.placeGrownFlower((Level)pLevel, blockpos1, i + 1);
                    foundValidGrowthSpace = true;
                }
                if (foundValidGrowthSpace) {
                    this.setBodyBlock((LevelAccessor)pLevel, pPos);
                } else {
                    this.placeDeadFlower((Level)pLevel, pPos);
                }
            } else {
                this.placeDeadFlower((Level)pLevel, pPos);
            }
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private void placeGrownFlower(Level pLevel, BlockPos pPos, int pAge) {
        pLevel.m_7731_(pPos, (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(pAge)), 2);
        pLevel.m_46796_(1033, pPos, 0);
    }

    private void placeDeadFlower(Level pLevel, BlockPos pPos) {
        pLevel.m_7731_(pPos, (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(5)), 2);
        pLevel.m_46796_(1034, pPos, 0);
    }

    private static boolean allNeighborsEmpty(LevelReader pLevel, BlockPos pPos, @Nullable Direction pExcludingSide) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (direction == pExcludingSide || pLevel.m_46859_(pPos.m_121945_(direction))) continue;
            return false;
        }
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!state.m_60710_((LevelReader)level, currentPos)) {
            level.m_186460_(currentPos, (Block)this, 1);
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        LunarChorusPlantBlock body = (LunarChorusPlantBlock)this.plant.get();
        BlockState blockstate = pLevel.m_8055_(pPos.m_7495_());
        if (blockstate.m_60734_() == body || LunarChorusFlowerBlock.isGroundBlock(blockstate)) {
            return true;
        }
        if (!blockstate.m_60795_()) {
            return false;
        }
        boolean isValid = false;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState relativeState = pLevel.m_8055_(pPos.m_121945_(direction));
            if (Helpers.isBlock((BlockState)relativeState, (Block)body)) {
                if (isValid) {
                    return false;
                }
                isValid = true;
                continue;
            }
            if (relativeState.m_60795_()) continue;
            return false;
        }
        return isValid;
    }

    public boolean generatePlant(LevelAccessor pLevel, BlockPos pPos, RandomSource pRandom, int pMaxHorizontalDistance) {
        BlockState originalState = pLevel.m_8055_(pPos);
        this.setBodyBlock(pLevel, pPos);
        if (pLevel.m_8055_(pPos).m_60710_((LevelReader)pLevel, pPos) && this.growTreeRecursive(pLevel, pPos, pRandom, pPos, pMaxHorizontalDistance, 0)) {
            return true;
        }
        pLevel.m_7731_(pPos, originalState, 3);
        return false;
    }

    public boolean growTreeRecursive(LevelAccessor level, BlockPos branchPos, RandomSource rand, BlockPos originalBranchPos, int maxHorizontalDistance, int iterations) {
        boolean any = false;
        int i = rand.m_188503_(5) + 1;
        if (iterations == 0) {
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            BlockPos blockpos = branchPos.m_6630_(j + 1);
            if (!LunarChorusFlowerBlock.allNeighborsEmpty((LevelReader)level, blockpos, null)) {
                return any;
            }
            this.setBodyBlock(level, blockpos);
            this.setBodyBlock(level, blockpos.m_7495_());
        }
        boolean willContinue = false;
        if (iterations < 4) {
            int branchAttempts = rand.m_188503_(4);
            if (iterations == 0) {
                ++branchAttempts;
            }
            for (int k = 0; k < branchAttempts; ++k) {
                Direction direction = Direction.Plane.HORIZONTAL.m_235690_(rand);
                BlockPos aboveRelativePos = branchPos.m_6630_(i).m_121945_(direction);
                if (Math.abs(aboveRelativePos.m_123341_() - originalBranchPos.m_123341_()) >= maxHorizontalDistance || Math.abs(aboveRelativePos.m_123343_() - originalBranchPos.m_123343_()) >= maxHorizontalDistance || !level.m_46859_(aboveRelativePos) || !level.m_46859_(aboveRelativePos.m_7495_()) || !LunarChorusFlowerBlock.allNeighborsEmpty((LevelReader)level, aboveRelativePos, direction.m_122424_())) continue;
                willContinue = true;
                this.setBodyBlock(level, aboveRelativePos);
                this.setBodyBlock(level, aboveRelativePos.m_121945_(direction.m_122424_()));
                this.growTreeRecursive(level, aboveRelativePos, rand, originalBranchPos, maxHorizontalDistance, iterations + 1);
            }
        }
        if (!willContinue) {
            level.m_7731_(branchPos.m_6630_(i), (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(rand.m_188503_(10) == 1 ? 3 : 5)), 2);
        }
        return true;
    }
}

