/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.entities.sniffer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.dries007.tfc.common.entities.ai.SetLookTarget;
import net.dries007.tfc.common.entities.ai.livestock.BreedBehavior;
import net.dries007.tfc.common.entities.ai.livestock.LivestockAi;
import net.dries007.tfc.common.entities.ai.prey.AvoidPredatorBehavior;
import net.minecraft.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import su.terrafirmagreg.core.common.data.entities.ai.LayLargeEggBehavior;
import su.terrafirmagreg.core.common.data.entities.ai.TFGBrain;
import su.terrafirmagreg.core.common.data.entities.sniffer.TFCSniffer;

public class TFCSnifferAi
extends LivestockAi {
    public static final ImmutableList<SensorType<? extends Sensor<? super TFCSniffer>>> SENSOR_TYPES = (ImmutableList)Util.m_137537_(() -> {
        ArrayList list = Lists.newArrayList((Iterable)LivestockAi.SENSOR_TYPES);
        list.add((SensorType)TFGBrain.LARGE_NEST_BOX_SENSOR.get());
        return ImmutableList.copyOf((Collection)list);
    });
    public static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = (ImmutableList)Util.m_137537_(() -> {
        ArrayList list = Lists.newArrayList((Iterable)LivestockAi.MEMORY_TYPES);
        list.add((MemoryModuleType)TFGBrain.LARGE_NEST_MEMORY.get());
        return ImmutableList.copyOf((Collection)list);
    });

    public static Brain<?> makeSniffBrain(Brain<? extends TFCSniffer> brain) {
        TFCSnifferAi.initCoreActivity(brain);
        TFCSnifferAi.initSniffIdleActivity(brain);
        TFCSnifferAi.initRetreatActivity(brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_37979_);
        brain.m_21962_();
        return brain;
    }

    public static void initSniffIdleActivity(Brain<? extends TFCSniffer> brain) {
        brain.m_21891_(Activity.f_37979_, 0, ImmutableList.of((Object)SetLookTarget.create((EntityType)EntityType.f_20532_, (float)6.0f, (UniformInt)UniformInt.m_146622_((int)30, (int)60)), (Object)AvoidPredatorBehavior.create((boolean)true), (Object)((Object)new LayLargeEggBehavior()), (Object)new BreedBehavior(1.0f), (Object)new AnimalPanic(2.0f), (Object)new FollowTemptation(e -> Float.valueOf(e.m_6162_() ? 1.5f : 1.25f)), (Object)((Object)new Scenting(60, 160)), (Object)((Object)new Sniffing(100, 200)), (Object)BabyFollowAdult.m_257685_((UniformInt)UniformInt.m_146622_((int)5, (int)16), (float)1.25f), (Object)TFCSnifferAi.createIdleMovementBehaviors()));
    }

    static class Scenting
    extends Behavior<TFCSniffer> {
        Scenting(int pMinDuration, int pMaxDuration) {
            super(Map.of(MemoryModuleType.f_217768_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_26375_, MemoryStatus.VALUE_ABSENT), pMinDuration, pMaxDuration);
        }

        protected boolean checkExtraStartConditions(ServerLevel pLevel, TFCSniffer pOwner) {
            return !pOwner.isTempted();
        }

        protected boolean canStillUse(ServerLevel pLevel, TFCSniffer pEntity, long pGameTime) {
            return true;
        }

        protected void start(ServerLevel pLevel, TFCSniffer pEntity, long pGameTime) {
            pEntity.transitionTo(TFCSniffer.State.SCENTING);
        }

        protected void stop(ServerLevel pLevel, TFCSniffer pEntity, long pGameTime) {
            pEntity.transitionTo(TFCSniffer.State.IDLING);
        }
    }

    static class Sniffing
    extends Behavior<TFCSniffer> {
        Sniffing(int pMinDuration, int pMaxDuration) {
            super(Map.of(MemoryModuleType.f_217768_, MemoryStatus.VALUE_ABSENT, MemoryModuleType.f_26375_, MemoryStatus.VALUE_ABSENT), pMinDuration, pMaxDuration);
        }

        protected boolean checkExtraStartConditions(ServerLevel pLevel, TFCSniffer pOwner) {
            return !pOwner.m_6162_() && pOwner.isTempted();
        }

        protected boolean canStillUse(ServerLevel pLevel, TFCSniffer pEntity, long pGameTime) {
            return pEntity.isTempted();
        }

        protected void start(ServerLevel pLevel, TFCSniffer pEntity, long pGameTime) {
            pEntity.transitionTo(TFCSniffer.State.SNIFFING);
        }

        protected void stop(ServerLevel pLevel, TFCSniffer pEntity, long pGameTime) {
            pEntity.transitionTo(TFCSniffer.State.IDLING);
        }
    }
}

