/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.events;

import java.util.Collection;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import su.terrafirmagreg.core.common.data.TFGItems;
import su.terrafirmagreg.core.common.data.TFGTags;
import su.terrafirmagreg.core.config.TFGConfig;

@Mod.EventBusSubscriber(modid="tfg", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DnaSyringeEvent {
    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Level level = event.getLevel();
        if (level.f_46443_) {
            return;
        }
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        if (!stack.m_204117_(TFGTags.Items.EmptySyringe)) {
            return;
        }
        Entity entity = event.getTarget();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            return;
        }
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_());
        List blacklist = List.copyOf((Collection)TFGConfig.SERVER.SYRINGE_BLACKLIST.get());
        if (entityId == null || blacklist.contains(entityId.toString())) {
            return;
        }
        ItemStack filled = new ItemStack((ItemLike)TFGItems.FILLED_DNA_SYRINGE.get());
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_());
        if (id == null) {
            return;
        }
        filled.m_41784_().m_128359_("mob_type", id.toString());
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        if (!player.m_36356_(filled)) {
            player.m_36176_(filled, false);
        }
        level.m_5594_(null, player.m_20183_(), SoundEvents.f_11770_, SoundSource.PLAYERS, 1.0f, 2.0f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123751_, target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_(), 10, 1.0, 1.0, 1.0, 0.0);
        }
        target.m_6469_(player.m_269291_().m_269075_(player), 0.0f);
        player.m_36335_().m_41524_(stack.m_41720_(), 20);
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
        player.m_6674_(event.getHand());
    }

    @SubscribeEvent
    public static void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            DnaSyringeEvent.applyEffect(event.getEntity(), target, event.getItemStack(), event.getHand());
        }
    }

    @SubscribeEvent
    public static void onEntityLeftClick(AttackEntityEvent event) {
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            DnaSyringeEvent.applyEffect(event.getEntity(), target, event.getEntity().m_21205_(), InteractionHand.MAIN_HAND);
        }
    }

    private static void applyEffect(Player player, LivingEntity target, ItemStack held, InteractionHand hand) {
        if (held.m_41619_()) {
            return;
        }
        if (held.m_150930_((Item)TFGItems.DIRTY_DNA_SYRINGE.get())) {
            if (player.m_36335_().m_41519_(held.m_41720_())) {
                return;
            }
            target.m_9236_().m_5594_(null, target.m_20183_(), SoundEvents.f_12514_, SoundSource.PLAYERS, 1.0f, 2.0f);
            target.m_6469_(player.m_269291_().m_269075_(player), 0.0f);
            target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
            player.m_36335_().m_41524_(held.m_41720_(), 400);
            player.m_21011_(hand, true);
        }
    }
}

