/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.TextureWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.compat.emi.TFGEmiPlugin;

public class BlockInteractionRecipe
implements EmiRecipe {
    private static final ResourceLocation ARROW = ResourceLocation.fromNamespaceAndPath((String)"tfg", (String)"textures/gui/emi/arrow.png");
    private final List<EmiIngredient> INPUTS = new ArrayList<EmiIngredient>();
    private final List<EmiStack> OUTPUTS = new ArrayList<EmiStack>();
    private final List<EmiIngredient> TOOL = new ArrayList<EmiIngredient>();

    public BlockInteractionRecipe(TagKey<Item> INPUT, TagKey<Item> OUTPUT, TagKey<Item> TOOL) {
        this.INPUTS.add(EmiIngredient.of(INPUT));
        ForgeRegistries.ITEMS.tags().getTag(OUTPUT).forEach(i -> this.OUTPUTS.add(EmiStack.of((ItemLike)i)));
        this.TOOL.add(EmiIngredient.of(TOOL));
    }

    public BlockInteractionRecipe(TagKey<Item> INPUT, TagKey<Item> OUTPUT, Item CONSUMABLE) {
        new BlockInteractionRecipe(INPUT, OUTPUT, CONSUMABLE.m_7968_());
    }

    public BlockInteractionRecipe(TagKey<Item> INPUT, TagKey<Item> OUTPUT, ItemStack CONSUMABLE) {
        this.INPUTS.add(EmiIngredient.of(INPUT));
        ForgeRegistries.ITEMS.tags().getTag(OUTPUT).forEach(i -> this.OUTPUTS.add(EmiStack.of((ItemLike)i)));
        this.TOOL.add(EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{CONSUMABLE})));
    }

    public BlockInteractionRecipe(Item INPUT, Item OUTPUT, Item CONSUMABLE) {
        new BlockInteractionRecipe(INPUT, OUTPUT, CONSUMABLE.m_7968_());
    }

    public BlockInteractionRecipe(Item INPUT, Item OUTPUT, TagKey<Item> TOOL) {
        this.INPUTS.add(EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{INPUT})));
        this.OUTPUTS.add(EmiStack.of((ItemLike)OUTPUT));
        this.TOOL.add(EmiIngredient.of(TOOL));
    }

    public BlockInteractionRecipe(Item INPUT, Item OUTPUT, ItemStack CONSUMABLE) {
        this.INPUTS.add(EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{INPUT})));
        this.OUTPUTS.add(EmiStack.of((ItemLike)OUTPUT));
        this.TOOL.add(EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{CONSUMABLE})));
    }

    public EmiRecipeCategory getCategory() {
        return TFGEmiPlugin.BLOCK_INTERACTION;
    }

    @Nullable
    public ResourceLocation getId() {
        return TFGCore.id(this.INPUTS.toString() + "_" + this.OUTPUTS.toString() + "_block_interaction_emi");
    }

    public int getDisplayWidth() {
        return 140;
    }

    public int getDisplayHeight() {
        return 28;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        int itemOffsetY = 5;
        int itemOffsetX = 25;
        this.createItemWidget(widgetHolder, itemOffsetY, itemOffsetX, EmiIngredient.of(this.INPUTS));
        this.createItemWidget(widgetHolder, itemOffsetY, itemOffsetX += 20, EmiIngredient.of(this.TOOL));
        itemOffsetX += 20;
        itemOffsetX = this.createArrowWidget(widgetHolder, itemOffsetY, itemOffsetX, 30);
        this.createItemWidget(widgetHolder, itemOffsetY, itemOffsetX, EmiIngredient.of(this.OUTPUTS));
    }

    private int createItemWidget(WidgetHolder holder, int offsetY, int offsetX, EmiIngredient stack) {
        SlotWidget widget = new SlotWidget(stack, offsetX, offsetY);
        holder.add((Widget)widget);
        return widget.getBounds().bottom() + 2;
    }

    private int createArrowWidget(WidgetHolder holder, int offsetY, int offsetX, int length) {
        int image_height = 18;
        int image_width = 40;
        int u_start = image_width - length;
        TextureWidget widget = new TextureWidget(ARROW, offsetX, offsetY, length, image_height, u_start, 0, length, image_height - 1, image_width, image_height);
        holder.add((Widget)widget);
        return offsetX + 2 + length;
    }

    public List<EmiIngredient> getInputs() {
        return Stream.concat(this.INPUTS.stream(), this.TOOL.stream()).collect(Collectors.toList());
    }

    public List<EmiStack> getOutputs() {
        return this.OUTPUTS;
    }
}

