/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.compat.emi.TFGEmiPlugin;

public class SolidBlazeBurnerRecipe
implements EmiRecipe {
    private final Item ITEM;
    private final Integer BURN_TIME;
    private final Boolean SUPERHEAT;

    public SolidBlazeBurnerRecipe(Item ITEM, Boolean SUPERHEAT) {
        this.ITEM = ITEM;
        this.SUPERHEAT = SUPERHEAT;
        int burn_tick = ForgeHooks.getBurnTime((ItemStack)ITEM.m_7968_(), null);
        if (burn_tick == 0) {
            burn_tick = 1600;
        }
        if (SUPERHEAT.booleanValue()) {
            burn_tick = 3600;
        }
        this.BURN_TIME = burn_tick / 20;
    }

    public EmiRecipeCategory getCategory() {
        return TFGEmiPlugin.BLAZE_BURNER;
    }

    @Nullable
    public ResourceLocation getId() {
        return TFGCore.id(String.valueOf(this.ITEM.m_7968_().m_41611_()) + "_blaze_burner_emi");
    }

    public int getDisplayWidth() {
        return 140;
    }

    public int getDisplayHeight() {
        int defaultHeight = 38;
        if (this.SUPERHEAT.booleanValue()) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            return defaultHeight + 9;
        }
        return defaultHeight;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        int offsetY = 5;
        offsetY = this.createItemWidget(widgetHolder, offsetY);
        offsetY = this.createBurnerStatsWidget(widgetHolder, offsetY);
    }

    private int createItemWidget(WidgetHolder holder, int offsetY) {
        int offsetX = 2;
        SlotWidget widget = new SlotWidget((EmiIngredient)EmiStack.of((ItemLike)this.ITEM), offsetX, offsetY);
        holder.add((Widget)widget);
        return widget.getBounds().bottom() + 2;
    }

    private int createBurnerStatsWidget(WidgetHolder holder, int offsetY) {
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        int lineHeight = 9;
        holder.addText((Component)Component.m_237110_((String)"tfg.emi.liquid_bb_burn_time", (Object[])new Object[]{this.BURN_TIME}), 2, offsetY, 0xFFFFFF, true);
        offsetY += lineHeight;
        if (this.SUPERHEAT.booleanValue()) {
            holder.addText((Component)Component.m_237115_((String)"tfg.emi.liquid_bb_superheat"), 2, offsetY, 0xFFFFFF, true);
        }
        return offsetY;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiStack.of((ItemLike)this.ITEM));
    }

    public List<EmiStack> getOutputs() {
        return List.of();
    }
}

