/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.compat.emi;

import com.forsteri.createliquidfuel.core.BurnerStomachHandler;
import com.forsteri.createliquidfuel.util.Triplet;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Arrays;
import java.util.Map;
import net.dries007.tfc.common.items.TFCItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.compat.emi.BlockInteractionInfo;
import su.terrafirmagreg.core.compat.emi.ExportedOreVeinInfo;
import su.terrafirmagreg.core.compat.emi.LiquidBlazeBurnerRecipe;
import su.terrafirmagreg.core.compat.emi.OreVeinInfoRecipe;
import su.terrafirmagreg.core.compat.emi.SolidBlazeBurnerRecipe;

@EmiEntrypoint
public class TFGEmiPlugin
implements EmiPlugin {
    public static final EmiRecipeCategory ORE_VEIN_INFO = new EmiRecipeCategory(TFGCore.id("ore_vein_info"), (EmiRenderable)EmiStack.of((ItemLike)GTItems.PROSPECTOR_HV));
    public static final EmiRecipeCategory BLAZE_BURNER = new EmiRecipeCategory(TFGCore.id("blaze_burner"), (EmiRenderable)EmiStack.of((ItemLike)AllBlocks.BLAZE_BURNER.m_5456_()));
    public static final EmiRecipeCategory BLOCK_INTERACTION = new EmiRecipeCategory(TFGCore.id("block_interaction"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)TFCItems.MORTAR.get())));

    public void register(EmiRegistry emiRegistry) {
        emiRegistry.addCategory(ORE_VEIN_INFO);
        emiRegistry.addWorkstation(ORE_VEIN_INFO, (EmiIngredient)EmiStack.of((ItemLike)GTItems.PROSPECTOR_LV));
        emiRegistry.addWorkstation(ORE_VEIN_INFO, (EmiIngredient)EmiStack.of((ItemLike)GTItems.PROSPECTOR_HV));
        emiRegistry.addWorkstation(ORE_VEIN_INFO, (EmiIngredient)EmiStack.of((ItemLike)GTItems.PROSPECTOR_LuV));
        Arrays.stream(ExportedOreVeinInfo.RECIPES).forEach(arg_0 -> ((EmiRegistry)emiRegistry).addRecipe(arg_0));
        emiRegistry.addRecipe((EmiRecipe)new OreVeinInfoRecipe("nether_anthracite", "minecraft:the_nether", 35, 0.8, 48, 127, 13, 4, 0, new String[]{"minecraft:deepslate"}, new OreVeinInfoRecipe.WeightedBlock[]{new OreVeinInfoRecipe.WeightedBlock("cursecoal", 100)}));
        emiRegistry.addRecipe((EmiRecipe)new OreVeinInfoRecipe("nether_sylvite", "minecraft:the_nether", 75, 0.6, 0, 64, 17, 0, 0, new String[]{"minecraft:blackstone"}, new OreVeinInfoRecipe.WeightedBlock[]{new OreVeinInfoRecipe.WeightedBlock("sylvite", 100)}));
        emiRegistry.addCategory(BLAZE_BURNER);
        emiRegistry.addWorkstation(BLAZE_BURNER, (EmiIngredient)EmiStack.of((ItemLike)AllBlocks.BLAZE_BURNER.m_5456_()));
        for (Map.Entry<Fluid, Pair<ResourceLocation, Triplet<Integer, Boolean, Integer>>> entry : BurnerStomachHandler.LIQUID_BURNER_FUEL_MAP.entrySet()) {
            emiRegistry.addRecipe((EmiRecipe)new LiquidBlazeBurnerRecipe(entry));
        }
        for (Item item : ForgeRegistries.ITEMS.tags().getTag(AllTags.AllItemTags.BLAZE_BURNER_FUEL_REGULAR.tag).stream().toList()) {
            emiRegistry.addRecipe((EmiRecipe)new SolidBlazeBurnerRecipe(item, false));
        }
        for (Item item : ForgeRegistries.ITEMS.tags().getTag(AllTags.AllItemTags.BLAZE_BURNER_FUEL_SPECIAL.tag).stream().toList()) {
            emiRegistry.addRecipe((EmiRecipe)new SolidBlazeBurnerRecipe(item, true));
        }
        emiRegistry.addCategory(BLOCK_INTERACTION);
        Arrays.stream(BlockInteractionInfo.RECIPES).forEach(arg_0 -> ((EmiRegistry)emiRegistry).addRecipe(arg_0));
    }
}

