/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.compat.kjs;

import com.notenoughmail.kubejs_tfc.block.internal.ExtendedPropertiesBlockBuilder;
import com.notenoughmail.kubejs_tfc.event.RegisterInteractionsEventJS;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.Lazy;
import su.terrafirmagreg.core.common.data.blocks.ParticleEmitterDecorationBlock;
import su.terrafirmagreg.core.compat.kjs.ParticleEmitterBlockBuilder;

public class ParticleEmitterDecorationBlockBuilder
extends ExtendedPropertiesBlockBuilder {
    public static final List<Block> REGISTERED_BLOCKS = new ArrayList<Block>();
    public transient VoxelShape cachedShape;
    public transient Supplier<Item> preexistingItem;
    public transient int rotate;
    public transient Supplier<SimpleParticleType> particleType = () -> ParticleTypes.f_123778_;
    public transient double baseX = 0.5;
    public transient double baseY = 0.5;
    public transient double baseZ = 0.5;
    public transient double offsetX = 0.25;
    public transient double offsetY = 1.0;
    public transient double offsetZ = 0.25;
    public transient double velocityX = 0.0;
    public transient double velocityY = 0.0;
    public transient double velocityZ = 0.0;
    public transient int particleCount = 1;
    public transient boolean particleForced = false;
    public transient boolean useDustOptions = false;
    public transient float dustRed = 1.0f;
    public transient float dustGreen = 0.0f;
    public transient float dustBlue = 0.0f;
    public transient float dustScale = 1.0f;
    private transient boolean hasTicker = false;
    public transient int emitDelay = 0;

    public ParticleEmitterDecorationBlockBuilder(ResourceLocation i) {
        super(i);
        this.noCollision = true;
        this.hardness = 0.0f;
        this.rotate = 0;
        this.fullBlock = false;
        this.opaque = false;
        this.notSolid = true;
        this.renderType = "cutout";
        this.soundType = SoundType.f_56740_;
        this.mapColor(MapColor.f_283808_);
    }

    @Info(value="Enable/disable block entity ticker (default false).")
    public ParticleEmitterDecorationBlockBuilder hasTicker(boolean enabled) {
        this.hasTicker = enabled;
        return this;
    }

    @Info(value="Random emission delay scale")
    public ParticleEmitterDecorationBlockBuilder emitDelay(int delay) {
        this.emitDelay = Math.max(0, delay);
        return this;
    }

    @Info(value="Starting emission position (default: center -> 0.5, 0.5, 0.5).")
    public ParticleEmitterDecorationBlockBuilder particleBase(double x, double y, double z) {
        this.baseX = x;
        this.baseY = y;
        this.baseZ = z;
        return this;
    }

    @Info(value="Attach existing item instead of generating new.")
    public ParticleEmitterDecorationBlockBuilder withPreexistingItem(ResourceLocation item) {
        this.itemBuilder = null;
        this.preexistingItem = Lazy.of(() -> (Item)RegistryInfo.ITEM.getValue(item));
        RegisterInteractionsEventJS.addBlockItemPlacement(this.preexistingItem, (Supplier)((Object)this));
        return this;
    }

    @Info(value="Rotate generated models 45 degrees.")
    public ParticleEmitterDecorationBlockBuilder notAxisAligned() {
        this.rotate = 45;
        return this;
    }

    @Info(value="Particle type id (SimpleParticleType 'minecraft:dust' enables dust options).")
    public ParticleEmitterDecorationBlockBuilder particle(String id) {
        ResourceLocation rl = ResourceLocation.m_135820_((String)id);
        this.particleType = Lazy.of(() -> {
            ParticleType pt = (ParticleType)RegistryInfo.PARTICLE_TYPE.getValue(rl);
            if (pt instanceof SimpleParticleType) {
                SimpleParticleType simple = (SimpleParticleType)pt;
                if (id.equals("minecraft:dust")) {
                    this.useDustOptions = true;
                }
                return simple;
            }
            throw new IllegalArgumentException("Particle type '" + id + "' is not a SimpleParticleType");
        });
        return this;
    }

    @Info(value="Random spread ranges (default 0.25, 1.0, 0.25).")
    public ParticleEmitterDecorationBlockBuilder particleOffset(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return this;
    }

    @Info(value="Particle velocity (default 0, 0, 0).")
    public ParticleEmitterDecorationBlockBuilder particleVelocity(double x, double y, double z) {
        this.velocityX = x;
        this.velocityY = y;
        this.velocityZ = z;
        return this;
    }

    @Info(value="Particles per emission (>=1; default 1).")
    public ParticleEmitterDecorationBlockBuilder particleCount(int count) {
        this.particleCount = count;
        return this;
    }

    @Info(value="Always visible (default false).")
    public ParticleEmitterDecorationBlockBuilder particleForced(boolean forced) {
        this.particleForced = forced;
        return this;
    }

    @Info(value="Dust color r, g, b + scale (only if dust particle chosen).")
    public ParticleEmitterDecorationBlockBuilder dustColor(float r, float g, float b, float scale) {
        this.dustRed = r;
        this.dustGreen = g;
        this.dustBlue = b;
        this.dustScale = scale;
        return this;
    }

    @HideFromJS
    public VoxelShape getShape() {
        if (this.customShape.isEmpty()) {
            return ParticleEmitterDecorationBlock.DEFAULT_SHAPE;
        }
        if (this.cachedShape == null) {
            this.cachedShape = BlockBuilder.createShape((List)this.customShape);
        }
        return this.cachedShape;
    }

    @HideFromJS
    public Supplier<Item> itemSupplier() {
        if (this.preexistingItem != null) {
            return this.preexistingItem;
        }
        if (this.itemBuilder != null) {
            return this.itemBuilder;
        }
        return null;
    }

    public ParticleEmitterDecorationBlock createObject() {
        BlockBehaviour.Properties props = this.createProperties().m_222979_(BlockBehaviour.OffsetType.XZ);
        ParticleEmitterDecorationBlock block = new ParticleEmitterDecorationBlock(props, this.getShape(), this.itemSupplier(), this.particleType, this.baseX, this.baseY, this.baseZ, this.offsetX, this.offsetY, this.offsetZ, this.velocityX, this.velocityY, this.velocityZ, this.particleCount, this.particleForced, this.useDustOptions, this.dustRed, this.dustGreen, this.dustBlue, this.dustScale, this.hasTicker, this.emitDelay);
        if (this.hasTicker) {
            REGISTERED_BLOCKS.add(block);
            ParticleEmitterBlockBuilder.REGISTERED_BLOCKS.add(block);
        }
        return block;
    }
}

