/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.compat.kjs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.notenoughmail.kubejs_tfc.block.internal.ExtendedPropertiesBlockBuilder;
import com.notenoughmail.kubejs_tfc.event.RegisterInteractionsEventJS;
import com.notenoughmail.kubejs_tfc.util.ResourceUtils;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import dev.latvian.mods.kubejs.loot.LootTableEntry;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.Lazy;
import su.terrafirmagreg.core.common.data.blocks.TallDecorativePlantBlock;

public class TallDecorativePlantBlockBuilder
extends ExtendedPropertiesBlockBuilder {
    public transient VoxelShape cachedShape;
    public transient Supplier<Item> preexistingItem;
    public transient int maxHeight;

    public TallDecorativePlantBlockBuilder(ResourceLocation i) {
        super(i);
        this.noCollision = true;
        this.hardness = 0.0f;
        this.fullBlock = false;
        this.opaque = false;
        this.notSolid = true;
        this.renderType = "cutout";
        this.soundType = SoundType.f_56740_;
        this.maxHeight = 2;
        this.mapColor(MapColor.f_283808_);
        this.tagBlock(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"mineable/hoe"));
    }

    @Info(value="Sets the 'block item' of this block to an existing item")
    public TallDecorativePlantBlockBuilder withPreexistingItem(ResourceLocation item) {
        this.itemBuilder = null;
        this.preexistingItem = Lazy.of(() -> (Item)RegistryInfo.ITEM.getValue(item));
        RegisterInteractionsEventJS.addBlockItemPlacement(this.preexistingItem, (Supplier)((Object)this));
        return this;
    }

    @Info(value="Sets how tall the plant is")
    public TallDecorativePlantBlockBuilder height(int height) {
        this.maxHeight = height;
        return this;
    }

    @HideFromJS
    public VoxelShape getShape() {
        if (this.customShape.isEmpty()) {
            return TallDecorativePlantBlock.DEFAULT_SHAPE;
        }
        if (this.cachedShape == null) {
            this.cachedShape = BlockBuilder.createShape((List)this.customShape);
        }
        return this.cachedShape;
    }

    @HideFromJS
    public Supplier<Item> itemSupplier() {
        if (this.preexistingItem != null) {
            return this.preexistingItem;
        }
        if (this.itemBuilder != null) {
            return this.itemBuilder;
        }
        return null;
    }

    public TallDecorativePlantBlock createObject() {
        return new TallDecorativePlantBlock(this.createExtendedProperties().offsetType(BlockBehaviour.OffsetType.XZ), this.getShape(), this.maxHeight);
    }

    public void generateDataJsons(DataJsonGenerator generator) {
        ResourceUtils.lootTable(b -> b.addPool(p -> {
            p.survivesExplosion();
            p.addEntry(ResourceUtils.alternatives((LootTableEntry[])new LootTableEntry[]{this.lootEntryBase("tfc:knives")}));
            p.addEntry(ResourceUtils.alternatives((LootTableEntry[])new LootTableEntry[]{this.lootEntryBase("tfc:hoes")}));
            p.addEntry(ResourceUtils.alternatives((LootTableEntry[])new LootTableEntry[]{this.lootEntryBase("tfc:scythes")}));
        }), (DataJsonGenerator)generator, (BlockBuilder)this);
    }

    private LootTableEntry lootEntryBase(String tag) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:item");
        if (this.preexistingItem != null) {
            json.addProperty("name", this.preexistingItem.get().toString());
        } else {
            json.addProperty("name", this.itemBuilder.id.toString());
        }
        return new LootTableEntry(json).addCondition(ResourceUtils.buildJson(condition -> {
            condition.addProperty("condition", "minecraft:match_tool");
            condition.add("predicate", (JsonElement)ResourceUtils.buildJson(predicate -> predicate.addProperty("tag", tag)));
        }));
    }
}

