/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.mixins.common.wab;

import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.wanmine.wab.entity.Soarer;
import net.wanmine.wab.init.data.WabTags;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import su.terrafirmagreg.core.common.data.entities.soarer.SoarerData;

@Mixin(value={Soarer.class})
public abstract class SoarerMixin
extends TamableAnimal {
    @Unique
    private long tfg$nextFeedTime = Long.MIN_VALUE;

    protected SoarerMixin(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")})
    public void tfg$finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData groupData, CompoundTag tag, CallbackInfoReturnable<SpawnGroupData> cir) {
        this.tfg$setIsMale(this.f_19796_.m_188499_());
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void tfg$defineSyncedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(SoarerData.DATA_IS_MALE, (Object)true);
        this.f_19804_.m_135372_(SoarerData.DATA_FAMILIARITY, (Object)Float.valueOf(0.0f));
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void tfg$readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        this.tfg$setFamiliarity(tag.m_128457_("familiarity"));
        this.tfg$setIsMale(tag.m_128471_("male"));
        this.tfg$nextFeedTime = tag.m_128454_("nextFeed");
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    public void tfg$addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128379_("male", this.tfg$isMale());
        tag.m_128350_("familiarity", this.tfg$getFamiliarity());
        tag.m_128356_("nextFeed", this.tfg$nextFeedTime);
    }

    @Unique
    public float tfg$getFamiliarity() {
        return ((Float)this.f_19804_.m_135370_(SoarerData.DATA_FAMILIARITY)).floatValue();
    }

    @Unique
    public void tfg$setFamiliarity(float familiarity) {
        this.f_19804_.m_135381_(SoarerData.DATA_FAMILIARITY, (Object)Float.valueOf(familiarity));
    }

    @Unique
    public void tfg$setIsMale(boolean male) {
        this.f_19804_.m_135381_(SoarerData.DATA_IS_MALE, (Object)male);
    }

    @Unique
    public boolean tfg$isMale() {
        return (Boolean)this.f_19804_.m_135370_(SoarerData.DATA_IS_MALE);
    }

    @Inject(method={"canMate"}, at={@At(value="HEAD")}, cancellable=true)
    public void tfg$canMate(Animal pOtherAnimal, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"isFood"}, at={@At(value="HEAD")}, cancellable=true)
    public void tfg$isFood(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)(!FoodCapability.isRotten((ItemStack)stack) && Helpers.isItem((ItemStack)stack, (TagKey)WabTags.Items.SURFER_FOOD) ? 1 : 0));
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    public void tfg$mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack held = player.m_21120_(hand);
        if (this.m_6898_(held)) {
            long ticks;
            if (!this.m_9236_().f_46443_ && (ticks = Calendars.SERVER.getTicks()) > this.tfg$nextFeedTime) {
                this.tfg$setFamiliarity(this.tfg$getFamiliarity() + 0.07f);
                this.tfg$nextFeedTime = ticks + 24000L;
                this.m_142075_(player, hand, held);
                this.m_216990_(SoundEvents.f_12321_);
                if (this.m_21824_()) {
                    this.m_21828_(player);
                }
            }
            if (this.m_21824_()) {
                ((Soarer)this).addFlaps(10);
                this.m_142075_(player, hand, held);
                this.m_216990_(SoundEvents.f_12321_);
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }

    public boolean m_21824_() {
        return this.tfg$getFamiliarity() > 0.15f;
    }

    @ModifyArg(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/wanmine/wab/entity/Soarer;setDeltaMovement(DDD)V", ordinal=2), index=1)
    public double tfg$tick(double par1) {
        return par1 / 1.5;
    }
}

