/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.utils;

import earth.terrarium.adastra.api.planets.Planet;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec2;
import su.terrafirmagreg.core.common.data.TFGBlocks;
import su.terrafirmagreg.core.common.data.blocks.AbstractLayerBlock;
import su.terrafirmagreg.core.common.data.blocks.SandLayerBlock;
import su.terrafirmagreg.core.common.data.blocks.SandPileBlock;
import su.terrafirmagreg.core.config.TFGConfig;
import su.terrafirmagreg.core.utils.PlanetEnvironmentalHelpers;

public final class MarsEnvironmentalHelpers {
    public static final float DUST_SETTLE_SPEED = 0.4f;
    public static final float DUST_LOOSEN_SPEED = 0.2f;
    public static Vec2 wind_override = Vec2.f_82462_;
    public static float dustiness_override = 0.0f;

    public static boolean isSand(BlockState state) {
        return state.m_60734_() instanceof SandPileBlock;
    }

    public static void tickChunk(ServerLevel level, LevelChunk chunk, ProfilerFiller profiler) {
        if (!level.m_46472_().equals((Object)Planet.MARS)) {
            return;
        }
        ChunkPos chunkPos = chunk.m_7697_();
        BlockPos lcgPos = level.m_46496_(chunkPos.m_45604_(), 0, chunkPos.m_45605_(), 15);
        BlockPos surfacePos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, lcgPos);
        float temperature = Climate.getTemperature((Level)level, (BlockPos)surfacePos);
        if (temperature < -108.0f) {
            return;
        }
        Vec2 wind = Climate.getWindVector((Level)level, (BlockPos)surfacePos);
        profiler.m_6180_("tfgSand");
        MarsEnvironmentalHelpers.doSand((Level)level, surfacePos, wind);
        profiler.m_7238_();
    }

    private static void doSand(Level level, BlockPos surfacePos, Vec2 wind) {
        RandomSource random = level.f_46441_;
        float windLength = wind.m_165907_();
        int expectedLayers = (int)MarsEnvironmentalHelpers.getExpectedSandLayerHeight(windLength);
        if (windLength >= 0.4f) {
            if (random.m_188503_(((Integer)TFGConfig.SERVER.sandAccumulateChance.get()).intValue()) == 0 && !MarsEnvironmentalHelpers.placeSandOrSandPile(level, surfacePos, random, expectedLayers) && !MarsEnvironmentalHelpers.placeSandOrSandPile(level, surfacePos.m_7495_(), random, expectedLayers)) {
                MarsEnvironmentalHelpers.placeSandOrSandPile(level, surfacePos.m_6625_(2), random, expectedLayers);
            }
        } else if (windLength <= 0.2f && random.m_188503_(((Integer)TFGConfig.SERVER.sandDecumulateChance.get()).intValue()) == 0) {
            MarsEnvironmentalHelpers.removeSandAt((LevelAccessor)level, surfacePos, expectedLayers);
            if (random.m_188501_() < 0.2f) {
                MarsEnvironmentalHelpers.removeSandAt((LevelAccessor)level, surfacePos.m_121945_(Direction.Plane.HORIZONTAL.m_235690_(random)), expectedLayers);
            }
        }
    }

    private static void removeSandAt(LevelAccessor level, BlockPos surfacePos, int expectedLayers) {
        BlockState state = level.m_8055_(surfacePos);
        if (MarsEnvironmentalHelpers.isSand(state)) {
            SandPileBlock.removePileOrSand(level, surfacePos, state, expectedLayers);
        }
    }

    private static boolean placeSandOrSandPile(Level level, BlockPos initialPos, RandomSource random, int expectedLayers) {
        if (expectedLayers < 1) {
            return false;
        }
        BlockPos pos = MarsEnvironmentalHelpers.findOptimalSandLocation((LevelAccessor)level, initialPos, level.m_8055_(initialPos), random);
        BlockState state = level.m_8055_(pos);
        if (initialPos.equals((Object)pos) && !level.m_45527_(pos)) {
            return false;
        }
        return MarsEnvironmentalHelpers.placeSandOrSandPileAt((LevelAccessor)level, pos, state, random, expectedLayers);
    }

    private static boolean placeSandOrSandPileAt(LevelAccessor level, BlockPos pos, BlockState state, RandomSource random, int expectedLayers) {
        if (MarsEnvironmentalHelpers.isSand(state) && (Integer)state.m_61143_((Property)AbstractLayerBlock.f_56581_) < 7) {
            int currentLayers = (Integer)state.m_61143_((Property)AbstractLayerBlock.f_56581_);
            BlockState newState = (BlockState)state.m_61124_((Property)AbstractLayerBlock.f_56581_, (Comparable)Integer.valueOf(currentLayers + 1));
            if (newState.m_60710_((LevelReader)level, pos) && random.m_188503_(1 + 3 * currentLayers) == 0 && expectedLayers > currentLayers) {
                level.m_7731_(pos, newState, 3);
            }
            return true;
        }
        if (SandPileBlock.canPlaceSandPile(level, pos, state)) {
            SandPileBlock.placeSandPile(level, pos, state, false);
            return true;
        }
        if (state.m_60795_() && ((SandLayerBlock)((Object)TFGBlocks.MARS_SAND_LAYER_BLOCK.get())).m_49966_().m_60710_((LevelReader)level, pos)) {
            level.m_7731_(pos, PlanetEnvironmentalHelpers.getSandBlockForBiome((LevelReader)level, pos).m_49966_(), 3);
            return true;
        }
        return false;
    }

    public static float getExpectedSandLayerHeight(float windStrength) {
        if (windStrength <= 0.2f) {
            return 0.0f;
        }
        if (windStrength <= 0.25f) {
            return 1.0f;
        }
        if (windStrength <= 0.35f) {
            return 2.0f;
        }
        return 3.0f;
    }

    private static BlockPos findOptimalSandLocation(LevelAccessor level, BlockPos pos, BlockState state, RandomSource random) {
        BlockPos targetPos = null;
        int found = 0;
        if (MarsEnvironmentalHelpers.isSand(state)) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos adjPos = pos.m_121945_(direction);
                BlockState adjState = level.m_8055_(adjPos);
                if ((!MarsEnvironmentalHelpers.isSand(adjState) || (Integer)adjState.m_61143_((Property)AbstractLayerBlock.f_56581_) >= (Integer)state.m_61143_((Property)AbstractLayerBlock.f_56581_)) && (!adjState.m_60795_() && !Helpers.isBlock((Block)adjState.m_60734_(), (TagKey)TFCTags.Blocks.CAN_BE_SNOW_PILED) || !((SandLayerBlock)((Object)TFGBlocks.MARS_SAND_LAYER_BLOCK.get())).m_49966_().m_60710_((LevelReader)level, adjPos)) || targetPos != null && random.m_188503_(++found) != 0) continue;
                targetPos = adjPos;
            }
            if (targetPos != null) {
                return targetPos;
            }
        }
        return pos;
    }

    public static void setDustIntensity(float intensity) {
        dustiness_override = intensity;
    }

    public static void setWind(float strength) {
        wind_override = (double)wind_override.m_165912_() == 0.0 ? new Vec2(1.0f, 0.0f).m_165903_(strength) : wind_override.m_165902_().m_165903_(strength);
    }

    public static void setWind(Vec2 vector) {
        wind_override = vector;
    }
}

