/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.registry.MaterialRegistry;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.terrafirmagreg.core.client.TFGClientEventHandler;
import su.terrafirmagreg.core.common.TFGCommonEventHandler;
import su.terrafirmagreg.core.common.data.TFGBlockEntities;
import su.terrafirmagreg.core.common.data.TFGBlocks;
import su.terrafirmagreg.core.common.data.TFGContainers;
import su.terrafirmagreg.core.common.data.TFGCreativeTab;
import su.terrafirmagreg.core.common.data.TFGEffects;
import su.terrafirmagreg.core.common.data.TFGEntities;
import su.terrafirmagreg.core.common.data.TFGEntityDataSerializers;
import su.terrafirmagreg.core.common.data.TFGEvents;
import su.terrafirmagreg.core.common.data.TFGFluids;
import su.terrafirmagreg.core.common.data.TFGFoodTraits;
import su.terrafirmagreg.core.common.data.TFGItems;
import su.terrafirmagreg.core.common.data.TFGParticles;
import su.terrafirmagreg.core.common.data.entities.ai.TFGBrain;
import su.terrafirmagreg.core.common.data.tfgt.TFGRecipeTypes;
import su.terrafirmagreg.core.common.data.tfgt.machine.TFGMachines;
import su.terrafirmagreg.core.common.data.tfgt.machine.TFGMultiMachines;
import su.terrafirmagreg.core.compat.ad_astra.AdAstraCompat;
import su.terrafirmagreg.core.compat.create.CustomArmInteractionPointTypes;
import su.terrafirmagreg.core.config.TFGConfig;
import su.terrafirmagreg.core.network.TFGNetworkHandler;
import su.terrafirmagreg.core.world.TFGFeatures;
import su.terrafirmagreg.core.world.TFGSurfaceRules;

@Mod(value="tfg")
public final class TFGCore {
    public static final String MOD_ID = "tfg";
    public static final String NAME = "TerraFirmaGreg-Core";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"TerraFirmaGreg-Core");
    public static final GTRegistrate REGISTRATE = GTRegistrate.create((String)"tfg");
    public static MaterialRegistry MATERIAL_REGISTRY;

    public TFGCore() {
        TFGConfig.init();
        TFGCommonEventHandler.init();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            new TFGClientEventHandler();
        }
        TFGCore.setupFixForGlobalServerConfig();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        TFGNetworkHandler.init();
        TFGBlocks.BLOCKS.register(bus);
        TFGBlockEntities.BLOCK_ENTITIES.register(bus);
        TFGItems.ITEMS.register(bus);
        TFGCreativeTab.TABS.register(bus);
        TFGFeatures.FEATURES.register(bus);
        TFGEntities.ENTITIES.register(bus);
        TFGParticles.register(bus);
        TFGFluids.FLUIDS.register(bus);
        TFGSurfaceRules.SURFACE_RULES.register(bus);
        TFGContainers.CONTAINERS.register(bus);
        TFGEntityDataSerializers.ENTITY_DATA_SERIALIZERS.register(bus);
        TFGEffects.EFFECTS.register(bus);
        TFGBrain.MEMORY_TYPES.register(bus);
        TFGBrain.SENSOR_TYPES.register(bus);
        TFGBrain.POI_TYPES.register(bus);
        TFGEvents.register();
        TFGFoodTraits.init();
        bus.addGenericListener(MachineDefinition.class, this::registerMachines);
        bus.addGenericListener(GTRecipeType.class, this::registerRecipeTypes);
        bus.addListener(TFGEntities::onAttributes);
        bus.addListener(TFGEntities::onSpawnPlacement);
        bus.addListener(TFGEntities::onEntityRenderers);
        bus.addListener(TFGEntities::onEntityLayerRegister);
        bus.addListener(CustomArmInteractionPointTypes::onRegister);
        AdAstraCompat.RegisterEvents();
    }

    public static ResourceLocation id(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    private static void setupFixForGlobalServerConfig() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    @SubscribeEvent
    public void registerMachines(GTCEuAPI.RegisterEvent<ResourceLocation, MachineDefinition> event) {
        TFGMachines.init();
        TFGMultiMachines.init();
    }

    @SubscribeEvent
    public void registerRecipeTypes(GTCEuAPI.RegisterEvent<ResourceLocation, GTRecipeType> event) {
        TFGRecipeTypes.init();
    }
}

