/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.client;

import lombok.Generated;
import net.dries007.tfc.client.ClientHelpers;
import net.dries007.tfc.client.ClimateRenderCache;
import net.dries007.tfc.client.particle.TFCParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec2;
import su.terrafirmagreg.core.client.TFGClientHelpers;
import su.terrafirmagreg.core.common.data.TFGParticles;
import su.terrafirmagreg.core.common.data.TFGTags;
import su.terrafirmagreg.core.utils.MarsEnvironmentalHelpers;

public class TFGWindManager {

    public static class Mars
    implements IWindTicker {
        private static int particleMultiplier = 32;
        private static float windThreshold = 0.2f;
        private static int biomeChecks = 4;

        private static ParticleOptions getParticleForBiome(Holder<Biome> biome) {
            ParticleOptions darkWind = (ParticleOptions)TFGParticles.DARK_MARS_WIND.get();
            ParticleOptions mediumWind = (ParticleOptions)TFGParticles.MEDIUM_MARS_WIND.get();
            ParticleOptions lightWind = (ParticleOptions)TFGParticles.LIGHT_MARS_WIND.get();
            if (biome.m_203656_(TFGTags.Biomes.HasDarkSandWind)) {
                return darkWind;
            }
            if (biome.m_203656_(TFGTags.Biomes.HasMediumSandWind)) {
                return mediumWind;
            }
            if (biome.m_203656_(TFGTags.Biomes.HasLightSandWind)) {
                return lightWind;
            }
            return (ParticleOptions)TFCParticles.WIND.get();
        }

        public static void tickWind(Level level) {
            Player player = ClientHelpers.getPlayer();
            if (player != null && level != null && level.m_46467_() % 2L == 0L) {
                BlockPos pos = player.m_20183_();
                Vec2 wind = (double)MarsEnvironmentalHelpers.wind_override.m_165912_() == 0.0 ? ClimateRenderCache.INSTANCE.getWind() : MarsEnvironmentalHelpers.wind_override;
                float windStrength = wind.m_165907_();
                int count = 0;
                if (windStrength > windThreshold) {
                    count = (int)(windStrength * (float)particleMultiplier);
                }
                if (count == 0) {
                    return;
                }
                Vec2 offsetVec = wind.m_165902_().m_165903_(-15.0f);
                int particlesPerCheck = (int)Math.ceil((double)count / (double)biomeChecks);
                for (int i = 0; i < biomeChecks; ++i) {
                    Vec2 randCheckVector = TFGClientHelpers.nextVec2InRadius(level.f_46441_, 12.0f);
                    double checkX = (float)pos.m_123341_() + offsetVec.f_82470_ + randCheckVector.f_82470_;
                    double checkZ = (float)pos.m_123343_() + offsetVec.f_82471_ + randCheckVector.f_82471_;
                    BlockPos biomeCheckPos = new BlockPos((int)checkX, pos.m_123342_(), (int)checkZ);
                    Holder biome = level.m_204166_(biomeCheckPos);
                    ParticleOptions particle = Mars.getParticleForBiome((Holder<Biome>)biome);
                    for (int j = 0; j < particlesPerCheck; ++j) {
                        double z;
                        double y;
                        Vec2 randParticleVector = TFGClientHelpers.nextVec2InRadius(level.f_46441_, 12.0f);
                        double x = (float)pos.m_123341_() + offsetVec.f_82470_ + randParticleVector.f_82470_;
                        if (!level.m_45527_(BlockPos.m_274561_((double)x, (double)(y = (double)pos.m_123342_() + Mth.m_216263_((RandomSource)level.f_46441_, (double)-1.0, (double)8.0)), (double)(z = (double)((float)pos.m_123343_() + offsetVec.f_82471_ + randParticleVector.f_82471_))))) continue;
                        level.m_7106_(particle, x, y, z, 0.0, 0.0, 0.0);
                    }
                }
            }
        }

        @Generated
        public static void setParticleMultiplier(int particleMultiplier) {
            Mars.particleMultiplier = particleMultiplier;
        }

        @Generated
        public static void setWindThreshold(float windThreshold) {
            Mars.windThreshold = windThreshold;
        }

        @Generated
        public static void setBiomeChecks(int biomeChecks) {
            Mars.biomeChecks = biomeChecks;
        }
    }

    private static interface IWindTicker {
        public static void tickWind() {
        }
    }
}

