/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.registry.MaterialRegistry;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.core.mixins.BlockBehaviourAccessor;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IcicleBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.soil.ConnectedGrassBlock;
import net.dries007.tfc.common.blocks.soil.DirtBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.PathBlock;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import su.terrafirmagreg.core.common.data.TFGBlockEntities;
import su.terrafirmagreg.core.common.data.TFGFluids;
import su.terrafirmagreg.core.common.data.TFGItems;
import su.terrafirmagreg.core.common.data.blockentity.LargeNestBoxBlockEntity;
import su.terrafirmagreg.core.common.data.blocks.DryIceBlock;
import su.terrafirmagreg.core.common.data.blocks.ElectromagneticAcceleratorBlock;
import su.terrafirmagreg.core.common.data.blocks.LargeNestBoxBlock;
import su.terrafirmagreg.core.common.data.blocks.LunarChorusFlowerBlock;
import su.terrafirmagreg.core.common.data.blocks.LunarChorusPlantBlock;
import su.terrafirmagreg.core.common.data.blocks.MarsIceBlock;
import su.terrafirmagreg.core.common.data.blocks.PiglinDisguiseBlock;
import su.terrafirmagreg.core.common.data.blocks.ReflectorBlock;
import su.terrafirmagreg.core.common.data.blocks.SandLayerBlock;
import su.terrafirmagreg.core.common.data.blocks.SandPileBlock;
import su.terrafirmagreg.core.common.data.blocks.SimpleBlock;
import su.terrafirmagreg.core.common.data.buds.BudIndicator;
import su.terrafirmagreg.core.common.data.buds.BudIndicatorItem;

public final class TFGBlocks {
    static ImmutableMap.Builder<Material, BlockEntry<BudIndicator>> BUD_BLOCKS_BUILDER = ImmutableMap.builder();
    public static Map<Material, BlockEntry<BudIndicator>> BUD_BLOCKS;
    public static final DeferredRegister<Block> BLOCKS;
    public static final RegistryObject<Block> LUNAR_CHORUS_PLANT;
    public static final RegistryObject<Block> LUNAR_CHORUS_FLOWER;
    public static RegistryObject<Block> MARS_DIRT;
    public static RegistryObject<Block> MARS_CLAY;
    public static final RegistryObject<Block> MARS_PATH;
    public static final RegistryObject<Block> MARS_FARMLAND;
    private static final BlockBehaviour.Properties amber_properties;
    public static final RegistryObject<Block> AMBER_MYCELIUM;
    public static final RegistryObject<Block> AMBER_CLAY_MYCELIUM;
    public static final RegistryObject<Block> AMBER_KAOLIN_MYCELIUM;
    private static final BlockBehaviour.Properties rusticus_properties;
    public static final RegistryObject<Block> RUSTICUS_MYCELIUM;
    public static final RegistryObject<Block> RUSTICUS_CLAY_MYCELIUM;
    public static final RegistryObject<Block> RUSTICUS_KAOLIN_MYCELIUM;
    private static final BlockBehaviour.Properties sangnum_properties;
    public static final RegistryObject<Block> SANGNUM_MYCELIUM;
    public static final RegistryObject<Block> SANGNUM_CLAY_MYCELIUM;
    public static final RegistryObject<Block> SANGNUM_KAOLIN_MYCELIUM;
    public static final RegistryObject<SandLayerBlock> ASH_LAYER_BLOCK;
    public static final RegistryObject<SandLayerBlock> BLACK_SAND_LAYER_BLOCK;
    public static final RegistryObject<SandLayerBlock> WHITE_SAND_LAYER_BLOCK;
    public static final RegistryObject<SandLayerBlock> BROWN_SAND_LAYER_BLOCK;
    public static final RegistryObject<SandLayerBlock> RED_SAND_LAYER_BLOCK;
    public static final RegistryObject<SandLayerBlock> YELLOW_SAND_LAYER_BLOCK;
    public static final RegistryObject<SandLayerBlock> PINK_SAND_LAYER_BLOCK;
    public static final RegistryObject<SandLayerBlock> GREEN_SAND_LAYER_BLOCK;
    public static final RegistryObject<SandLayerBlock> MOON_SAND_LAYER_BLOCK;
    public static final RegistryObject<SandLayerBlock> HEMATITIC_SAND_LAYER_BLOCK;
    public static final RegistryObject<SandLayerBlock> MARS_SAND_LAYER_BLOCK;
    public static final RegistryObject<SandLayerBlock> VENUS_SAND_LAYER_BLOCK;
    public static final RegistryObject<SandPileBlock> HEMATITIC_SAND_PILE_BLOCK;
    public static final RegistryObject<SandPileBlock> MARS_SAND_PILE_BLOCK;
    public static final RegistryObject<SandPileBlock> VENUS_SAND_PILE_BLOCK;
    public static final RegistryObject<LiquidBlock> MARS_WATER;
    public static final RegistryObject<Block> PIGLIN_DISGUISE_BLOCK;
    public static final RegistryObject<Block> MARS_ICE;
    public static final RegistryObject<Block> MARS_ICICLE;
    public static final RegistryObject<Block> DRY_ICE;
    public static final RegistryObject<Block> ELECTROMAGNETIC_ACCELERATOR_BLOCK;
    public static final RegistryObject<Block> SUPERCONDUCTOR_COIL_LARGE_BLOCK;
    public static final RegistryObject<Block> SUPERCONDUCTOR_COIL_SMALL_BLOCK;
    public static final RegistryObject<Block> MACHINE_CASING_ALUMINIUM_PLATED_STEEL;
    public static final RegistryObject<ReflectorBlock> REFLECTOR_BLOCK;
    public static final RegistryObject<Block> LARGE_NEST_BOX;
    public static final RegistryObject<Block> LARGE_NEST_BOX_WARPED;
    private static final VanillaBlockLoot BLOCK_LOOT;

    public static void generateBudIndicators() {
        BUD_BLOCKS_BUILDER = ImmutableMap.builder();
        for (MaterialRegistry registry : GTCEuAPI.materialManager.getRegistries()) {
            GTRegistrate registrate = registry.getRegistrate();
            for (Material material : registry.getAllMaterials()) {
                if (!material.hasProperty(PropertyKey.ORE) || !material.hasProperty(PropertyKey.GEM)) continue;
                TFGBlocks.registerBudIndicator(material, registrate, BUD_BLOCKS_BUILDER);
            }
        }
        BUD_BLOCKS = BUD_BLOCKS_BUILDER.build();
    }

    private static void registerBudIndicator(Material material, GTRegistrate registrate, ImmutableMap.Builder<Material, BlockEntry<BudIndicator>> builder) {
        BlockEntry entry = ((BlockBuilder)((ItemBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)registrate.block("%s_bud_indicator".formatted(material.getName()), p -> new BudIndicator((BlockBehaviour.Properties)p, material)).initialProperties(() -> Blocks.f_152492_).properties(p -> p.m_222994_().m_60955_().m_60910_().m_60978_(0.25f).m_60953_(b -> 3).m_222979_(BlockBehaviour.OffsetType.XZ)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).setData(ProviderType.LOOT, NonNullBiConsumer.noop())).setData(ProviderType.BLOCKSTATE, NonNullBiConsumer.noop())).addLayer(() -> RenderType::m_110457_).color(() -> BudIndicator::tintedBlockColor).item((b, p) -> BudIndicatorItem.create(b, p, material)).color(() -> BudIndicator::tintedItemColor).setData(ProviderType.ITEM_MODEL, NonNullBiConsumer.noop())).build()).register();
        builder.put((Object)material, (Object)entry);
    }

    public static void generateBudIndicatorLoot(Map<ResourceLocation, LootTable> lootTables) {
        BUD_BLOCKS.forEach((material, blockEntry) -> {
            ResourceLocation lootTableId = ResourceLocation.fromNamespaceAndPath((String)blockEntry.getId().m_135827_(), (String)("blocks/" + blockEntry.getId().m_135815_()));
            ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
        });
    }

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<T> blockSupplier) {
        return TFGBlocks.register(name, blockSupplier, (Function)null);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier) {
        return TFGBlocks.register(name, blockSupplier, (T b) -> new BlockItem(b, new Item.Properties()));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, Item.Properties blockItemProperties) {
        return TFGBlocks.register(name, blockSupplier, (T block) -> new BlockItem(block, blockItemProperties));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, @Nullable Function<T, ? extends BlockItem> blockItemFactory) {
        return RegistrationHelpers.registerBlock(BLOCKS, TFGItems.ITEMS, (String)name, blockSupplier, blockItemFactory);
    }

    static {
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tfg");
        LUNAR_CHORUS_PLANT = TFGBlocks.register("lunar_chorus_plant", () -> new LunarChorusPlantBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283892_).m_278166_(PushReaction.DESTROY).m_222994_().m_60978_(0.2f).m_60918_(SoundType.f_271497_)));
        LUNAR_CHORUS_FLOWER = TFGBlocks.register("lunar_chorus_flower", () -> new LunarChorusFlowerBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283892_).m_60955_().m_278166_(PushReaction.DESTROY).m_60978_(0.2f).m_60918_(SoundType.f_271497_), (Supplier<? extends Block>)LUNAR_CHORUS_PLANT));
        MARS_PATH = TFGBlocks.register("grass/mars_path", () -> new PathBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60978_(1.4f).m_60918_(SoundType.f_56739_), MARS_DIRT));
        MARS_FARMLAND = TFGBlocks.register("grass/mars_farmland", () -> new FarmlandBlock(ExtendedProperties.of((MapColor)MapColor.f_283762_).strength(1.3f).sound(SoundType.f_56739_).isViewBlocking(TFCBlocks::always).isSuffocating(TFCBlocks::always).blockEntity((Supplier)TFCBlockEntities.FARMLAND), MARS_DIRT));
        amber_properties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283843_).m_60978_(5.0f).m_60918_(SoundType.f_56719_).m_60977_();
        AMBER_MYCELIUM = TFGBlocks.register("grass/amber_mycelium", () -> new ConnectedGrassBlock(amber_properties, MARS_DIRT, MARS_PATH, MARS_FARMLAND));
        AMBER_CLAY_MYCELIUM = TFGBlocks.register("grass/amber_clay_mycelium", () -> new ConnectedGrassBlock(amber_properties, MARS_CLAY, MARS_PATH, MARS_FARMLAND));
        AMBER_KAOLIN_MYCELIUM = TFGBlocks.register("grass/amber_kaolin_mycelium", () -> new ConnectedGrassBlock(amber_properties, (Supplier)TFCBlocks.RED_KAOLIN_CLAY, null, null));
        rusticus_properties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283895_).m_60978_(5.0f).m_60918_(SoundType.f_56719_).m_60977_();
        RUSTICUS_MYCELIUM = TFGBlocks.register("grass/rusticus_mycelium", () -> new ConnectedGrassBlock(rusticus_properties, MARS_DIRT, MARS_PATH, MARS_FARMLAND));
        RUSTICUS_CLAY_MYCELIUM = TFGBlocks.register("grass/rusticus_clay_mycelium", () -> new ConnectedGrassBlock(rusticus_properties, MARS_CLAY, MARS_PATH, MARS_FARMLAND));
        RUSTICUS_KAOLIN_MYCELIUM = TFGBlocks.register("grass/rusticus_kaolin_mycelium", () -> new ConnectedGrassBlock(rusticus_properties, (Supplier)TFCBlocks.RED_KAOLIN_CLAY, null, null));
        sangnum_properties = BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283798_).m_60978_(5.0f).m_60918_(SoundType.f_56719_).m_60977_();
        SANGNUM_MYCELIUM = TFGBlocks.register("grass/sangnum_mycelium", () -> new ConnectedGrassBlock(sangnum_properties, MARS_DIRT, MARS_PATH, MARS_FARMLAND));
        SANGNUM_CLAY_MYCELIUM = TFGBlocks.register("grass/sangnum_clay_mycelium", () -> new ConnectedGrassBlock(sangnum_properties, MARS_CLAY, MARS_PATH, MARS_FARMLAND));
        SANGNUM_KAOLIN_MYCELIUM = TFGBlocks.register("grass/sangnum_kaolin_mycelium", () -> new ConnectedGrassBlock(sangnum_properties, (Supplier)TFCBlocks.RED_KAOLIN_CLAY, null, null));
        ASH_LAYER_BLOCK = TFGBlocks.register("ash_pile", () -> new SandLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.RED)).get())).m_60955_().m_284180_(MapColor.f_283808_)));
        BLACK_SAND_LAYER_BLOCK = TFGBlocks.register("pile/black_sand", () -> new SandLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.BLACK)).get())).m_60955_().m_284180_(MapColor.f_283808_)));
        WHITE_SAND_LAYER_BLOCK = TFGBlocks.register("pile/white_sand", () -> new SandLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.WHITE)).get())).m_60955_().m_284180_(MapColor.f_283808_)));
        BROWN_SAND_LAYER_BLOCK = TFGBlocks.register("pile/brown_sand", () -> new SandLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.BROWN)).get())).m_60955_().m_284180_(MapColor.f_283808_)));
        RED_SAND_LAYER_BLOCK = TFGBlocks.register("pile/red_sand", () -> new SandLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.RED)).get())).m_60955_().m_284180_(MapColor.f_283808_)));
        YELLOW_SAND_LAYER_BLOCK = TFGBlocks.register("pile/yellow_sand", () -> new SandLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.YELLOW)).get())).m_60955_().m_284180_(MapColor.f_283808_)));
        PINK_SAND_LAYER_BLOCK = TFGBlocks.register("pile/pink_sand", () -> new SandLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.PINK)).get())).m_60955_().m_284180_(MapColor.f_283808_)));
        GREEN_SAND_LAYER_BLOCK = TFGBlocks.register("pile/green_sand", () -> new SandLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.GREEN)).get())).m_60955_().m_284180_(MapColor.f_283808_)));
        MOON_SAND_LAYER_BLOCK = TFGBlocks.register("pile/moon_sand", () -> new SandLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.RED)).get())).m_60955_().m_284180_(MapColor.f_283808_)));
        HEMATITIC_SAND_LAYER_BLOCK = TFGBlocks.register("pile/hematitic_sand", () -> new SandLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.RED)).get())).m_60955_().m_284180_(MapColor.f_283808_)));
        MARS_SAND_LAYER_BLOCK = TFGBlocks.register("pile/mars_sand", () -> new SandLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.RED)).get())).m_60955_().m_284180_(MapColor.f_283808_)));
        VENUS_SAND_LAYER_BLOCK = TFGBlocks.register("pile/venus_sand", () -> new SandLayerBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.RED)).get())).m_60955_().m_284180_(MapColor.f_283808_)));
        HEMATITIC_SAND_PILE_BLOCK = TFGBlocks.register("pile/hematitic_sand_covering", () -> new SandPileBlock(ExtendedProperties.of((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.RED)).get())).noOcclusion().mapColor(MapColor.f_283808_).randomTicks().blockEntity((Supplier)TFCBlockEntities.PILE)));
        MARS_SAND_PILE_BLOCK = TFGBlocks.register("pile/mars_sand_covering", () -> new SandPileBlock(ExtendedProperties.of((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.RED)).get())).noOcclusion().mapColor(MapColor.f_283808_).randomTicks().blockEntity((Supplier)TFCBlockEntities.PILE)));
        VENUS_SAND_PILE_BLOCK = TFGBlocks.register("pile/venus_sand_covering", () -> new SandPileBlock(ExtendedProperties.of((BlockBehaviour)((BlockBehaviour)((RegistryObject)TFCBlocks.SAND.get(SandBlockType.RED)).get())).noOcclusion().mapColor(MapColor.f_283808_).randomTicks().blockEntity((Supplier)TFCBlockEntities.PILE)));
        MARS_WATER = TFGBlocks.registerNoItem("fluid/semiheavy_ammoniacal_water", () -> new LiquidBlock((Supplier)TFGFluids.MARS_WATER.source(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49990_).m_284180_(MapColor.f_283898_).m_222994_()));
        PIGLIN_DISGUISE_BLOCK = TFGBlocks.register("piglin_disguise_block", () -> new PiglinDisguiseBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_60978_(0.1f).m_60918_(SoundType.f_154661_).m_278166_(PushReaction.DESTROY).m_60971_((state, level, pos) -> false).m_60960_((state, level, pos) -> false)));
        MARS_ICE = TFGBlocks.register("mars_ice", () -> new MarsIceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50126_)));
        MARS_ICICLE = TFGBlocks.register("mars_icicle", () -> new IcicleBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)TFCBlocks.ICICLE.get()))));
        DRY_ICE = TFGBlocks.register("dry_ice", () -> new DryIceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50126_).m_60918_(SoundType.f_56724_)));
        ELECTROMAGNETIC_ACCELERATOR_BLOCK = TFGBlocks.register("electromagnetic_accelerator", () -> new ElectromagneticAcceleratorBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283869_).m_60978_(5.5f).m_60918_(SoundType.f_154663_).m_60953_(state -> 15).m_60956_(1.5f)));
        SUPERCONDUCTOR_COIL_LARGE_BLOCK = TFGBlocks.register("superconductor_coil_large", () -> new SimpleBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60978_(5.5f).m_60918_(SoundType.f_154663_)));
        SUPERCONDUCTOR_COIL_SMALL_BLOCK = TFGBlocks.register("superconductor_coil_small", () -> new SimpleBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283750_).m_60978_(5.5f).m_60918_(SoundType.f_154663_)));
        MACHINE_CASING_ALUMINIUM_PLATED_STEEL = TFGBlocks.register("machine_casing_aluminium_plated_steel", () -> new SimpleBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283869_).m_60978_(5.5f).m_60918_(SoundType.f_154663_)));
        REFLECTOR_BLOCK = TFGBlocks.register("reflector", ReflectorBlock::new);
        LARGE_NEST_BOX = TFGBlocks.register("large_nest_box", () -> new LargeNestBoxBlock(ExtendedProperties.of().mapColor(MapColor.f_283825_).strength(3.0f).noOcclusion().sound((SoundType)TFCSounds.THATCH).blockEntity(TFGBlockEntities.LARGE_NEST_BOX).serverTicks(LargeNestBoxBlockEntity::serverTick)));
        LARGE_NEST_BOX_WARPED = TFGBlocks.register("large_nest_box_warped", () -> new LargeNestBoxBlock(ExtendedProperties.of().mapColor(MapColor.f_283825_).strength(3.0f).noOcclusion().sound((SoundType)TFCSounds.THATCH).blockEntity(TFGBlockEntities.LARGE_NEST_BOX).serverTicks(LargeNestBoxBlockEntity::serverTick)));
        MARS_DIRT = TFGBlocks.register("grass/mars_dirt", () -> new DirtBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60978_(1.4f).m_60918_(SoundType.f_56739_), RUSTICUS_MYCELIUM, MARS_PATH, MARS_FARMLAND, null, null));
        MARS_CLAY = TFGBlocks.register("grass/mars_clay_dirt", () -> new DirtBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283762_).m_60978_(1.4f).m_60918_(SoundType.f_56739_), RUSTICUS_CLAY_MYCELIUM, MARS_PATH, MARS_FARMLAND, null, null));
        BLOCK_LOOT = new VanillaBlockLoot();
    }
}

