/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.common.data.TFGBlockEntities;

public class GTGreenhousePortBlockEntity
extends BlockEntity
implements IFluidHandler {
    private final FluidTank tank = new FluidTank(4000);
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this);

    public GTGreenhousePortBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFGBlockEntities.GT_GREENHOUSE_PORT.get(), pos, state);
    }

    public int getTanks() {
        return this.tank.getTanks();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.tank.getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return this.tank.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.tank.isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.fill(resource, action);
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.tank.drain(resource, action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.tank.drain(maxDrain, action);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.fluidHandler.invalidate();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, GTGreenhousePortBlockEntity self) {
        if (level.f_46443_) {
            return;
        }
        for (Direction dir : Direction.values()) {
            BlockPos neighborPos = pos.m_121945_(dir);
            BlockEntity neighbor = level.m_7702_(neighborPos);
            if (neighbor instanceof GTGreenhousePortBlockEntity) {
                int filled;
                GTGreenhousePortBlockEntity other = (GTGreenhousePortBlockEntity)neighbor;
                FluidStack toSend = self.tank.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                if (toSend.isEmpty() || (filled = other.tank.fill(toSend, IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                self.tank.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                self.m_6596_();
                other.m_6596_();
                continue;
            }
            if (neighbor == null) continue;
            neighbor.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_()).ifPresent(handler -> {
                int filled;
                FluidStack toSend = self.tank.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                if (!toSend.isEmpty() && (filled = handler.fill(toSend, IFluidHandler.FluidAction.EXECUTE)) > 0) {
                    self.tank.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                    self.m_6596_();
                    neighbor.m_6596_();
                }
            });
        }
    }
}

