/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.blocks;

import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.block.property.GTBlockStateProperties;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;
import su.terrafirmagreg.core.common.data.TFGBlockEntities;
import su.terrafirmagreg.core.common.data.blockentity.TickerBlockEntity;

public class ActiveParticleBlock
extends ActiveBlock
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final VoxelShape DEFAULT_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final VoxelShape shape;
    private final ParticleConfig inactiveConfig;
    private final ParticleConfig activeConfig;
    private final boolean hasTicker;
    private final int emitDelay;

    public ActiveParticleBlock(BlockBehaviour.Properties properties, VoxelShape shape, Supplier<Item> itemSupplier, ParticleConfig inactiveConfig, ParticleConfig activeConfig, boolean hasTicker, int emitDelay) {
        super(properties);
        this.shape = shape != null ? shape : DEFAULT_SHAPE;
        this.inactiveConfig = inactiveConfig;
        this.activeConfig = activeConfig;
        this.hasTicker = hasTicker;
        this.emitDelay = Math.max(0, emitDelay);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)GTBlockStateProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    private boolean shouldEmit(RandomSource random) {
        if (this.emitDelay <= 0) {
            return true;
        }
        int inner = 1 + random.m_188503_(this.emitDelay);
        return random.m_188503_(inner) == 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, GTBlockStateProperties.ACTIVE});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Info(value="Client display tick. Cannot be every tick. Use ticker for adjustable frequency.")
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        ParticleConfig cfg;
        if (this.hasTicker && level.m_7702_(pos) != null) {
            return;
        }
        if (!this.shouldEmit(random)) {
            return;
        }
        ParticleConfig particleConfig = cfg = (Boolean)state.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false ? this.activeConfig : this.inactiveConfig;
        if (cfg != null) {
            cfg.spawnClient(level, pos, random);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.hasTicker ? new TickerBlockEntity(pos, state) : null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!this.hasTicker || !level.f_46443_) {
            return null;
        }
        if (type != TFGBlockEntities.TICKER_ENTITY.get()) {
            return null;
        }
        return (lvl, p, s, be) -> {
            if (be instanceof TickerBlockEntity && this.shouldEmit(lvl.f_46441_)) {
                ParticleConfig cfg;
                ParticleConfig particleConfig = cfg = (Boolean)s.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false ? this.activeConfig : this.inactiveConfig;
                if (cfg != null) {
                    cfg.spawnClient(lvl, p, lvl.f_46441_);
                }
            }
        };
    }

    public static class ParticleConfig {
        private final Supplier<SimpleParticleType> type;
        private final double baseX;
        private final double baseY;
        private final double baseZ;
        private final double offsetX;
        private final double offsetY;
        private final double offsetZ;
        private final double velocityX;
        private final double velocityY;
        private final double velocityZ;
        private final int count;
        private final boolean forced;
        private final boolean useDust;
        private final float r;
        private final float g;
        private final float b;
        private final float scale;

        public ParticleConfig(Supplier<SimpleParticleType> type, double baseX, double baseY, double baseZ, double offsetX, double offsetY, double offsetZ, double velocityX, double velocityY, double velocityZ, int count, boolean forced, boolean useDust, float r, float g, float b, float scale) {
            this.type = type != null ? type : () -> ParticleTypes.f_123778_;
            this.baseX = baseX;
            this.baseY = baseY;
            this.baseZ = baseZ;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.velocityX = velocityX;
            this.velocityY = velocityY;
            this.velocityZ = velocityZ;
            this.count = Math.max(1, count);
            this.forced = forced;
            this.useDust = useDust;
            this.r = r;
            this.g = g;
            this.b = b;
            this.scale = scale;
        }

        private double randOffset(RandomSource rdn, double range) {
            if (range <= 0.0) {
                return 0.0;
            }
            return rdn.m_188500_() * range * (double)(rdn.m_188499_() ? 1 : -1);
        }

        private void emitClient(Level level, double x, double y, double z) {
            if (this.useDust) {
                DustParticleOptions dust = new DustParticleOptions(new Vector3f(this.r, this.g, this.b), this.scale);
                if (this.forced) {
                    level.m_6485_((ParticleOptions)dust, true, x, y, z, this.velocityX, this.velocityY, this.velocityZ);
                } else {
                    level.m_7106_((ParticleOptions)dust, x, y, z, this.velocityX, this.velocityY, this.velocityZ);
                }
            } else {
                SimpleParticleType p = this.type.get();
                if (this.forced) {
                    level.m_6485_((ParticleOptions)p, true, x, y, z, this.velocityX, this.velocityY, this.velocityZ);
                } else {
                    level.m_7106_((ParticleOptions)p, x, y, z, this.velocityX, this.velocityY, this.velocityZ);
                }
            }
        }

        public void spawnClient(Level level, BlockPos pos, RandomSource random) {
            if (!level.f_46443_) {
                return;
            }
            for (int i = 0; i < this.count; ++i) {
                double x = (double)pos.m_123341_() + this.baseX + this.randOffset(random, this.offsetX);
                double y = (double)pos.m_123342_() + this.baseY + (this.offsetY > 0.0 ? random.m_188500_() * this.offsetY : 0.0);
                double z = (double)pos.m_123343_() + this.baseZ + this.randOffset(random, this.offsetZ);
                this.emitClient(level, x, y, z);
            }
        }
    }
}

