/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.entities;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.EntityHelpers;
import net.dries007.tfc.common.entities.livestock.ProducingAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.animals.ProducingAnimalConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public abstract class TFGWoolEggProducingAnimal
extends ProducingAnimal {
    private static final EntityDataAccessor<Long> DATA_WOOL = SynchedEntityData.m_135353_(TFGWoolEggProducingAnimal.class, (EntityDataSerializer)EntityHelpers.LONG_SERIALIZER);

    public TFGWoolEggProducingAnimal(EntityType<? extends TFCAnimal> type, Level level, TFCSounds.EntitySound sounds, ProducingAnimalConfig config) {
        super(type, level, sounds, config);
    }

    public ItemStack getWoolItem(Item woolItem, int maxWool) {
        int amount = (int)Math.ceil(this.getFamiliarity() * (float)maxWool);
        return new ItemStack((ItemLike)woolItem, amount);
    }

    public boolean hasWool(int woolProduceTicks) {
        long cooldown = this.getWoolCooldown(woolProduceTicks);
        return cooldown == 0L;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128356_("producedWool", this.getWoolProducedTick());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setWoolProducedTick(nbt.m_128454_("producedWool"));
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_WOOL, (Object)0L);
    }

    public long getWoolProducedTick() {
        return (Long)this.f_19804_.m_135370_(DATA_WOOL);
    }

    public void setWoolProducedTick(long producedTick) {
        this.f_19804_.m_135381_(DATA_WOOL, (Object)producedTick);
    }

    public void setWoolCooldown() {
        this.setWoolProducedTick(Calendars.get((LevelReader)this.m_9236_()).getTicks());
    }

    public long getWoolCooldown(int woolProduceTicks) {
        return Math.max(0L, (long)woolProduceTicks + this.getWoolProducedTick() - Calendars.get((LevelReader)this.m_9236_()).getTicks());
    }

    public boolean hasWoolProduct(int woolProduceTicks) {
        return (this.getWoolProducedTick() <= 0L || this.getWoolCooldown(woolProduceTicks) <= 0L) && this.getAgeType() == TFCAnimalProperties.Age.ADULT;
    }

    public MutableComponent getWoolReadyName() {
        return Component.m_237115_((String)"tfc.jade.product.wool");
    }

    public ItemStack makeEgg() {
        System.out.println("You shouldn't see this");
        return null;
    }
}

