/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.entities.sniffer;

import com.mojang.serialization.Dynamic;
import java.util.List;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.livestock.ProducingAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.animals.ProducingAnimalConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.events.AnimalProductEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.common.data.TFGEntityDataSerializers;
import su.terrafirmagreg.core.common.data.TFGItems;
import su.terrafirmagreg.core.common.data.TFGTags;
import su.terrafirmagreg.core.common.data.capabilities.ILargeEgg;
import su.terrafirmagreg.core.common.data.capabilities.LargeEggCapability;
import su.terrafirmagreg.core.common.data.entities.TFGWoolEggProducingAnimal;
import su.terrafirmagreg.core.common.data.entities.sniffer.TFCSnifferAi;

public class TFCSniffer
extends TFGWoolEggProducingAnimal
implements IForgeShearable {
    private static final EntityDataAccessor<State> DATA_STATE = SynchedEntityData.m_135353_(TFCSniffer.class, (EntityDataSerializer)((EntityDataSerializer)TFGEntityDataSerializers.SNIFFER_STATE.get()));
    static double familiarityCap = 0.35;
    static int adulthoodDays = 80;
    static int uses = 200;
    static boolean eatsRottenFood = false;
    static int produceTicks = 96000;
    static int hatchDays = 20;
    static Item eggItem = (Item)TFGItems.SNIFFER_EGG.get();
    static int woolProduceTicks = 48000;
    static int maxWool = 8;
    static Item woolItem = (Item)TFGItems.SNIFFER_WOOL.get();
    static double produceFamiliarity = 0.15;
    public final AnimationState scentingAnimationState = new AnimationState();
    public final AnimationState sniffingAnimationState = new AnimationState();

    public TFCSniffer(EntityType<? extends TFCAnimal> type, Level level, TFCSounds.EntitySound sounds, ProducingAnimalConfig config) {
        super(type, level, sounds, config);
        this.f_19804_.m_135372_(DATA_STATE, (Object)State.IDLING);
    }

    public static TFCSniffer makeTFCSniffer(EntityType<? extends ProducingAnimal> type, Level level) {
        return new TFCSniffer(type, level, TFCSounds.MUSK_OX, TFCConfig.SERVER.duckConfig.inner());
    }

    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 75.0).m_22268_(Attributes.f_22279_, (double)0.1f);
    }

    public static boolean spawnRules(EntityType<? extends TFCSniffer> type, LevelAccessor level, MobSpawnType spawn, BlockPos pos, RandomSource rand) {
        return level.m_8055_(pos).m_60795_();
    }

    public float getAdultFamiliarityCap() {
        return (float)familiarityCap;
    }

    public int getDaysToAdulthood() {
        return adulthoodDays;
    }

    public int getUsesToElderly() {
        return uses;
    }

    public boolean eatsRottenFood() {
        return eatsRottenFood;
    }

    public boolean isReadyForAnimalProduct() {
        return (double)this.getFamiliarity() > produceFamiliarity && this.hasProduct();
    }

    public long getProductsCooldown() {
        return Math.max(0L, (long)produceTicks + this.getProducedTick() - Calendars.get((LevelReader)this.m_9236_()).getTicks());
    }

    @NotNull
    public TagKey<Item> getFoodTag() {
        return TFGTags.Items.SnifferFood;
    }

    public boolean hasProduct() {
        return (this.getProducedTick() <= 0L || this.getProductsCooldown() <= 0L) && this.getAgeType() == TFCAnimalProperties.Age.ADULT && (this.getGender() == TFCAnimalProperties.Gender.FEMALE || this.getGender() == TFCAnimalProperties.Gender.MALE && this.isFertilized());
    }

    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob other) {
        if (other != this && this.getGender() == TFCAnimalProperties.Gender.FEMALE && other instanceof TFCSniffer) {
            TFCSniffer otherFertile = (TFCSniffer)other;
            if (!this.isFertilized()) {
                this.onFertilized(otherFertile);
                otherFertile.setProducedTick(0L);
                this.setProductsCooldown();
            }
        }
        return null;
    }

    public void onFertilized(TFCSniffer male) {
        male.setFertilized(true);
        male.setLastFed(this.getLastFed() - 1L);
        this.setLastFed(this.getLastFed() - 1L);
        male.addUses(5);
        this.addUses(5);
    }

    @Override
    public ItemStack makeEgg() {
        AnimalProductEvent event;
        ILargeEgg egg;
        ItemStack stack = new ItemStack((ItemLike)eggItem);
        if (this.isFertilized() && (egg = LargeEggCapability.get(stack)) != null) {
            TFCSniffer baby = (TFCSniffer)this.m_6095_().m_20615_(this.m_9236_());
            if (baby != null) {
                baby.setGender(TFCAnimalProperties.Gender.valueOf((boolean)this.f_19796_.m_188499_()));
                baby.setBirthDay(Calendars.SERVER.getTotalDays());
                baby.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
                egg.setFertilized((Entity)baby, Calendars.SERVER.getTotalDays() + (long)hatchDays);
            } else {
                System.out.println("Cannot Create Child");
            }
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(event = new AnimalProductEvent(this.m_9236_(), this.m_20183_(), null, (TFCAnimalProperties)this, stack, ItemStack.f_41583_, 1)))) {
            this.addUses(event.getUses());
        }
        return event.getProduct();
    }

    @NotNull
    public MutableComponent getProductReadyName() {
        return Component.m_237115_((String)"tfc.jade.product.eggs");
    }

    public boolean isShearable(@NotNull ItemStack item, Level level, BlockPos pos) {
        return this.isReadyForWoolProduct();
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level level, BlockPos pos, int fortune) {
        this.setWoolCooldown();
        this.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
        AnimalProductEvent event = new AnimalProductEvent(level, pos, player, (TFCAnimalProperties)this, this.getWoolItem(woolItem, maxWool), item, 1);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            this.addUses(event.getUses());
        }
        return List.of(event.getProduct());
    }

    public boolean hasWool() {
        long cooldown = this.getWoolCooldown(woolProduceTicks);
        return cooldown == 0L;
    }

    public boolean isReadyForWoolProduct() {
        return (double)this.getFamiliarity() > produceFamiliarity && this.hasWoolProduct(woolProduceTicks);
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_(SoundEvents.f_271325_, 0.15f, 1.0f);
    }

    @NotNull
    public SoundEvent m_7866_(@NotNull ItemStack pStack) {
        return SoundEvents.f_271147_;
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return SoundEvents.f_271520_;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return SoundEvents.f_271214_;
    }

    @NotNull
    protected SoundEvent m_7515_() {
        return SoundEvents.f_271535_;
    }

    private TFCSniffer onScentingStart() {
        this.m_5496_(SoundEvents.f_271121_, 2.0f, this.m_6162_() ? 1.3f : 1.0f);
        return this;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Brain.Provider<? extends TFCSniffer> m_5490_() {
        return Brain.m_21923_(TFCSnifferAi.MEMORY_TYPES, TFCSnifferAi.SENSOR_TYPES);
    }

    @NotNull
    public Brain<?> m_8075_(@NotNull Dynamic<?> dynamic) {
        return TFCSnifferAi.makeSniffBrain((Brain<? extends TFCSniffer>)this.m_5490_().m_22073_(dynamic));
    }

    public boolean isTempted() {
        return this.f_20939_.m_21952_(MemoryModuleType.f_148198_).orElse(false);
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        if (DATA_STATE.equals(data)) {
            State sniffer$state = this.getState();
            this.resetAnimations();
            switch (sniffer$state) {
                case SCENTING: {
                    this.scentingAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case SNIFFING: {
                    this.sniffingAnimationState.m_216982_(this.f_19797_);
                }
            }
            this.m_6210_();
        }
        super.m_7350_(data);
    }

    private State getState() {
        return (State)((Object)this.f_19804_.m_135370_(DATA_STATE));
    }

    private TFCSniffer setState(State pState) {
        this.f_19804_.m_135381_(DATA_STATE, (Object)pState);
        return this;
    }

    public TFCSniffer transitionTo(State pState) {
        switch (pState) {
            case SCENTING: {
                this.setState(State.SCENTING).onScentingStart();
                break;
            }
            case SNIFFING: {
                this.m_5496_(SoundEvents.f_271283_, 1.0f, 1.0f);
                this.setState(State.SNIFFING);
                break;
            }
            case IDLING: {
                this.setState(State.IDLING);
            }
        }
        return this;
    }

    public int m_8085_() {
        return 50;
    }

    private void resetAnimations() {
        this.sniffingAnimationState.m_216973_();
        this.scentingAnimationState.m_216973_();
    }

    public static enum State {
        IDLING,
        SCENTING,
        SNIFFING;

    }
}

