/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TrowelItem
extends Item {
    public TrowelItem(Item.Properties properties) {
        super(properties.m_41503_(1026));
    }

    public static Map<ResourceLocation, ResourceLocation> createBlockMapping() {
        HashMap<ResourceLocation, ResourceLocation> map = new HashMap<ResourceLocation, ResourceLocation>();
        List<String> sandstone_colors = Arrays.stream(SandBlockType.values()).map(SandBlockType2 -> SandBlockType2.name().toLowerCase(Locale.ROOT)).toList();
        List<String> rocks = Arrays.stream(Rock.values()).map(rock -> rock.name().toLowerCase(Locale.ROOT)).toList();
        for (String sandstone_color : sandstone_colors) {
            map.put(ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)("flagstone/" + sandstone_color + "_sandstone")), ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)(sandstone_color + "_sandstone_flagstones")));
        }
        for (String flagstone_rock : rocks) {
            map.put(ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)("flagstone/" + flagstone_rock)), ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)("rock/flagstones/" + flagstone_rock)));
        }
        for (String gravel_rock : rocks) {
            map.put(ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)("gravel_fill/" + gravel_rock)), ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)("rock/gravel_road/" + gravel_rock)));
        }
        for (String cobble_rock : rocks) {
            map.put(ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)("rock/loose/" + cobble_rock)), ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)("rock/cobbled_road/" + cobble_rock)));
        }
        for (String mossy_cobble_rock : rocks) {
            map.put(ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)("rock/mossy_loose/" + mossy_cobble_rock)), ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)("rock/cobbled_road/" + mossy_cobble_rock)));
        }
        for (String brick_rock : rocks) {
            map.put(ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)("brick/" + brick_rock)), ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)("rock/sett_road/" + brick_rock)));
        }
        map.put(ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)"hoggin_mix"), ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)"hoggin"));
        map.put(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"brick"), ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)"brick_road"));
        return map;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        BlockPos targetPos = context.m_8083_();
        BlockState clickedState = level.m_8055_(targetPos);
        ResourceLocation clickedBlockId = clickedState.m_60734_().m_204297_().m_205785_().m_135782_();
        Map<ResourceLocation, ResourceLocation> blockMapping = TrowelItem.createBlockMapping();
        if (clickedBlockId.toString().equals("rnr:base_course")) {
            ArrayList<ItemStack> validStacks = new ArrayList<ItemStack>();
            for (int i = 0; i < 9; ++i) {
                ResourceLocation itemId;
                ItemStack hotbarStack = player.m_150109_().m_8020_(i);
                if (hotbarStack.m_41619_() || (itemId = ForgeRegistries.ITEMS.getKey((Object)hotbarStack.m_41720_())) == null || !blockMapping.containsKey(itemId)) continue;
                validStacks.add(hotbarStack);
            }
            if (validStacks.isEmpty()) {
                return InteractionResult.PASS;
            }
            ItemStack randomStack = (ItemStack)validStacks.get(new Random().nextInt(validStacks.size()));
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)randomStack.m_41720_());
            ResourceLocation resultBlockId = blockMapping.get(itemId);
            Block resultBlock = (Block)ForgeRegistries.BLOCKS.getValue(resultBlockId);
            if (resultBlock != null) {
                BlockState newState = resultBlock.m_49966_();
                level.m_7731_(targetPos, newState, 3);
                level.m_46672_(targetPos, resultBlock);
                level.m_5594_(null, targetPos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 0.4f);
                if (!player.m_7500_()) {
                    randomStack.m_41774_(1);
                }
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        ArrayList<ItemStack> blockItems = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            ItemStack hotbarStack = player.m_150109_().m_8020_(i);
            if (!(hotbarStack.m_41720_() instanceof BlockItem)) continue;
            blockItems.add(hotbarStack);
        }
        if (blockItems.isEmpty()) {
            return InteractionResult.PASS;
        }
        int originalCount = stack.m_41613_();
        ItemStack randomStack = (ItemStack)blockItems.get(new Random().nextInt(blockItems.size()));
        BlockItem blockItem = (BlockItem)randomStack.m_41720_();
        BlockPlaceContext placeContext = new BlockPlaceContext(context);
        BlockPos placePos = context.m_8083_().m_121945_(context.m_43719_());
        BlockState newState = blockItem.m_40614_().m_5573_(placeContext);
        if (newState == null || !newState.m_60710_((LevelReader)level, placePos) || !level.m_45752_(newState, placePos, CollisionContext.m_82750_((Entity)player))) {
            return InteractionResult.FAIL;
        }
        InteractionResult result = blockItem.m_40576_(placeContext);
        stack.m_41764_(originalCount);
        level.m_5594_(null, placePos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, 0.4f);
        if (!player.m_7500_()) {
            randomStack.m_41774_(1);
        }
        if (result.m_19077_() && !player.m_7500_()) {
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
        }
        return result;
    }
}

