/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.compat.create;

import com.eerussianguy.firmalife.common.blocks.OvenHopperBlock;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.simibubi.create.Create;
import com.simibubi.create.api.registry.CreateBuiltInRegistries;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.blocks.devices.CrucibleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegisterEvent;

public final class CustomArmInteractionPointTypes {
    private static <T extends ArmInteractionPointType> void register(String name, T type) {
        Registry.m_122965_((Registry)CreateBuiltInRegistries.ARM_INTERACTION_POINT_TYPE, (ResourceLocation)Create.asResource((String)name), type);
    }

    public static void onRegister(RegisterEvent event) {
        CustomArmInteractionPointTypes.init();
    }

    public static void init() {
    }

    static {
        CustomArmInteractionPointTypes.register("crucible", new CrucibleType());
        CustomArmInteractionPointTypes.register("charcoal_forge", new CharcoalForgeType());
        CustomArmInteractionPointTypes.register("oven_hopper", new OvenHopperBlockType());
        CustomArmInteractionPointTypes.register("rotor_holder", new RotorHolderBlockType());
    }

    public static class CrucibleType
    extends ArmInteractionPointType {
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.m_60734_() instanceof CrucibleBlock;
        }

        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ArmInteractionPoint((ArmInteractionPointType)this, level, pos, state);
        }
    }

    public static class CharcoalForgeType
    extends ArmInteractionPointType {
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.m_60734_() instanceof CharcoalForgeBlock;
        }

        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ArmInteractionPoint((ArmInteractionPointType)this, level, pos, state);
        }
    }

    public static class OvenHopperBlockType
    extends ArmInteractionPointType {
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.m_60734_() instanceof OvenHopperBlock;
        }

        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ArmInteractionPoint((ArmInteractionPointType)this, level, pos, state);
        }
    }

    public static class RotorHolderBlockType
    extends ArmInteractionPointType {
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return PartAbility.ROTOR_HOLDER.getAllBlocks().contains(state.m_60734_());
        }

        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ArmInteractionPoint((ArmInteractionPointType)this, level, pos, state);
        }
    }
}

