/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.config;

import earth.terrarium.adastra.api.planets.Planet;
import java.util.HashMap;
import java.util.List;
import net.dries007.tfc.util.Metal;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.config.ConfigHelpers;
import su.terrafirmagreg.core.config.tools.PropickConfig;
import su.terrafirmagreg.core.config.tools.RenderingPropickConfig;

public final class ServerConfig {
    private static final List<ResourceKey<Level>> planetDimensions = List.of(Planet.EARTH_ORBIT, Planet.MOON_ORBIT, Planet.MARS_ORBIT, Planet.VENUS_ORBIT, Planet.MERCURY_ORBIT, Planet.GLACIO_ORBIT, Planet.MOON, Planet.MARS, Planet.VENUS, Planet.MERCURY, Planet.GLACIO);
    public final HashMap<ResourceKey<Level>, ForgeConfigSpec.BooleanValue> glidersWorkOnPlanets;
    public final PropickConfig copperPropickConfig;
    public final PropickConfig bronzePropickConfig;
    public final PropickConfig wroughtIronPropickConfig;
    public final PropickConfig steelPropickConfig;
    public final PropickConfig blackSteelPropickConfig;
    public final RenderingPropickConfig blueSteelPropickConfig;
    public final RenderingPropickConfig redSteelPropickConfig;
    public final ForgeConfigSpec.IntValue HARVEST_BASKET_RANGE;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> SYRINGE_BLACKLIST;
    public final ForgeConfigSpec.IntValue sandAccumulateChance;
    public final ForgeConfigSpec.IntValue sandDecumulateChance;

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("hang_glider");
        this.glidersWorkOnPlanets = new HashMap();
        for (ResourceKey<Level> dimension : planetDimensions) {
            String dimensionName = dimension.m_135782_().m_135815_();
            String dimensionPath = "can_glide_on_" + dimensionName;
            this.glidersWorkOnPlanets.put(dimension, builder.comment(String.format("\nIf true, gliders will function in the Ad Astra dimension %s", ConfigHelpers.toTitleCase(dimensionName))).define(dimensionPath, false));
        }
        builder.pop().push("prospector_picks").push("copper");
        this.copperPropickConfig = PropickConfig.build(builder, Metal.Default.COPPER, 15, 5);
        builder.pop().push("bronze");
        this.bronzePropickConfig = PropickConfig.build(builder, Metal.Default.BRONZE, 20, 8);
        builder.pop().push("wrought_iron");
        this.wroughtIronPropickConfig = PropickConfig.build(builder, Metal.Default.WROUGHT_IRON, 30, 10);
        builder.pop().push("steel");
        this.steelPropickConfig = PropickConfig.build(builder, Metal.Default.STEEL, 40, 12);
        builder.pop().push("black_steel");
        this.blackSteelPropickConfig = PropickConfig.build(builder, Metal.Default.BLACK_STEEL, 50, 15);
        builder.pop().push("blue_steel");
        this.blueSteelPropickConfig = RenderingPropickConfig.build(builder, Metal.Default.BLUE_STEEL, 75, 15, true);
        builder.pop().push("red_steel");
        this.redSteelPropickConfig = RenderingPropickConfig.build(builder, Metal.Default.RED_STEEL, 50, 25, false);
        builder.pop(2).push("harvest_basket");
        this.HARVEST_BASKET_RANGE = builder.comment("\nRadius of the harvest basket collection. Set to 0 to disable. Default: 7").defineInRange("HarvestBasketRange", 7, 0, 20);
        builder.pop().push("syringe_blacklist");
        this.SYRINGE_BLACKLIST = builder.comment("Blacklist of entity IDs that cannot be sampled by the DNA syringe. Can be empty.").defineListAllowEmpty("syringeBlacklist", List.of(), o -> {
            if (!(o instanceof String)) {
                return false;
            }
            String s = (String)o;
            ResourceLocation id = ResourceLocation.m_135820_((String)s);
            if (id == null) {
                TFGCore.LOGGER.warn("[TFG Config] Invalid entity ID syntax in syringeBlacklist: {}", (Object)s);
                return false;
            }
            if (!ForgeRegistries.ENTITY_TYPES.containsKey(id)) {
                TFGCore.LOGGER.warn("[TFG Config] Unknown entity ID in syringeBlacklist: {}", (Object)id);
                return false;
            }
            return true;
        });
        builder.pop().push("mars_climate");
        this.sandAccumulateChance = builder.comment("The chance that sand piles will accumulate during a sandstorm. Lower values = faster sand pile accumulation, but also more block updates (aka lag).").defineInRange("sandAccumulateChance", 20, 1, Integer.MAX_VALUE);
        this.sandDecumulateChance = builder.comment("The chance that sand piles will decumulate during a sandstoem. Lower values = faster sand dispersal, but also more block updates (aka lag).").defineInRange("sandDecumulateChance", 36, 1, Integer.MAX_VALUE);
        builder.pop();
    }
}

