/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.network;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import su.terrafirmagreg.core.network.packet.OreHighlightPacket;
import su.terrafirmagreg.core.network.packet.OreHighlightVeinPacket;
import su.terrafirmagreg.core.network.packet.ParticlePacket;
import su.terrafirmagreg.core.network.packet.SoundPacket;

public class TFGNetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tfg", (String)"main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetId = 0;

    private static int id() {
        return packetId++;
    }

    public static void init() {
        INSTANCE.registerMessage(TFGNetworkHandler.id(), ParticlePacket.class, ParticlePacket::encode, ParticlePacket::decode, ParticlePacket::handle);
        INSTANCE.registerMessage(TFGNetworkHandler.id(), SoundPacket.class, SoundPacket::encode, SoundPacket::decode, SoundPacket::handle);
        INSTANCE.registerMessage(TFGNetworkHandler.id(), OreHighlightPacket.class, OreHighlightPacket::encode, OreHighlightPacket::decode, OreHighlightPacket::handle);
        INSTANCE.registerMessage(TFGNetworkHandler.id(), OreHighlightVeinPacket.class, OreHighlightVeinPacket::encode, OreHighlightVeinPacket::decode, OreHighlightVeinPacket::handle);
    }

    private static void sendToAllAround(Level level, BlockPos pos, Object packet) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 64.0, serverLevel.m_46472_())), packet);
    }

    public static void sendParticle(ServerLevel level, double x, double y, double z, Vec3 motion, ResourceLocation particleId, int count, double dx, double dy, double dz) {
        BlockPos pos = new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
        ParticlePacket packet = new ParticlePacket(x, y, z, motion.f_82479_, motion.f_82480_, motion.f_82481_, particleId, count, dx, dy, dz);
        TFGNetworkHandler.sendToAllAround((Level)level, pos, packet);
    }

    public static void sendSound(ServerLevel level, double x, double y, double z, ResourceLocation soundId, float volume, float pitch) {
        BlockPos pos = new BlockPos(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
        SoundPacket packet = new SoundPacket(x, y, z, soundId, volume, pitch);
        TFGNetworkHandler.sendToAllAround((Level)level, pos, packet);
    }
}

