/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.world;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import su.terrafirmagreg.core.common.data.TFGFoodTraits;
import su.terrafirmagreg.core.common.data.tfgt.machine.electric.FoodRefrigeratorMachine;
import su.terrafirmagreg.core.mixins.common.minecraft.AccessorChunkMap;
import su.terrafirmagreg.core.mixins.common.minecraft.AccessorServerChunkCache;

@Mod.EventBusSubscriber(modid="tfg", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class CalendarRefrigeratingSanitizer {
    private static long LAST_SERVER_TICK = Long.MIN_VALUE;
    private static final int SANITIZE_INTERVAL_TICKS = 300;
    private static final int LARGE_JUMP_THRESHOLD = 20;
    private static long ACCUMULATED_CAL_TICKS = 0L;
    private static final Map<ServerLevel, Boolean> SANITIZING = new WeakHashMap<ServerLevel, Boolean>();

    @SubscribeEvent
    public static void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
        boolean intervalHit;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        long now = Calendars.SERVER.getTicks();
        long last = LAST_SERVER_TICK;
        if (last == Long.MIN_VALUE) {
            LAST_SERVER_TICK = now;
            return;
        }
        long delta = now - last;
        if (delta <= 0L) {
            LAST_SERVER_TICK = now;
            return;
        }
        boolean largeJump = delta >= 20L;
        boolean bl = intervalHit = (ACCUMULATED_CAL_TICKS += delta) >= 300L;
        if (largeJump || intervalHit) {
            ACCUMULATED_CAL_TICKS = 0L;
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                for (ServerLevel level : server.m_129785_()) {
                    CalendarRefrigeratingSanitizer.sanitizeLevel(level);
                }
            }
        }
        LAST_SERVER_TICK = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sanitizeLevel(@NotNull ServerLevel level) {
        if (Boolean.TRUE.equals(SANITIZING.put(level, Boolean.TRUE))) {
            return;
        }
        try {
            ChunkMap map = ((AccessorServerChunkCache)level.m_7726_()).tfg$getChunkMap();
            HashSet<UUID> seen = new HashSet<UUID>();
            for (ChunkHolder holder : ((AccessorChunkMap)map).tfg$invokeGetChunks()) {
                LevelChunk chunk = holder.m_140085_();
                if (chunk == null) continue;
                for (BlockEntity be : chunk.m_62954_().values()) {
                    if (CalendarRefrigeratingSanitizer.isActiveFridge(be)) continue;
                    be.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(handler -> {
                        if (handler instanceof IItemHandlerModifiable) {
                            IItemHandlerModifiable mod = (IItemHandlerModifiable)handler;
                            CalendarRefrigeratingSanitizer.sanitizeHandler(mod);
                        } else {
                            CalendarRefrigeratingSanitizer.sanitizeHandlerReadOnly(handler);
                        }
                    });
                }
                CalendarRefrigeratingSanitizer.sanitizeItemEntitiesInChunk(level, chunk, seen);
            }
            for (ServerPlayer player : level.m_7654_().m_6846_().m_11314_()) {
                if (player.m_9236_() != level) continue;
                Inventory inv = player.m_150109_();
                for (int i = 0; i < inv.m_6643_(); ++i) {
                    ItemStack sanitized;
                    ItemStack s = inv.m_8020_(i);
                    IFood food = FoodCapability.get((ItemStack)s);
                    if (food == null || !food.hasTrait(TFGFoodTraits.REFRIGERATING) || ItemStack.m_150942_((ItemStack)s, (ItemStack)(sanitized = CalendarRefrigeratingSanitizer.sanitizeRefrigeratingInPlace(s.m_41777_()))) && s.m_41613_() == sanitized.m_41613_()) continue;
                    inv.m_6836_(i, sanitized);
                }
            }
        }
        finally {
            SANITIZING.remove(level);
        }
    }

    private static void sanitizeHandler(IItemHandlerModifiable mod) {
        for (int i = 0; i < mod.getSlots(); ++i) {
            ItemStack sanitized;
            IFood food;
            ItemStack s = mod.getStackInSlot(i);
            if (s.m_41619_() || (food = FoodCapability.get((ItemStack)s)) == null || !food.hasTrait(TFGFoodTraits.REFRIGERATING) || ItemStack.m_150942_((ItemStack)s, (ItemStack)(sanitized = CalendarRefrigeratingSanitizer.sanitizeRefrigeratingInPlace(s.m_41777_()))) && s.m_41613_() == sanitized.m_41613_()) continue;
            mod.setStackInSlot(i, sanitized);
        }
    }

    private static void sanitizeHandlerReadOnly(IItemHandler handler) {
    }

    private static void sanitizeItemEntitiesInChunk(ServerLevel level, LevelChunk chunk, Set<UUID> seen) {
        ChunkPos pos = chunk.m_7697_();
        int minX = pos.m_45604_();
        int minZ = pos.m_45605_();
        int maxX = minX + 15;
        int maxZ = minZ + 15;
        int minY = level.m_141937_();
        int maxY = level.m_151558_() - 1;
        AABB aabb = new AABB((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
        for (ItemEntity entity : level.m_45976_(ItemEntity.class, aabb)) {
            ItemStack sanitized;
            IFood food;
            ItemStack s;
            if (!seen.add(entity.m_20148_()) || (s = entity.m_32055_()).m_41619_() || (food = FoodCapability.get((ItemStack)s)) == null || !food.hasTrait(TFGFoodTraits.REFRIGERATING) || ItemStack.m_150942_((ItemStack)s, (ItemStack)(sanitized = CalendarRefrigeratingSanitizer.sanitizeRefrigeratingInPlace(s.m_41777_()))) && s.m_41613_() == sanitized.m_41613_()) continue;
            entity.m_32045_(sanitized);
        }
    }

    private static boolean isActiveFridge(@NotNull BlockEntity be) {
        IMachineBlockEntity mbe;
        MetaMachine mm;
        if (be instanceof IMachineBlockEntity && (mm = (mbe = (IMachineBlockEntity)be).getMetaMachine()) instanceof FoodRefrigeratorMachine) {
            FoodRefrigeratorMachine fridge = (FoodRefrigeratorMachine)mm;
            return fridge.isActivelyRefrigerating();
        }
        return false;
    }

    private static ItemStack sanitizeRefrigeratingInPlace(@NotNull ItemStack stack) {
        FoodCapability.removeTrait((ItemStack)stack, (FoodTrait)TFGFoodTraits.REFRIGERATING);
        IFood food = FoodCapability.get((ItemStack)stack);
        if (food != null) {
            long orig = food.getCreationDate();
            long rounded = FoodCapability.getRoundedCreationDate((long)orig);
            food.setCreationDate(Math.min(orig, rounded));
        }
        return stack;
    }

    private CalendarRefrigeratingSanitizer() {
    }
}

