/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.world.feature;

import com.mojang.serialization.Codec;
import net.dries007.tfc.common.blocks.SnowPileBlock;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.world.chunkdata.ChunkData;
import net.dries007.tfc.world.chunkdata.ChunkDataProvider;
import net.dries007.tfc.world.noise.Noise2D;
import net.dries007.tfc.world.noise.OpenSimplex2D;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.Fluids;
import su.terrafirmagreg.core.common.data.TFGBlockProperties;
import su.terrafirmagreg.core.common.data.TFGBlocks;
import su.terrafirmagreg.core.common.data.blocks.SandLayerBlock;
import su.terrafirmagreg.core.world.feature.MartianPolesConfig;

public class MartianPolesFeature
extends Feature<MartianPolesConfig> {
    private static final int MARS_SEA_LEVEL = 88;
    private static final Noise2D snowPatchNoise = new OpenSimplex2D(372463264).octaves(2).spread((double)0.3f).scaled(-1.0, 1.0);
    private static final Noise2D icePatchNoise = new OpenSimplex2D(728648234).octaves(3).spread((double)0.6f);

    public MartianPolesFeature(Codec<MartianPolesConfig> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<MartianPolesConfig> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        int startX = pos.m_123341_();
        int startZ = pos.m_123343_();
        ChunkDataProvider provider = ChunkDataProvider.get((ChunkGenerator)context.m_159775_());
        ChunkData chunkData = provider.get(level, new ChunkPos(pos));
        if (chunkData.getAverageTemp(startX, startZ) > (float)((MartianPolesConfig)context.m_159778_()).maximumTemp()) {
            return false;
        }
        int snowStartTemp = ((MartianPolesConfig)context.m_159778_()).snowStartTemp();
        int snowFinishTemp = ((MartianPolesConfig)context.m_159778_()).snowFinishTemp();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        BlockState snowState = Blocks.f_50125_.m_49966_();
        BlockState piledSnowState = (BlockState)Blocks.f_50125_.m_49966_().m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(2));
        BlockState iceState = ((Block)TFGBlocks.MARS_ICE.get()).m_49966_();
        for (int x = startX; x <= startX + 15; ++x) {
            for (int z = startZ; z <= startZ + 15; ++z) {
                float tempModifier;
                mutablePos.m_122178_(x, level.m_6924_(Heightmap.Types.OCEAN_FLOOR, x, z), z);
                float noise = (float)snowPatchNoise.noise((double)x, (double)z);
                float temperature = chunkData.getAverageTemp(x, z);
                float snowTemperatureModifier = Mth.m_184631_((float)temperature, (float)snowFinishTemp, (float)snowStartTemp, (float)-1.0f, (float)1.0f);
                BlockState stateAt = level.m_8055_((BlockPos)mutablePos);
                float snowTempNoise = snowTemperatureModifier + noise;
                if (snowTempNoise < 0.0f) {
                    if ((stateAt.m_60795_() || stateAt.m_60734_() instanceof SandLayerBlock) && snowState.m_60710_((LevelReader)level, (BlockPos)mutablePos)) {
                        level.m_7731_((BlockPos)mutablePos, snowTempNoise < -1.0f ? piledSnowState : snowState, 2);
                        mutablePos.m_122173_(Direction.DOWN);
                        level.m_7731_((BlockPos)mutablePos, Helpers.setProperty((BlockState)level.m_8055_((BlockPos)mutablePos), (Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 2);
                        mutablePos.m_122173_(Direction.UP);
                    } else if (SnowPileBlock.canPlaceSnowPile((LevelAccessor)level, (BlockPos)mutablePos, (BlockState)stateAt) && (!stateAt.m_61138_((Property)TFGBlockProperties.SPACE_WATER) || ((FluidProperty.FluidKey)stateAt.m_61143_((Property)TFGBlockProperties.SPACE_WATER)).getFluid() == Fluids.f_76191_)) {
                        SnowPileBlock.placeSnowPile((LevelAccessor)level, (BlockPos)mutablePos, (BlockState)stateAt, (boolean)false);
                        level.m_7731_((BlockPos)mutablePos, Helpers.setProperty((BlockState)level.m_8055_((BlockPos)mutablePos), (Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(true)), 2);
                    }
                }
                mutablePos.m_122178_(x, level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z), z);
                mutablePos.m_122173_(Direction.DOWN);
                stateAt = level.m_8055_((BlockPos)mutablePos);
                if (!stateAt.m_60713_((Block)TFGBlocks.MARS_WATER.get())) continue;
                float threshold = (float)icePatchNoise.noise((double)((float)x * 0.2f), (double)((float)z * 0.2f)) + Mth.m_14036_((float)(temperature * 0.1f), (float)-0.2f, (float)0.2f);
                int waterDepth = 88 - level.m_6924_(Heightmap.Types.OCEAN_FLOOR, x, z);
                float waterDepthModifier = Mth.m_184631_((float)waterDepth, (float)0.0f, (float)5.0f, (float)0.0f, (float)1.0f);
                if (!(waterDepthModifier + (tempModifier = Mth.m_184631_((float)temperature, (float)snowFinishTemp, (float)snowStartTemp, (float)-0.2f, (float)1.0f)) < threshold) || !(tempModifier < 1.0f)) continue;
                level.m_7731_((BlockPos)mutablePos, iceState, 3);
            }
        }
        return true;
    }
}

