/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.container.widgets;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public final class Slider
extends AbstractSliderButton {
    private final ResourceLocation bgTex;
    private final int bgTexW;
    private final int bgTexH;
    private final ResourceLocation handleTex;
    private final int handleW;
    private final int handleH;
    private final int min;
    private final int max;
    private final IntSupplier valueSupplier;
    private final IntConsumer onReleased;

    public Slider(int x, int y, int width, int height, ResourceLocation backgroundTex, int bgTexWidth, int bgTexHeight, ResourceLocation handleTex, int handleWidth, int handleHeight, int min, int max, IntSupplier valueSupplier, IntConsumer onReleased) {
        super(x, y, width, height, (Component)Component.m_237119_(), 0.0);
        this.bgTex = backgroundTex;
        this.bgTexW = bgTexWidth;
        this.bgTexH = bgTexHeight;
        this.handleTex = handleTex;
        this.handleW = handleWidth;
        this.handleH = handleHeight;
        this.min = min;
        this.max = max;
        this.valueSupplier = valueSupplier;
        this.onReleased = onReleased;
        int supplied = valueSupplier != null ? valueSupplier.getAsInt() : min;
        this.f_93577_ = this.toSliderValue(supplied);
        this.m_5695_();
    }

    private int getIntValue() {
        int range = this.max - this.min;
        return Mth.m_14045_((int)(this.min + (int)Math.round(this.f_93577_ * (double)range)), (int)this.min, (int)this.max);
    }

    private double toSliderValue(int v) {
        int range = this.max - this.min;
        if (range == 0) {
            return 0.0;
        }
        return (double)(Mth.m_14045_((int)v, (int)this.min, (int)this.max) - this.min) / (double)range;
    }

    public int getDisplayValue() {
        return this.getIntValue();
    }

    protected void m_5695_() {
        this.m_93666_((Component)Component.m_237119_());
    }

    protected void m_5697_() {
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.m_93585_(mouseX);
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        this.m_93585_(mouseX);
        super.m_7212_(mouseX, mouseY, dragX, dragY);
    }

    private void m_93585_(double mouseX) {
        this.f_93577_ = Mth.m_14008_((double)((mouseX - (double)(this.m_252754_() + 4)) / (double)(this.f_93618_ - 8)), (double)0.0, (double)1.0);
        this.m_5695_();
    }

    public void m_7691_(double mouseX, double mouseY) {
        super.m_7691_(mouseX, mouseY);
        if (this.onReleased != null) {
            this.onReleased.accept(this.getIntValue());
        }
    }

    public void m_87963_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float partialTick) {
        int v;
        double newValue;
        if (!this.f_93623_ && Double.compare(this.f_93577_, newValue = this.toSliderValue(v = this.valueSupplier != null ? this.valueSupplier.getAsInt() : this.getIntValue())) != 0) {
            this.f_93577_ = newValue;
        }
        int drawBgW = Math.min(this.f_93618_, this.bgTexW);
        int drawBgH = Math.min(this.f_93619_, this.bgTexH);
        gg.m_280163_(this.bgTex, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, drawBgW, drawBgH, this.bgTexW, this.bgTexH);
        int travel = Math.max(0, this.f_93618_ - this.handleW);
        int handleTravel = this.f_93618_ - 8;
        int handleX = this.m_252754_() + 4 + Mth.m_14045_((int)((int)Math.round(this.f_93577_ * (double)(handleTravel - this.handleW))), (int)0, (int)(handleTravel - this.handleW));
        int handleY = this.m_252907_() + Math.max(0, (this.f_93619_ - this.handleH) / 2);
        gg.m_280163_(this.handleTex, handleX, handleY, 0.0f, 0.0f, this.handleW, this.handleH, this.handleW, this.handleH);
        if (this.f_93623_ && this.m_5953_(mouseX, mouseY)) {
            gg.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 0x40FFFFFF);
        }
        if (!this.f_93623_) {
            gg.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, Integer.MIN_VALUE);
        }
    }
}

