/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.entities.ai;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.pathfinder.Path;
import su.terrafirmagreg.core.common.data.entities.TFGWoolEggProducingAnimal;
import su.terrafirmagreg.core.common.data.entities.ai.TFGBrain;

public class NearestLargeNestSensor
extends Sensor<TFGWoolEggProducingAnimal> {
    private static final int CACHE_TIMEOUT = 40;
    private static final int BATCH_SIZE = 5;
    private int triedCount;
    private long lastUpdate;
    private final Long2LongMap batchCache = new Long2LongOpenHashMap();

    protected void doTick(ServerLevel level, TFGWoolEggProducingAnimal animal) {
        if (animal.isReadyForAnimalProduct() && !animal.m_20159_()) {
            this.triedCount = 0;
            this.lastUpdate = level.m_46467_() + (long)level.m_213780_().m_188503_(20);
            PoiManager manager = level.m_8904_();
            Predicate<BlockPos> predicate = pos -> {
                long packed = pos.m_121878_();
                if (this.batchCache.containsKey(packed)) {
                    return false;
                }
                if (++this.triedCount >= 5) {
                    return false;
                }
                this.batchCache.putIfAbsent(packed, this.lastUpdate + 40L);
                return true;
            };
            Stream found = manager.m_27138_(p -> p.m_203334_() == TFGBrain.LARGE_NEST_POI.get() || p.m_203334_() == TFGBrain.WARPED_LARGE_NEST_POI.get(), predicate, animal.m_20183_(), 48, PoiManager.Occupancy.ANY);
            Path path = animal.m_21573_().m_26556_(found, ((PoiType)TFGBrain.LARGE_NEST_POI.get()).f_27328_());
            if (path != null && path.m_77403_()) {
                BlockPos target = path.m_77406_();
                manager.m_27177_(target).ifPresent(poi -> animal.m_6274_().m_21879_((MemoryModuleType)TFGBrain.LARGE_NEST_MEMORY.get(), (Object)target));
            } else if (this.triedCount < 5) {
                this.batchCache.long2LongEntrySet().removeIf(set -> set.getLongValue() < this.lastUpdate);
            }
        }
    }

    public Set<MemoryModuleType<?>> m_7163_() {
        return ImmutableSet.of((Object)((MemoryModuleType)TFGBrain.LARGE_NEST_MEMORY.get()));
    }
}

