/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.entities.astikorcarts;

import com.therighthon.rnr.common.recipe.BlockModRecipe;
import de.mennomax.astikorcarts.config.AstikorCartsConfig;
import de.mennomax.astikorcarts.entity.AbstractDrawnInventoryEntity;
import de.mennomax.astikorcarts.util.CartItemStackHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.dries007.tfc.common.TFCTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.common.data.TFGItems;
import su.terrafirmagreg.core.common.data.entities.astikorcarts.RNRPlowContainer;

public final class RNRPlow
extends AbstractDrawnInventoryEntity {
    private static final int CART_SLOT_COUNT = 54;
    private static final int UPPER_START = 0;
    private static final int UPPER_END_EXCLUSIVE = 27;
    private static final int LOWER_START = 27;
    private static final int LOWER_END_EXCLUSIVE = 54;
    private static final double BLADEOFFSET = 1.7;
    private static final int MIN_PLOW_WIDTH = 1;
    private static final int MAX_PLOW_WIDTH = 5;
    private static final int DEFAULT_PLOW_WIDTH = 3;
    private static final float HALF_SPREAD_DEGREES = 38.0f;
    private static final EntityDataAccessor<Boolean> PLOWING = SynchedEntityData.m_135353_(RNRPlow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> PLOW_WIDTH = SynchedEntityData.m_135353_(RNRPlow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PLOW_TEXTURE = SynchedEntityData.m_135353_(RNRPlow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final ResourceLocation CRUSHED_BASE_COURSE_ID = ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)"crushed_base_course");
    private static final ResourceLocation BASE_COURSE_BLOCK_ID = ResourceLocation.fromNamespaceAndPath((String)"rnr", (String)"base_course");
    private static final List<TagKey<Block>> BASE_COURSE_SOURCE_TAGS = List.of(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tfg", (String)"base_course_sources")), TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"dirt")), TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)"mud")), TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)"grass")));
    public ItemStackHandler inventory;
    private final List<BlockPos> delayedActivations = new ArrayList<BlockPos>();
    private final List<BlockPos> queuedActivations = new ArrayList<BlockPos>();
    private int lastNoCrushedWarnTick = -100;
    private boolean isRandom = false;

    public RNRPlow(EntityType<? extends RNRPlow> type, Level level) {
        super(type, level);
        this.spacing = 1.3;
    }

    @NotNull
    public Item getCartItem() {
        return (Item)TFGItems.RNR_PLOW.get();
    }

    protected AstikorCartsConfig.CartConfig getConfig() {
        return AstikorCartsConfig.get().plow;
    }

    protected ItemStackHandler initInventory() {
        this.inventory = new CartItemStackHandler<RNRPlow>(54, this){};
        return this.inventory;
    }

    public boolean getPlowing() {
        return (Boolean)this.f_19804_.m_135370_(PLOWING);
    }

    public int getPlowWidth() {
        return Mth.m_14045_((int)((Integer)this.f_19804_.m_135370_(PLOW_WIDTH)), (int)1, (int)5);
    }

    public void setPlowWidth(int width) {
        this.f_19804_.m_135381_(PLOW_WIDTH, (Object)Mth.m_14045_((int)width, (int)1, (int)5));
    }

    public int getPlowTextureVariant() {
        return Math.max(0, (Integer)this.f_19804_.m_135370_(PLOW_TEXTURE));
    }

    public void setPlowTextureVariant(int variant) {
        this.f_19804_.m_135381_(PLOW_TEXTURE, (Object)Math.max(0, variant));
    }

    public void pulledTick() {
        super.pulledTick();
        if (!this.m_9236_().f_46443_) {
            this.processDelayedActivations();
            if (this.getPulling() == null) {
                return;
            }
            Player player = null;
            Entity entity = this.getPulling();
            if (entity instanceof Player) {
                Player pl;
                player = pl = (Player)entity;
            } else {
                entity = this.getPulling().m_6688_();
                if (entity instanceof Player) {
                    Player pl;
                    player = pl = (Player)entity;
                }
            }
            if (player != null && this.getPlowing() && (this.f_19854_ != this.m_20185_() || this.f_19856_ != this.m_20189_())) {
                this.plow(player);
            }
        }
    }

    private boolean ignoredCeilings(BlockState state) {
        return state.m_60795_() || state.m_204336_(BlockTags.f_278394_) || state.m_204336_(TFCTags.Blocks.CAN_BE_SNOW_PILED) || state.m_204336_(TFCTags.Blocks.SINGLE_BLOCK_REPLACEABLE);
    }

    private boolean isAboveClear(ServerLevel server, BlockPos pos) {
        BlockState above = server.m_8055_(pos.m_7494_());
        return this.ignoredCeilings(above);
    }

    private static boolean isAnyTagged(BlockState state) {
        for (TagKey<Block> tag : BASE_COURSE_SOURCE_TAGS) {
            if (!state.m_204336_(tag)) continue;
            return true;
        }
        return false;
    }

    private void plow(Player player) {
        int lanes;
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Block baseCourse = (Block)ForgeRegistries.BLOCKS.getValue(BASE_COURSE_BLOCK_ID);
        Item crushedItem = (Item)ForgeRegistries.ITEMS.getValue(CRUSHED_BASE_COURSE_ID);
        if (baseCourse == null || crushedItem == null) {
            return;
        }
        if (!this.hasAnyCrushedInLowerInventory(crushedItem) && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (this.f_19797_ - this.lastNoCrushedWarnTick >= 20) {
                sp.m_5661_((Component)Component.m_237115_((String)"tfg.gui.rnr_plow.empty_crushed_base_course"), true);
                this.lastNoCrushedWarnTick = this.f_19797_;
            }
        }
        if ((lanes = this.getPlowWidth()) <= 0) {
            return;
        }
        double yawRad = Math.toRadians(this.m_146908_());
        double fx = Math.sin(yawRad);
        double fz = -Math.cos(yawRad);
        double px = Math.cos(yawRad);
        double pz = Math.sin(yawRad);
        double centerX = this.m_20185_() + fx * 1.7;
        double centerZ = this.m_20189_() + fz * 1.7;
        double mid = (double)(lanes - 1) / 2.0;
        double laneSpacing = 1.0;
        for (int i = 0; i < lanes; ++i) {
            double lateral = ((double)i - mid) * 1.0;
            double x = centerX + px * lateral;
            double z = centerZ + pz * lateral;
            Vec3 v = new Vec3(x, this.m_20186_() - 0.5, z);
            BlockPos top = BlockPos.m_274446_((Position)v);
            BlockPos below = top.m_7495_();
            if (server.m_8055_(top).m_60713_(baseCourse) && this.tryApplyTopInventoryTransformation(server, top)) {
                this.queueActivation(top);
            }
            if (server.m_8055_(below).m_60713_(baseCourse) && this.tryApplyTopInventoryTransformation(server, below)) {
                this.queueActivation(below);
            }
            if (this.placeBaseCourseIfValid(server, top, baseCourse, crushedItem)) continue;
            this.placeBaseCourseIfValid(server, below, baseCourse, crushedItem);
        }
    }

    private boolean hasAnyCrushedInLowerInventory(Item crushed) {
        if (crushed == null) {
            return false;
        }
        int slots = this.inventory.getSlots();
        int start = Math.max(27, 0);
        int end = Math.min(54, slots);
        for (int i = start; i < end; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_() || !stack.m_150930_(crushed)) continue;
            return true;
        }
        return false;
    }

    private boolean placeBaseCourseIfValid(ServerLevel server, BlockPos pos, Block baseCourse, Item crushedItem) {
        BlockState in = server.m_8055_(pos);
        if (!RNRPlow.isAnyTagged(in)) {
            return false;
        }
        if (!this.isAboveClear(server, pos)) {
            return false;
        }
        if (!this.consumeCrushedBaseCourse(crushedItem)) {
            return false;
        }
        server.m_7731_(pos, baseCourse.m_49966_(), 3);
        server.m_5594_(null, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 0.2f, 1.0f);
        if (this.tryApplyTopInventoryTransformation(server, pos)) {
            this.queueActivation(pos);
        }
        return true;
    }

    private boolean consumeCrushedBaseCourse(Item crushed) {
        if (crushed == null) {
            return false;
        }
        int slots = this.inventory.getSlots();
        int start = Math.max(27, 0);
        int end = Math.min(54, slots);
        for (int i = start; i < end; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_() || !stack.m_150930_(crushed)) continue;
            ItemStack copy = stack.m_41777_();
            copy.m_41774_(1);
            this.inventory.setStackInSlot(i, copy.m_41619_() ? ItemStack.f_41583_ : copy);
            return true;
        }
        return false;
    }

    private void queueActivation(BlockPos pos) {
        BlockPos imm = pos.m_7949_();
        if (!this.queuedActivations.contains(imm) && !this.delayedActivations.contains(imm)) {
            this.queuedActivations.add(imm);
        }
    }

    private void processDelayedActivations() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Block baseCourse = (Block)ForgeRegistries.BLOCKS.getValue(BASE_COURSE_BLOCK_ID);
        if (baseCourse == null) {
            return;
        }
        ArrayList<BlockPos> batch = new ArrayList<BlockPos>(this.queuedActivations);
        this.queuedActivations.clear();
        batch.addAll(this.delayedActivations);
        this.delayedActivations.clear();
        HashSet<BlockPos> unique = new HashSet<BlockPos>(batch);
        for (BlockPos pos : unique) {
            if (!server.m_8055_(pos).m_60713_(baseCourse) || !this.tryApplyTopInventoryTransformation(server, pos)) continue;
            this.delayedActivations.add(pos);
        }
    }

    private boolean tryApplyTopInventoryTransformation(ServerLevel server, BlockPos pos) {
        Block baseCourse = (Block)ForgeRegistries.BLOCKS.getValue(BASE_COURSE_BLOCK_ID);
        if (baseCourse == null) {
            return true;
        }
        BlockState in = server.m_8055_(pos);
        if (in.m_60734_() != baseCourse) {
            return true;
        }
        InvPeek peek = this.peekOneFromUpperInventory();
        if (peek == null || peek.one.m_41619_()) {
            return true;
        }
        Boolean result = this.tryRnrBlockModRecipe(server, pos, peek.one);
        if (result == null) {
            return true;
        }
        if (result.booleanValue()) {
            this.shrinkUpperSlot(peek.slot, 1);
        }
        return false;
    }

    @Nullable
    private Boolean tryRnrBlockModRecipe(ServerLevel level, BlockPos pos, ItemStack held) {
        if (held.m_41619_()) {
            return null;
        }
        BlockState in = level.m_8055_(pos);
        BlockModRecipe recipe = BlockModRecipe.getRecipe((BlockState)in, (ItemStack)held);
        if (recipe == null) {
            return null;
        }
        BlockState out = recipe.getOutputBlock();
        if (out == null || out == in) {
            return null;
        }
        level.m_7731_(pos, out, 3);
        return Boolean.TRUE.equals(recipe.consumesItem());
    }

    private InvPeek peekOneFromUpperInventory() {
        int slots = this.inventory.getSlots();
        boolean start = false;
        int end = Math.min(27, slots);
        if (!this.isRandom) {
            for (int i = 0; i < end; ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemStack one = stack.m_41777_();
                one.m_41764_(1);
                return new InvPeek(i, one);
            }
            return null;
        }
        ArrayList<Integer> filledIndices = new ArrayList<Integer>();
        for (int i = 0; i < end; ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            filledIndices.add(i);
        }
        if (filledIndices.isEmpty()) {
            return null;
        }
        int chosenIndex = (Integer)filledIndices.get(this.f_19796_.m_188503_(filledIndices.size()));
        ItemStack one = this.inventory.getStackInSlot(chosenIndex).m_41777_();
        one.m_41764_(1);
        return new InvPeek(chosenIndex, one);
    }

    private void shrinkUpperSlot(int slot, int count) {
        if (slot < 0 || slot >= this.inventory.getSlots() || count <= 0) {
            return;
        }
        ItemStack stack = this.inventory.getStackInSlot(slot);
        if (stack.m_41619_()) {
            return;
        }
        ItemStack remaining = stack.m_41777_();
        remaining.m_41774_(count);
        this.inventory.setStackInSlot(slot, remaining.m_41619_() ? ItemStack.f_41583_ : remaining);
    }

    public boolean isRandomMode() {
        return this.isRandom;
    }

    public void setRandomMode(boolean value) {
        this.isRandom = value;
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        if (player.m_36341_()) {
            this.openContainer(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(PLOWING, (Object)((Boolean)this.f_19804_.m_135370_(PLOWING) == false ? 1 : 0));
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PLOWING, (Object)false);
        this.f_19804_.m_135372_(PLOW_WIDTH, (Object)3);
        this.f_19804_.m_135372_(PLOW_TEXTURE, (Object)0);
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(PLOWING, (Object)compound.m_128471_("Plowing"));
        if (compound.m_128441_("PlowWidth")) {
            this.setPlowWidth(compound.m_128451_("PlowWidth"));
        }
        if (compound.m_128441_("PlowTexture")) {
            this.setPlowTextureVariant(compound.m_128451_("PlowTexture"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Plowing", ((Boolean)this.f_19804_.m_135370_(PLOWING)).booleanValue());
        compound.m_128405_("PlowWidth", this.getPlowWidth());
        compound.m_128405_("PlowTexture", this.getPlowTextureVariant());
    }

    private void openContainer(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((windowId, playerInventory, p) -> new RNRPlowContainer(windowId, playerInventory, this), this.m_5446_()), buf -> buf.writeInt(this.m_19879_()));
        }
    }

    private record InvPeek(int slot, ItemStack one) {
    }
}

