/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.entities.astikorcarts;

import de.mennomax.astikorcarts.client.renderer.entity.model.CartModel;
import de.mennomax.astikorcarts.client.renderer.entity.model.EasyMeshBuilder;
import de.mennomax.astikorcarts.entity.AbstractDrawnEntity;
import lombok.Generated;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import su.terrafirmagreg.core.common.data.entities.astikorcarts.RNRPlow;

public final class RNRPlowModel
extends CartModel<RNRPlow> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("tfg:rnr_plow"), "main");
    private final ModelPart[] plowShaftUpper = new ModelPart[3];
    private final ModelPart[] plowShaftLower = new ModelPart[3];
    private final ModelPart axis;
    private final ModelPart shaftsGroup;
    private final ModelPart triangle0;
    private final ModelPart triangle1;

    public RNRPlowModel(ModelPart root) {
        super(root);
        ModelPart body = root.m_171324_("body");
        this.axis = body.m_171324_("axis");
        ModelPart partsGroup = body.m_171324_("parts");
        this.shaftsGroup = partsGroup.m_171324_("shafts");
        this.triangle0 = partsGroup.m_171324_("triangle_0");
        this.triangle1 = partsGroup.m_171324_("triangle_1");
        for (int i = 0; i < this.plowShaftUpper.length; ++i) {
            this.plowShaftUpper[i] = partsGroup.m_171324_("plow_shaft_upper_" + i);
            this.plowShaftLower[i] = this.plowShaftUpper[i].m_171324_("plow_shaft_lower_" + i);
        }
    }

    public ModelPart getUpperShaft(int i) {
        return this.plowShaftUpper[i];
    }

    public void setupAnim(@NotNull RNRPlow entity, float delta, float limbSwingAmount, float ageInTicks, float netHeadYaw, float pitch) {
        super.setupAnim((AbstractDrawnEntity)entity, delta, limbSwingAmount, ageInTicks, netHeadYaw, pitch);
        for (ModelPart upper : this.plowShaftUpper) {
            upper.f_104203_ = (float)(entity.getPlowing() ? 0.7853981633974483 - Math.toRadians(pitch) : 1.2566370614359172);
        }
        this.axis.f_104207_ = false;
        this.triangle0.f_104207_ = false;
        this.triangle1.f_104207_ = false;
        this.shaftsGroup.f_104207_ = false;
        for (ModelPart upper : this.plowShaftUpper) {
            upper.f_104207_ = false;
        }
    }

    public static LayerDefinition createLayer() {
        MeshDefinition def = CartModel.createDefinition();
        EasyMeshBuilder axis = new EasyMeshBuilder("axis", 0, 0);
        axis.addBox(-12.5f, -1.0f, -1.0f, 25.0f, 2.0f, 2.0f);
        EasyMeshBuilder[] triangle = new EasyMeshBuilder[3];
        triangle[0] = new EasyMeshBuilder("triangle_0", 0, 4);
        triangle[0].addBox(-7.5f, -5.0f, -10.0f, 15.0f, 4.0f, 22.0f);
        triangle[1] = new EasyMeshBuilder("triangle_1", 0, 11);
        triangle[1].addBox(-6.5f, -3.0f, -9.0f, 13.0f, 13.0f, 20.0f);
        EasyMeshBuilder shaft = new EasyMeshBuilder("shaft", 0, 8);
        shaft.zRot = -0.07f;
        shaft.addBox(0.0f, 0.0f, -8.0f, 20.0f, 2.0f, 1.0f);
        shaft.addBox(0.0f, 0.0f, 7.0f, 20.0f, 2.0f, 1.0f);
        EasyMeshBuilder shaftConnector = new EasyMeshBuilder("shaftConnector", 0, 27);
        shaftConnector.zRot = -0.26f;
        shaftConnector.addBox(-16.0f, 0.0f, -8.0f, 16.0f, 2.0f, 1.0f);
        shaftConnector.addBox(-16.0f, 0.0f, 7.0f, 16.0f, 2.0f, 1.0f);
        EasyMeshBuilder shafts = new EasyMeshBuilder("shafts");
        shafts.setRotationPoint(0.0f, 0.0f, -14.0f);
        shafts.yRot = 1.5707964f;
        shafts.addChild(shaft);
        shafts.addChild(shaftConnector);
        EasyMeshBuilder[] plowShaftUpper = new EasyMeshBuilder[3];
        EasyMeshBuilder[] plowShaftLower = new EasyMeshBuilder[3];
        for (int i = 0; i < plowShaftUpper.length; ++i) {
            plowShaftUpper[i] = new EasyMeshBuilder("plow_shaft_upper_" + i, 56, 0);
            plowShaftUpper[i].addBox(-1.0f, 2.0f, -2.0f, 1.0f, 20.0f, 6.0f);
            plowShaftUpper[i].setRotationPoint(-3.0f + 3.5f * (float)i, -1.0f, 0.0f);
            plowShaftUpper[i].yRot = -0.523599f + 0.5235988f * (float)i;
            plowShaftLower[i] = new EasyMeshBuilder("plow_shaft_lower_" + i, 42, 4);
            plowShaftLower[i].addBox(-1.0f, -0.7f, -0.7f, 0.0f, 0.0f, 0.0f);
            plowShaftLower[i].setRotationPoint(0.0f, 28.0f, -1.0f);
            plowShaftLower[i].xRot = 0.7853982f;
            plowShaftUpper[i].addChild(plowShaftLower[i]);
        }
        EasyMeshBuilder parts = new EasyMeshBuilder("parts");
        parts.setRotationPoint(0.0f, -5.0f, -1.0f);
        parts.addChild(shafts);
        parts.addChild(triangle[0]);
        parts.addChild(triangle[1]);
        parts.addChild(plowShaftUpper[0]);
        parts.addChild(plowShaftUpper[1]);
        parts.addChild(plowShaftUpper[2]);
        EasyMeshBuilder body = CartModel.createBody();
        body.addChild(axis);
        body.addChild(parts);
        body.build(def.m_171576_());
        return LayerDefinition.m_171565_((MeshDefinition)def, (int)64, (int)64);
    }

    @Generated
    public ModelPart getAxis() {
        return this.axis;
    }

    @Generated
    public ModelPart getShaftsGroup() {
        return this.shaftsGroup;
    }

    @Generated
    public ModelPart getTriangle0() {
        return this.triangle0;
    }

    @Generated
    public ModelPart getTriangle1() {
        return this.triangle1;
    }
}

