/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.phys.Vec3;

public class RailgunBoom
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final int count;
    private final int delay;
    private final float scale;
    private final float gap;

    public RailgunBoom(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, SpriteSet sprites) {
        super(level, x, y, z, dx, dy, dz);
        this.sprites = sprites;
        this.scale = 1.0f + this.f_107223_.m_188501_() * 1.5f;
        this.m_107250_(this.scale, this.scale);
        this.count = 5;
        this.delay = 3;
        this.gap = 3.0f;
        this.f_107226_ = 0.0f;
        this.f_107219_ = false;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.f_107225_ = this.count * this.delay + 5;
    }

    public float m_5902_(float partialTicks) {
        return this.scale;
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        Vec3 view = camera.m_90583_();
        double baseX = this.f_107209_ + (this.f_107212_ - this.f_107209_) * (double)partialTicks - view.f_82479_;
        double baseY = this.f_107210_ + (this.f_107213_ - this.f_107210_) * (double)partialTicks - view.f_82480_;
        double baseZ = this.f_107211_ + (this.f_107214_ - this.f_107211_) * (double)partialTicks - view.f_82481_;
        float r = this.f_107227_;
        float g = this.f_107228_;
        float b = this.f_107229_;
        float a = this.f_107230_;
        int light = this.m_6355_(partialTicks);
        for (int i = 0; i < this.count; ++i) {
            int localAge = this.f_107224_ - i * this.delay;
            int localLifetime = this.delay * this.count;
            if (localAge < 0 || localAge >= localLifetime) continue;
            this.setSpriteFromLocalAge(this.sprites, localAge, localLifetime);
            float currentScale = this.scale * (float)(this.count - i);
            float half = currentScale / 2.0f;
            float u0 = this.m_5970_();
            float u1 = this.m_5952_();
            float v0 = this.m_5951_();
            float v1 = this.m_5950_();
            double yOffset = (float)i * this.gap;
            double px = baseX;
            double py = baseY + yOffset;
            double pz = baseZ;
            this.addQuad(buffer, px, py, pz, -half, half, u0, u1, v0, v1, r, g, b, a, light);
            this.addQuad(buffer, px, py, pz, half, -half, u0, u1, v0, v1, r, g, b, a, light);
        }
    }

    private void setSpriteFromLocalAge(SpriteSet spriteSet, int localAge, int localLifetime) {
        this.m_108337_(spriteSet.m_5819_(localAge, localLifetime));
    }

    private void addQuad(VertexConsumer buffer, double x, double y, double z, float leftOffset, float rightOffset, float u0, float u1, float v0, float v1, float r, float g, float b, float a, int light) {
        buffer.m_5483_(x + (double)leftOffset, y, z + (double)rightOffset).m_7421_(u0, v0).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
        buffer.m_5483_(x + (double)leftOffset, y, z + (double)leftOffset).m_7421_(u0, v1).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
        buffer.m_5483_(x + (double)rightOffset, y, z + (double)leftOffset).m_7421_(u1, v1).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
        buffer.m_5483_(x + (double)rightOffset, y, z + (double)rightOffset).m_7421_(u1, v0).m_85950_(r, g, b, a).m_85969_(light).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }
}

