/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.compat.kjs;

import com.gregtechceu.gtceu.api.block.property.GTBlockStateProperties;
import com.notenoughmail.kubejs_tfc.block.internal.ExtendedPropertiesBlockBuilder;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.Lazy;
import su.terrafirmagreg.core.common.data.blocks.ActiveParticleBlock;

public class GTActiveParticleBuilder
extends ExtendedPropertiesBlockBuilder {
    public static final List<Block> REGISTERED_BLOCKS = new ArrayList<Block>();
    public transient VoxelShape cachedShape;
    public transient Supplier<Item> preexistingItem;
    public transient Supplier<Item> itemBuilder;
    private transient Supplier<SimpleParticleType> inactiveParticle = () -> ParticleTypes.f_123783_;
    private transient boolean hasInactive = false;
    private transient double inactiveBaseX = 0.5;
    private transient double inactiveBaseY = 0.5;
    private transient double inactiveBaseZ = 0.5;
    private transient double inactiveOffsetX;
    private transient double inactiveOffsetY;
    private transient double inactiveOffsetZ;
    private transient double inactiveVelX;
    private transient double inactiveVelY;
    private transient double inactiveVelZ;
    private transient int inactiveCount = 1;
    private transient boolean inactiveForced = false;
    private transient boolean inactiveUseDust = false;
    private transient float inactiveDustRed;
    private transient float inactiveDustGreen;
    private transient float inactiveDustBlue;
    private transient float inactiveDustScale;
    private transient Supplier<SimpleParticleType> activeParticle = () -> ParticleTypes.f_123778_;
    private transient boolean hasActive = false;
    private transient double activeBaseX = 0.5;
    private transient double activeBaseY = 0.5;
    private transient double activeBaseZ = 0.5;
    private transient double activeOffsetX;
    private transient double activeOffsetY;
    private transient double activeOffsetZ;
    private transient double activeVelX;
    private transient double activeVelY;
    private transient double activeVelZ;
    private transient int activeCount = 1;
    private transient boolean activeForced = false;
    private transient boolean activeUseDust = false;
    private transient float activeDustRed;
    private transient float activeDustGreen;
    private transient float activeDustBlue;
    private transient float activeDustScale;
    private transient boolean hasTicker = false;
    private transient int emitDelay = 0;

    public GTActiveParticleBuilder(ResourceLocation id) {
        super(id);
        this.property((Property)GTBlockStateProperties.ACTIVE);
    }

    @Info(value="Enable/disable block entity ticker (default false).")
    public GTActiveParticleBuilder hasTicker(boolean enabled) {
        this.hasTicker = enabled;
        return this;
    }

    @Info(value="Random emission delay scale")
    public GTActiveParticleBuilder emitDelay(int delay) {
        this.emitDelay = Math.max(0, delay);
        return this;
    }

    @Info(value="Inactive particle id.")
    public GTActiveParticleBuilder inactiveParticle(String id) {
        this.inactiveParticle = this.resolveParticle(id, true);
        this.hasInactive = true;
        return this;
    }

    @Info(value="Inactive base position.")
    public GTActiveParticleBuilder inactiveBase(double x, double y, double z) {
        this.inactiveBaseX = x;
        this.inactiveBaseY = y;
        this.inactiveBaseZ = z;
        return this;
    }

    @Info(value="Inactive spread offsets.")
    public GTActiveParticleBuilder inactiveOffset(double x, double y, double z) {
        this.inactiveOffsetX = x;
        this.inactiveOffsetY = y;
        this.inactiveOffsetZ = z;
        return this;
    }

    @Info(value="Inactive velocity.")
    public GTActiveParticleBuilder inactiveVelocity(double x, double y, double z) {
        this.inactiveVelX = x;
        this.inactiveVelY = y;
        this.inactiveVelZ = z;
        return this;
    }

    @Info(value="Inactive particle count.")
    public GTActiveParticleBuilder inactiveCount(int count) {
        this.inactiveCount = count;
        return this;
    }

    @Info(value="Inactive always visible.")
    public GTActiveParticleBuilder inactiveForced(boolean forced) {
        this.inactiveForced = forced;
        return this;
    }

    @Info(value="Inactive dust color + scale.")
    public GTActiveParticleBuilder inactiveDust(float r, float g, float b, float scale) {
        this.inactiveUseDust = true;
        this.inactiveDustRed = r;
        this.inactiveDustGreen = g;
        this.inactiveDustBlue = b;
        this.inactiveDustScale = scale;
        return this;
    }

    @Info(value="Active particle id.")
    public GTActiveParticleBuilder activeParticle(String id) {
        this.activeParticle = this.resolveParticle(id, false);
        this.hasActive = true;
        return this;
    }

    @Info(value="Active base position.")
    public GTActiveParticleBuilder activeBase(double x, double y, double z) {
        this.activeBaseX = x;
        this.activeBaseY = y;
        this.activeBaseZ = z;
        return this;
    }

    @Info(value="Active spread offsets.")
    public GTActiveParticleBuilder activeOffset(double x, double y, double z) {
        this.activeOffsetX = x;
        this.activeOffsetY = y;
        this.activeOffsetZ = z;
        return this;
    }

    @Info(value="Active velocity.")
    public GTActiveParticleBuilder activeVelocity(double x, double y, double z) {
        this.activeVelX = x;
        this.activeVelY = y;
        this.activeVelZ = z;
        return this;
    }

    @Info(value="Active particle count.")
    public GTActiveParticleBuilder activeCount(int count) {
        this.activeCount = count;
        return this;
    }

    @Info(value="Active always visible.")
    public GTActiveParticleBuilder activeForced(boolean forced) {
        this.activeForced = forced;
        return this;
    }

    @Info(value="Active dust color + scale.")
    public GTActiveParticleBuilder activeDust(float r, float g, float b, float scale) {
        this.activeUseDust = true;
        this.activeDustRed = r;
        this.activeDustGreen = g;
        this.activeDustBlue = b;
        this.activeDustScale = scale;
        return this;
    }

    @HideFromJS
    public VoxelShape getShape() {
        if (this.customShape.isEmpty()) {
            return ActiveParticleBlock.DEFAULT_SHAPE;
        }
        if (this.cachedShape == null) {
            this.cachedShape = BlockBuilder.createShape((List)this.customShape);
        }
        return this.cachedShape;
    }

    @HideFromJS
    public Supplier<Item> itemSupplier() {
        if (this.preexistingItem != null) {
            return this.preexistingItem;
        }
        if (this.itemBuilder != null) {
            return this.itemBuilder;
        }
        return null;
    }

    public ActiveParticleBlock createObject() {
        ActiveParticleBlock.ParticleConfig inactiveCfg = this.hasInactive ? new ActiveParticleBlock.ParticleConfig(this.inactiveParticle, this.inactiveBaseX, this.inactiveBaseY, this.inactiveBaseZ, this.inactiveOffsetX, this.inactiveOffsetY, this.inactiveOffsetZ, this.inactiveVelX, this.inactiveVelY, this.inactiveVelZ, this.inactiveCount, this.inactiveForced, this.inactiveUseDust, this.inactiveDustRed, this.inactiveDustGreen, this.inactiveDustBlue, this.inactiveDustScale) : null;
        ActiveParticleBlock.ParticleConfig activeCfg = this.hasActive ? new ActiveParticleBlock.ParticleConfig(this.activeParticle, this.activeBaseX, this.activeBaseY, this.activeBaseZ, this.activeOffsetX, this.activeOffsetY, this.activeOffsetZ, this.activeVelX, this.activeVelY, this.activeVelZ, this.activeCount, this.activeForced, this.activeUseDust, this.activeDustRed, this.activeDustGreen, this.activeDustBlue, this.activeDustScale) : null;
        ActiveParticleBlock block = new ActiveParticleBlock(this.createProperties(), this.getShape(), this.itemSupplier(), inactiveCfg, activeCfg, this.hasTicker, this.emitDelay);
        if (this.hasTicker) {
            REGISTERED_BLOCKS.add((Block)block);
        }
        return block;
    }

    private Supplier<SimpleParticleType> resolveParticle(String id, boolean isInactive) {
        ResourceLocation rl = ResourceLocation.m_135820_((String)id);
        if ("minecraft:dust".equals(id)) {
            if (isInactive) {
                this.inactiveUseDust = true;
            } else {
                this.activeUseDust = true;
            }
        }
        return Lazy.of(() -> {
            ParticleType pt = (ParticleType)RegistryInfo.PARTICLE_TYPE.getValue(rl);
            if (pt instanceof SimpleParticleType) {
                SimpleParticleType simple = (SimpleParticleType)pt;
                return simple;
            }
            throw new IllegalArgumentException("Particle type '" + id + "' is not a SimpleParticleType");
        });
    }
}

