/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.mixins.common.firmalife;

import com.eerussianguy.firmalife.common.blockentities.HydroponicPlanterBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.SprinklerBlockEntity;
import java.lang.reflect.Field;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={HydroponicPlanterBlockEntity.class})
public abstract class HydroponicPlanterBlockEntityMixin {
    @Unique
    private static final Field HAS_PIPE_FIELD;

    @Redirect(method={"hydroponicServerTick"}, at=@At(value="INVOKE", target="Lcom/eerussianguy/firmalife/common/blockentities/SprinklerBlockEntity;searchForFluid(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;Z)Lnet/minecraft/world/level/material/Fluid;"), remap=false)
    private static Fluid redirectSearchForFluid(Level level, BlockPos pos, Direction direction, boolean drain, Level unusedLevel, BlockPos unusedPos, BlockState state, HydroponicPlanterBlockEntity planter) {
        Fluid result = HydroponicPlanterBlockEntityMixin.checkGTFluidHandler(level, pos.m_7495_());
        if (result == Fluids.f_76191_) {
            result = SprinklerBlockEntity.searchForFluid((Level)level, (BlockPos)pos, (Direction)direction, (boolean)drain);
        }
        try {
            boolean hasPipe = result == Fluids.f_76193_;
            boolean current = HAS_PIPE_FIELD.getBoolean(planter);
            if (current != hasPipe) {
                HAS_PIPE_FIELD.setBoolean(planter, hasPipe);
                planter.markForSync();
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to update hasPipe state", e);
        }
        return result;
    }

    @Unique
    private static Fluid checkGTFluidHandler(Level level, BlockPos pipePos) {
        BlockEntity be = level.m_7702_(pipePos);
        if (be != null) {
            return be.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP).map(handler -> {
                FluidStack waterStack = new FluidStack((Fluid)Fluids.f_76193_, 1);
                FluidStack drained = handler.drain(waterStack, IFluidHandler.FluidAction.SIMULATE);
                if (!drained.isEmpty() && drained.getAmount() >= 1) {
                    handler.drain(waterStack, IFluidHandler.FluidAction.EXECUTE);
                    return Fluids.f_76193_;
                }
                return Fluids.f_76191_;
            }).orElse(Fluids.f_76191_);
        }
        return Fluids.f_76191_;
    }

    static {
        try {
            HAS_PIPE_FIELD = HydroponicPlanterBlockEntity.class.getDeclaredField("hasPipe");
            HAS_PIPE_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Failed to access hasPipe field", e);
        }
    }
}

