/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common;

import appeng.api.upgrades.Upgrades;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.event.MaterialRegistryEvent;
import com.gregtechceu.gtceu.api.data.chemical.material.event.PostMaterialEvent;
import de.mari_023.ae2wtlib.AE2wtlib;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.common.TFGHelpers;
import su.terrafirmagreg.core.common.TFGInteractionManager;
import su.terrafirmagreg.core.common.data.TFGItems;
import su.terrafirmagreg.core.common.data.capabilities.LargeEggCapability;
import su.terrafirmagreg.core.common.data.capabilities.LargeEggHandler;
import su.terrafirmagreg.core.common.data.tfgt.TFGFissionComponents;
import su.terrafirmagreg.core.compat.gtceu.materials.TFGMaterialHandler;
import su.terrafirmagreg.core.compat.tfcambiental.TFCAmbientalCompat;
import su.terrafirmagreg.core.config.TFGConfig;
import su.terrafirmagreg.core.utils.TFGModsResolver;

public final class TFGCommonEventHandler {
    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus otherBus = MinecraftForge.EVENT_BUS;
        otherBus.addGenericListener(ItemStack.class, TFGCommonEventHandler::attachItemCapabilities);
        bus.addListener(TFGConfig::onLoad);
        bus.addListener(TFGCommonEventHandler::onCommonSetup);
        bus.addListener(TFGCommonEventHandler::onRegisterMaterialRegistry);
        bus.addListener(TFGCommonEventHandler::onPostRegisterMaterials);
        bus.addListener(TFGInteractionManager::init);
    }

    private static void onRegisterMaterialRegistry(MaterialRegistryEvent event) {
        TFGCore.MATERIAL_REGISTRY = GTCEuAPI.materialManager.createRegistry("tfg");
    }

    private static void onPostRegisterMaterials(PostMaterialEvent event) {
        TFGHelpers.isMaterialRegistrationFinished = true;
        TFGMaterialHandler.postInit();
    }

    private static void attachItemCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (!(stack.m_41619_() || stack.m_41720_() != TFGItems.SNIFFER_EGG.get() && stack.m_41720_() != TFGItems.WRAPTOR_EGG.get())) {
            event.addCapability(LargeEggCapability.KEY, (ICapabilityProvider)new LargeEggHandler(stack));
        }
    }

    private static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            if (((Boolean)TFGConfig.COMMON.ENABLE_TFC_AMBIENTAL_COMPAT.get()).booleanValue() && TFGModsResolver.TFC_AMBIENTAL.isLoaded()) {
                TFCAmbientalCompat.register();
            }
            TFGCommonEventHandler.addUpgrades((ItemLike)AEItems.WIRELESS_TERMINAL);
            TFGCommonEventHandler.addUpgrades((ItemLike)AEItems.WIRELESS_CRAFTING_TERMINAL);
            TFGCommonEventHandler.addUpgrades((ItemLike)AE2wtlib.PATTERN_ENCODING_TERMINAL);
            TFGCommonEventHandler.addUpgrades((ItemLike)AE2wtlib.PATTERN_ACCESS_TERMINAL);
            TFGCommonEventHandler.addUpgrades((ItemLike)AE2wtlib.UNIVERSAL_TERMINAL);
        });
        TFGFissionComponents.addComponents();
    }

    private static void addUpgrades(ItemLike item) {
        Upgrades.add((ItemLike)((ItemLike)TFGItems.WIRELESS_CARD.get()), (ItemLike)item, (int)1, (String)GuiText.WirelessTerminals.getTranslationKey());
    }
}

