/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.blocks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.common.data.TFGTags;
import su.terrafirmagreg.core.common.data.blocks.DecorativePlantBlock;

public class DecorativeAttachedPlantBlock
extends DecorativePlantBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private final boolean allowVertical;
    protected static final VoxelShape NORTH_SHAPE = DecorativeAttachedPlantBlock.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = DecorativeAttachedPlantBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape WEST_SHAPE = DecorativeAttachedPlantBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = DecorativeAttachedPlantBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final VoxelShape UP_SHAPE = DecorativeAttachedPlantBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape DOWN_SHAPE = DecorativeAttachedPlantBlock.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final Map<Direction, VoxelShape> SHAPES = ImmutableMap.of((Object)Direction.NORTH, (Object)NORTH_SHAPE, (Object)Direction.SOUTH, (Object)SOUTH_SHAPE, (Object)Direction.WEST, (Object)WEST_SHAPE, (Object)Direction.EAST, (Object)EAST_SHAPE, (Object)Direction.UP, (Object)UP_SHAPE, (Object)Direction.DOWN, (Object)DOWN_SHAPE);

    public DecorativeAttachedPlantBlock(ExtendedProperties properties, boolean allowVertical) {
        super(properties, DecorativePlantBlock.DEFAULT_SHAPE);
        this.allowVertical = allowVertical;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (direction.m_122424_() == state.m_61143_((Property)FACING) && !Helpers.isBlock((BlockState)facingState, TFGTags.Blocks.DecorativePlantAttachable)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (!(this.allowVertical || facing != Direction.DOWN && facing != Direction.UP)) {
            return false;
        }
        BlockState attachedState = level.m_8055_(pos.m_121945_(facing.m_122424_()));
        return Helpers.isBlock((BlockState)attachedState, TFGTags.Blocks.DecorativePlantAttachable);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        if (!(this.allowVertical || direction != Direction.DOWN && direction != Direction.UP)) {
            return null;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }
}

