/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.blocks;

import dev.latvian.mods.kubejs.typings.Info;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;
import su.terrafirmagreg.core.common.data.TFGBlockEntities;
import su.terrafirmagreg.core.common.data.blockentity.TickerBlockEntity;

public class ParticleEmitterDecorationBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final VoxelShape DEFAULT_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private final VoxelShape shape;
    private final Supplier<SimpleParticleType> particleType;
    private final double baseX;
    private final double baseY;
    private final double baseZ;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private final double velocityX;
    private final double velocityY;
    private final double velocityZ;
    private final int particleCount;
    private final boolean particleForced;
    private final boolean useDustOptions;
    private final float red;
    private final float green;
    private final float blue;
    private final float scale;
    private final boolean hasTicker;
    private final int emitDelay;

    public ParticleEmitterDecorationBlock(BlockBehaviour.Properties properties, VoxelShape shape, Supplier<Item> itemSupplier, Supplier<SimpleParticleType> particleType, double baseX, double baseY, double baseZ, double offsetX, double offsetY, double offsetZ, double velocityX, double velocityY, double velocityZ, int particleCount, boolean particleForced, boolean useDustOptions, float red, float green, float blue, float scale, boolean hasTicker, int emitDelay) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.shape = shape != null ? shape : DEFAULT_SHAPE;
        this.particleType = particleType != null ? particleType : () -> ParticleTypes.f_123778_;
        this.baseX = baseX;
        this.baseY = baseY;
        this.baseZ = baseZ;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.velocityX = velocityX;
        this.velocityY = velocityY;
        this.velocityZ = velocityZ;
        this.particleCount = Math.max(1, particleCount);
        this.particleForced = particleForced;
        this.useDustOptions = useDustOptions;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.scale = scale;
        this.hasTicker = hasTicker;
        this.emitDelay = Math.max(0, emitDelay);
    }

    private boolean shouldEmit(RandomSource random) {
        if (this.emitDelay <= 0) {
            return true;
        }
        int inner = 1 + random.m_188503_(this.emitDelay);
        return random.m_188503_(inner) == 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        return level.m_8055_(below).m_60783_((BlockGetter)level, below, Direction.UP);
    }

    @Info(value="Client display tick. Cannot be every tick. Use ticker for adjustable frequency.")
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.hasTicker && level.m_7702_(pos) != null) {
            return;
        }
        if (this.shouldEmit(random)) {
            this.spawnClient(level, pos, random);
        }
    }

    private double randOffset(RandomSource r, double range) {
        if (range <= 0.0) {
            return 0.0;
        }
        return r.m_188500_() * range * (double)(r.m_188499_() ? 1 : -1);
    }

    private void spawnClient(Level level, BlockPos pos, RandomSource random) {
        if (!level.f_46443_) {
            return;
        }
        for (int i = 0; i < this.particleCount; ++i) {
            double x = (double)pos.m_123341_() + this.baseX + this.randOffset(random, this.offsetX);
            double y = (double)pos.m_123342_() + this.baseY + (this.offsetY > 0.0 ? random.m_188500_() * this.offsetY : 0.0);
            double z = (double)pos.m_123343_() + this.baseZ + this.randOffset(random, this.offsetZ);
            this.emitClient(level, x, y, z);
        }
    }

    private void emitClient(Level level, double x, double y, double z) {
        if (this.useDustOptions) {
            DustParticleOptions dust = new DustParticleOptions(new Vector3f(this.red, this.green, this.blue), this.scale);
            if (this.particleForced) {
                level.m_6485_((ParticleOptions)dust, true, x, y, z, this.velocityX, this.velocityY, this.velocityZ);
            } else {
                level.m_7106_((ParticleOptions)dust, x, y, z, this.velocityX, this.velocityY, this.velocityZ);
            }
        } else {
            SimpleParticleType type = this.particleType.get();
            if (this.particleForced) {
                level.m_6485_((ParticleOptions)type, true, x, y, z, this.velocityX, this.velocityY, this.velocityZ);
            } else {
                level.m_7106_((ParticleOptions)type, x, y, z, this.velocityX, this.velocityY, this.velocityZ);
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.hasTicker ? new TickerBlockEntity(pos, state) : null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!this.hasTicker || !level.f_46443_) {
            return null;
        }
        return type == TFGBlockEntities.TICKER_ENTITY.get() ? (lvl, p, s, be) -> {
            if (be instanceof TickerBlockEntity && this.shouldEmit(lvl.f_46441_)) {
                this.spawnClient(lvl, p, lvl.f_46441_);
            }
        } : null;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            Block.m_49902_((BlockState)state, (BlockState)Blocks.f_50016_.m_49966_(), (LevelAccessor)level, (BlockPos)pos, (int)3);
        }
    }
}

