/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.buds;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.common.data.buds.BudIndicatorItem;
import su.terrafirmagreg.core.common.data.buds.BudRenderer;

public class BudIndicator
extends Block
implements IFluidLoggable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final FluidProperty FLUID = TFCBlockStateProperties.ALL_WATER;
    private static final VoxelShape AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    private static final RandomSource RANDOM_SOURCE = RandomSource.m_216327_();
    private final Material material;

    public BudIndicator(BlockBehaviour.Properties properties, Material material) {
        super(properties);
        this.material = material;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.m_235672_((RandomSource)RANDOM_SOURCE))).m_61124_((Property)FLUID, (Comparable)FLUID.keyFor(Fluids.f_76191_)));
        if (GTCEu.isClientSide()) {
            BudRenderer.create(this);
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean m_222958_(BlockState state, BlockGetter view, BlockPos pos) {
        return false;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos attachedBlock = pos.m_121945_(Direction.DOWN);
        return level.m_8055_(attachedBlock).m_60783_((BlockGetter)level, attachedBlock, Direction.UP);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            Block.m_49902_((BlockState)state, (BlockState)Blocks.f_50016_.m_49966_(), (LevelAccessor)level, (BlockPos)pos, (int)3);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.getStateForDirection(context.m_151260_()).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyForOrEmpty(fluid.m_76152_()));
    }

    public BlockState getStateForDirection(Direction direction) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{FLUID});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor tintedBlockColor() {
        return (state, reader, pos, tintIndex) -> {
            Block patt4954$temp = state.m_60734_();
            if (patt4954$temp instanceof BudIndicator) {
                BudIndicator block = (BudIndicator)patt4954$temp;
                if (tintIndex == 0) {
                    return block.material.getMaterialRGB();
                }
                if (tintIndex == 1) {
                    return block.material.getMaterialSecondaryARGB();
                }
            }
            return -1;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor tintedItemColor() {
        return (stack, tintIndex) -> {
            Item patt5393$temp = stack.m_41720_();
            if (patt5393$temp instanceof BudIndicatorItem) {
                BudIndicatorItem item = (BudIndicatorItem)patt5393$temp;
                if (tintIndex == 0) {
                    return item.getMaterial().getMaterialRGB();
                }
                if (tintIndex == 1) {
                    return item.getMaterial().getMaterialSecondaryARGB();
                }
            }
            return -1;
        };
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return ChemicalHelper.get((TagPrefix)TagPrefix.gem, (Material)this.material);
    }

    public String m_7705_() {
        return "block.bud_indicator";
    }

    public MutableComponent m_49954_() {
        return Component.m_237110_((String)"block.bud_indicator", (Object[])new Object[]{this.material.getLocalizedName()});
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        if (fluid instanceof FlowingFluid && !this.getFluidProperty().canContain(fluid)) {
            return true;
        }
        return super.m_6044_(level, pos, state, fluid);
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (fluidStateIn.m_76152_() instanceof FlowingFluid && !this.getFluidProperty().canContain(fluidStateIn.m_76152_())) {
            level.m_46961_(pos, true);
            level.m_7731_(pos, fluidStateIn.m_76188_(), 2);
            return true;
        }
        return super.m_7361_(level, pos, state, fluidStateIn);
    }

    public FluidState m_5888_(BlockState state) {
        return super.getFluidLoggedState(state);
    }

    public FluidProperty getFluidProperty() {
        return FLUID;
    }
}

