/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.entities.moonrabbit;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.prey.TFCRabbit;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.animals.MammalConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;

public class MoonRabbit
extends TFCRabbit {
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(MoonRabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public static MoonRabbit makeMoonRabbit(EntityType<? extends TFCRabbit> type, Level level) {
        return new MoonRabbit(type, level, TFCConfig.SERVER.rabbitConfig);
    }

    public static boolean spawnRules(EntityType<? extends TFCRabbit> type, LevelAccessor level, MobSpawnType spawn, BlockPos pos, RandomSource rand) {
        return level.m_8055_(pos).m_60795_();
    }

    public MoonRabbit(EntityType<? extends Rabbit> type, Level level, MammalConfig config) {
        super(type, level, config);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)MoonVariant.PINK.id);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("MoonRabbitType", this.getMoonVariant().id);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(MoonVariant.byId(tag.m_128451_("MoonRabbitType")));
    }

    public float m_5610_(@NotNull BlockPos pos, LevelReader level) {
        return level.m_8055_(pos).m_204336_(TFCTags.Blocks.PLANTS) ? 10.0f : level.m_220419_(pos);
    }

    public MoonVariant getMoonVariant() {
        return MoonVariant.byId((Integer)this.f_19804_.m_135370_(DATA_TYPE_ID));
    }

    public void setVariant(MoonVariant variant) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)variant.id);
    }

    public void createGenes(@NotNull CompoundTag tag, @NotNull TFCAnimalProperties male) {
        super.createGenes(tag, male);
        tag.m_128359_("variant1", this.getMoonVariant().m_7912_());
        if (male instanceof MoonRabbit) {
            MoonRabbit rabbit = (MoonRabbit)male;
            tag.m_128359_("variant2", this.getMoonVariant().m_7912_());
        }
    }

    public void applyGenes(@NotNull CompoundTag tag, @NotNull MammalProperties baby) {
        super.applyGenes(tag, baby);
        if (baby instanceof MoonRabbit) {
            MoonRabbit rabbit = (MoonRabbit)baby;
            if (tag.m_128425_("variant2", 3) && this.f_19796_.m_188503_(10) != 0) {
                rabbit.setVariant(MoonVariant.byId(this.f_19796_.m_188499_() ? tag.m_128451_("variant1") : tag.m_128451_("variant2")));
            } else {
                Level level = this.m_9236_();
                if (level instanceof ServerLevelAccessor) {
                    ServerLevelAccessor server = (ServerLevelAccessor)level;
                    rabbit.setVariant(this.getRandomRabbitType());
                }
            }
        }
    }

    public MoonRabbit getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob other) {
        TFCRabbit mob = super.getBreedOffspring(level, other);
        if (mob instanceof MoonRabbit) {
            MoonRabbit rabbit = (MoonRabbit)mob;
            rabbit.setVariant(this.getRandomRabbitType());
            return rabbit;
        }
        return null;
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, tag);
        if (reason != MobSpawnType.BREEDING) {
            this.initCommonAnimalData(level, difficulty, reason);
            this.setVariant(this.getRandomRabbitType());
        }
        this.setPregnantTime(-1L);
        return spawnData;
    }

    private MoonVariant getRandomRabbitType() {
        return MoonVariant.byId(this.f_19796_.m_188503_(6));
    }

    public static enum MoonVariant implements StringRepresentable
    {
        PINK(0, "pink"),
        WHITE(1, "white"),
        GREY(2, "grey"),
        CYAN(3, "cyan"),
        PURPLE(4, "purple"),
        SOFU(5, "sofu");

        private static final IntFunction<MoonVariant> BY_ID;
        public static final Codec<MoonVariant> CODEC;
        final int id;
        private final String name;

        private MoonVariant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public int id() {
            return this.id;
        }

        public static MoonVariant byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = ByIdMap.m_262845_(MoonVariant::id, (Object[])MoonVariant.values(), (Object)((Object)PINK));
            CODEC = StringRepresentable.m_216439_(MoonVariant::values);
        }
    }
}

