/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class WeakOreProspectorEventHelper {
    private final double length;
    private final double halfWidth;
    private final double halfHeight;
    private final TagKey<Item> itemTag;
    private final TagKey<Block> oreTag = Tags.Blocks.ORES;

    public WeakOreProspectorEventHelper(double length, double halfWidth, double halfHeight, TagKey<Item> itemTag) {
        this.length = length;
        this.halfWidth = halfWidth;
        this.halfHeight = halfHeight;
        this.itemTag = itemTag;
    }

    public void handleRightClick(PlayerInteractEvent event) {
        Vec3 up;
        Player player = event.getEntity();
        Level level = player.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        ItemStack held = player.m_21120_(event.getHand());
        if (!held.m_204117_(this.itemTag)) {
            return;
        }
        if (player.m_36335_().m_41519_(held.m_41720_())) {
            return;
        }
        Vec3 eyePos = player.m_146892_();
        Vec3 lookDir = player.m_20154_().m_82541_();
        Vec3 right = lookDir.m_82537_(up = new Vec3(0.0, 1.0, 0.0)).m_82541_();
        if (right.m_82556_() == 0.0) {
            right = new Vec3(1.0, 0.0, 0.0);
        }
        up = right.m_82537_(lookDir).m_82541_();
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        HashMap<Object, Integer> oreCounts = new HashMap<Object, Integer>();
        ArrayList<BlockPos> orePositions = new ArrayList<BlockPos>();
        int stepsX = (int)Math.ceil(this.halfWidth) * 2;
        int stepsY = (int)Math.ceil(this.halfHeight) * 2;
        int stepsZ = (int)Math.ceil(this.length);
        for (int ix = -stepsX / 2; ix <= stepsX / 2; ++ix) {
            for (int iy = -stepsY / 2; iy <= stepsY / 2; ++iy) {
                for (int iz = 0; iz <= stepsZ; ++iz) {
                    Block block;
                    Vec3 localPos = right.m_82490_((double)ix + 0.5).m_82549_(up.m_82490_((double)iy + 0.5)).m_82549_(lookDir.m_82490_((double)iz + 0.5));
                    Vec3 worldPos = eyePos.m_82549_(localPos);
                    BlockPos pos = BlockPos.m_274446_((Position)worldPos);
                    if (!checkedPositions.add(pos) || !(block = level.m_8055_(pos).m_60734_()).m_49966_().m_204336_(this.oreTag)) continue;
                    MutableComponent name2 = block.m_49954_();
                    oreCounts.put(name2, oreCounts.getOrDefault(name2, 0) + 1);
                    orePositions.add(pos);
                }
            }
        }
        if (oreCounts.isEmpty()) {
            player.m_213846_((Component)Component.m_237115_((String)"tfg.toast.ore_prospector_none").m_130940_(ChatFormatting.GRAY));
        } else {
            player.m_213846_((Component)Component.m_237110_((String)"tfg.toast.ore_prospector_message", (Object[])new Object[]{this.length, "??"}).m_130940_(ChatFormatting.GOLD));
            oreCounts.forEach((name, oreCount) -> player.m_213846_((Component)Component.m_237113_((String)"- ").m_7220_(name).m_130940_(ChatFormatting.AQUA)));
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            player.m_21011_(event.getHand(), true);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12515_, SoundSource.PLAYERS, 2.0f, 0.1f);
            held.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(event.getHand()));
            player.m_36335_().m_41524_(held.m_41720_(), 40);
        }
        event.setCanceled(true);
    }

    @Generated
    public double getLength() {
        return this.length;
    }

    @Generated
    public double getHalfWidth() {
        return this.halfWidth;
    }

    @Generated
    public double getHalfHeight() {
        return this.halfHeight;
    }

    @Generated
    public TagKey<Item> getItemTag() {
        return this.itemTag;
    }

    @Generated
    public TagKey<Block> getOreTag() {
        return this.oreTag;
    }
}

