/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.tfgt;

import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.machine.owner.FTBOwner;
import com.gregtechceu.gtceu.common.machine.owner.MachineOwner;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.common.data.tfgt.machine.multiblock.part.RailgunItemBusMachine;

public class InterplanetaryLogisticsNetwork {
    public static final Map<String, Integer> DIMENSION_DISTANCES = new HashMap<String, Integer>();
    private static InterplanetaryLogisticsNetwork NETWORK;
    private final Map<DimensionalBlockPos, ILogisticsNetworkMachine> loadedMachines = new HashMap<DimensionalBlockPos, ILogisticsNetworkMachine>();
    private final InterplanetaryLogisticsNetworkSavedData data;

    public static InterplanetaryLogisticsNetwork get(IMachineBlockEntity entity) {
        if (NETWORK == null) {
            NETWORK = new InterplanetaryLogisticsNetwork(Objects.requireNonNull(entity.level().m_7654_()).m_129783_());
        }
        return NETWORK;
    }

    private InterplanetaryLogisticsNetwork(ServerLevel lvl) {
        this.data = InterplanetaryLogisticsNetworkSavedData.get(lvl);
    }

    public void loadOrCreatePart(ILogisticsNetworkMachine machine) {
        boolean isReceiver = machine instanceof ILogisticsNetworkReceiver;
        MachineOwner owner = machine.getMachine().getOwner();
        if (owner instanceof FTBOwner) {
            FTBOwner ftbOwner = (FTBOwner)owner;
            this.loadedMachines.put(machine.getDimensionalPos(), machine);
            this.data.parts.computeIfAbsent(machine.getDimensionalPos(), k -> {
                this.data.m_77762_();
                return new NetworkPart((DimensionalBlockPos)k, ftbOwner.getTeam().getTeamId(), isReceiver);
            });
            return;
        }
        TFGCore.LOGGER.warn("Interplanetary logistics machine does not have a valid FTB owner. {} {}", (Object)machine.getDimensionalPos(), (Object)machine.getMachine());
    }

    public void unloadPart(ILogisticsNetworkMachine machine) {
        this.loadedMachines.remove(machine.getDimensionalPos());
    }

    public void destroyPart(ILogisticsNetworkMachine machine) {
        this.loadedMachines.remove(machine.getDimensionalPos());
        this.data.parts.remove(machine.getDimensionalPos());
        this.data.m_77762_();
    }

    public List<NetworkPart> getPartsVisibleToPlayer(Player player) {
        UUID id = player.m_20148_();
        ArrayList parts = new ArrayList();
        this.data.parts.forEach((k, v) -> {
            Optional team = FTBTeamsAPI.api().getManager().getTeamByID(v.getOwnerId());
            if (team.isPresent() && ((Team)team.get()).getRankForPlayer(id).isAllyOrBetter()) {
                parts.add(v);
            }
        });
        return Collections.unmodifiableList(parts);
    }

    @Nullable
    public NetworkPart getPart(DimensionalBlockPos partId) {
        return this.data.parts.get(partId);
    }

    @Nullable
    public ILogisticsNetworkMachine getNetworkMachine(DimensionalBlockPos partId) {
        return this.loadedMachines.get(partId);
    }

    public void markDirty() {
        this.data.m_77762_();
    }

    static {
        DIMENSION_DISTANCES.put("minecraft:overworld", 0);
        DIMENSION_DISTANCES.put("ad_astra:earth_orbit", 0);
        DIMENSION_DISTANCES.put("ad_astra:moon", 60);
        DIMENSION_DISTANCES.put("ad_astra:moon_orbit", 60);
        DIMENSION_DISTANCES.put("ad_astra:mars", 120);
        DIMENSION_DISTANCES.put("ad_astra:mars_orbit", 120);
        NETWORK = null;
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class InterplanetaryLogisticsNetworkSavedData
    extends SavedData {
        private static final String DATA_ID = "tfg_interdim_logistics";
        public final Map<DimensionalBlockPos, NetworkPart> parts = new HashMap<DimensionalBlockPos, NetworkPart>();

        public static InterplanetaryLogisticsNetworkSavedData get(ServerLevel level) {
            return (InterplanetaryLogisticsNetworkSavedData)level.m_8895_().m_164861_(InterplanetaryLogisticsNetworkSavedData::new, InterplanetaryLogisticsNetworkSavedData::new, DATA_ID);
        }

        private InterplanetaryLogisticsNetworkSavedData() {
        }

        private InterplanetaryLogisticsNetworkSavedData(CompoundTag tag) {
            ListTag partsTag = tag.m_128437_("networkParts", 10);
            partsTag.forEach(t -> {
                NetworkPart part = new NetworkPart((CompoundTag)t);
                this.parts.put(part.partId, part);
            });
        }

        public CompoundTag m_7176_(CompoundTag pCompoundTag) {
            ListTag partsTag = new ListTag();
            for (NetworkPart part : this.parts.values()) {
                partsTag.add((Object)part.save());
            }
            pCompoundTag.m_128365_("networkParts", (Tag)partsTag);
            return pCompoundTag;
        }
    }

    public static interface ILogisticsNetworkReceiver
    extends ILogisticsNetworkMachine {
        public boolean canAcceptItems(int var1, List<ItemStack> var2);

        public void onPackageSent(int var1, List<ItemStack> var2, int var3);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ILogisticsNetworkMachine {
        default public DimensionalBlockPos getDimensionalPos() {
            return new DimensionalBlockPos(this.getMachine());
        }

        default public InterplanetaryLogisticsNetwork getLogisticsNetwork() {
            return InterplanetaryLogisticsNetwork.get(this.getMachine().getHolder());
        }

        public MetaMachine getMachine();

        public boolean isMachineInvalid();

        public List<RailgunItemBusMachine> getInventories();

        public Component getCurrentStatusText();
    }

    public record DimensionalBlockPos(String dimension, BlockPos pos) {
        public DimensionalBlockPos(MetaMachine machine) {
            this(Objects.requireNonNull(machine.getLevel()).m_46472_().m_135782_().toString(), machine.getPos());
        }

        public DimensionalBlockPos(CompoundTag tag) {
            this(tag.m_128461_("dim"), new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z")));
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("dim", this.dimension);
            tag.m_128405_("x", this.pos.m_123341_());
            tag.m_128405_("y", this.pos.m_123342_());
            tag.m_128405_("z", this.pos.m_123343_());
            return tag;
        }

        public String getUiString() {
            return "%s (%s, %s, %s)".formatted(this.dimension, this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_());
        }
    }

    public static class NetworkPart {
        private final DimensionalBlockPos partId;
        private String uiLabel;
        private final boolean isReceiverPart;
        public final List<NetworkSenderConfigEntry> senderLogisticsConfigs;
        public final List<NetworkReceiverConfigEntry> receiverLogisticsConfigs;
        private final UUID ownerId;

        public NetworkPart(DimensionalBlockPos pos, UUID owner, boolean rec) {
            this.partId = pos;
            this.uiLabel = "[unnamed]";
            this.ownerId = owner;
            this.isReceiverPart = rec;
            this.senderLogisticsConfigs = new ArrayList<NetworkSenderConfigEntry>();
            this.receiverLogisticsConfigs = new ArrayList<NetworkReceiverConfigEntry>();
            if (this.isReceiverPart) {
                for (int i = 0; i < 33; ++i) {
                    this.receiverLogisticsConfigs.add(new NetworkReceiverConfigEntry(i));
                }
            }
        }

        public NetworkPart(CompoundTag tag) {
            this.partId = new DimensionalBlockPos(tag.m_128469_("partId"));
            this.uiLabel = tag.m_128461_("uiLabel");
            this.ownerId = tag.m_128342_("ftbOwner");
            this.isReceiverPart = tag.m_128471_("isReceiverPart");
            this.senderLogisticsConfigs = new ArrayList<NetworkSenderConfigEntry>();
            this.receiverLogisticsConfigs = new ArrayList<NetworkReceiverConfigEntry>();
            if (this.isReceiverPart) {
                tag.m_128437_("receiverLogisticsConfigs", 10).forEach(t -> this.receiverLogisticsConfigs.add(new NetworkReceiverConfigEntry((CompoundTag)t)));
            } else {
                tag.m_128437_("senderLogisticsConfigs", 10).forEach(t -> this.senderLogisticsConfigs.add(new NetworkSenderConfigEntry((CompoundTag)t)));
            }
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("partId", (Tag)this.partId.save());
            tag.m_128359_("uiLabel", this.uiLabel);
            tag.m_128362_("ftbOwner", this.ownerId);
            tag.m_128379_("isReceiverPart", this.isReceiverPart);
            ListTag sendConfigs = new ListTag();
            ListTag receiveConfigs = new ListTag();
            if (this.isReceiverPart) {
                this.receiverLogisticsConfigs.forEach(c -> receiveConfigs.add((Object)c.save()));
            } else {
                this.senderLogisticsConfigs.forEach(c -> {
                    if (c.receiverPartID != null) {
                        sendConfigs.add((Object)c.save());
                    }
                });
            }
            tag.m_128365_("senderLogisticsConfigs", (Tag)sendConfigs);
            tag.m_128365_("receiverLogisticsConfigs", (Tag)receiveConfigs);
            return tag;
        }

        @Generated
        public DimensionalBlockPos getPartId() {
            return this.partId;
        }

        @Generated
        public String getUiLabel() {
            return this.uiLabel;
        }

        @Generated
        public void setUiLabel(String uiLabel) {
            this.uiLabel = uiLabel;
        }

        @Generated
        public boolean isReceiverPart() {
            return this.isReceiverPart;
        }

        @Generated
        public UUID getOwnerId() {
            return this.ownerId;
        }
    }

    public static class NetworkSenderConfigEntry {
        private final DimensionalBlockPos senderPartID;
        private DimensionalBlockPos receiverPartID;
        private int senderDistinctInventory = 0;
        private int receiverDistinctInventory = 0;
        private TriggerMode currentSendTrigger = TriggerMode.ITEM;
        private int currentInactivityTimeout = 0;
        private CustomItemStackHandler currentSendFilter = new CustomItemStackHandler(3);

        public NetworkSenderConfigEntry(DimensionalBlockPos sender) {
            this.senderPartID = sender;
        }

        public NetworkSenderConfigEntry(CompoundTag tag) {
            this.senderPartID = new DimensionalBlockPos(tag.m_128469_("senderPartID"));
            this.receiverPartID = new DimensionalBlockPos(tag.m_128469_("receiverPartID"));
            this.senderDistinctInventory = tag.m_128451_("senderDistinctInventory");
            this.receiverDistinctInventory = tag.m_128451_("receiverDistinctInventory");
            this.currentSendTrigger = TriggerMode.values()[tag.m_128451_("currentSendTrigger")];
            this.currentSendFilter = new CustomItemStackHandler(3);
            this.currentSendFilter.deserializeNBT(tag.m_128469_("currentSendFilter"));
            this.currentInactivityTimeout = tag.m_128451_("currentInactivityTimeout");
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("senderPartID", (Tag)this.senderPartID.save());
            tag.m_128365_("receiverPartID", (Tag)this.receiverPartID.save());
            tag.m_128365_("currentSendFilter", (Tag)this.currentSendFilter.serializeNBT());
            tag.m_128405_("currentInactivityTimeout", this.currentInactivityTimeout);
            tag.m_128405_("senderDistinctInventory", this.senderDistinctInventory);
            tag.m_128405_("receiverDistinctInventory", this.receiverDistinctInventory);
            tag.m_128405_("currentSendTrigger", this.currentSendTrigger.ordinal());
            return tag;
        }

        @Generated
        public DimensionalBlockPos getSenderPartID() {
            return this.senderPartID;
        }

        @Generated
        public DimensionalBlockPos getReceiverPartID() {
            return this.receiverPartID;
        }

        @Generated
        public void setReceiverPartID(DimensionalBlockPos receiverPartID) {
            this.receiverPartID = receiverPartID;
        }

        @Generated
        public int getSenderDistinctInventory() {
            return this.senderDistinctInventory;
        }

        @Generated
        public void setSenderDistinctInventory(int senderDistinctInventory) {
            this.senderDistinctInventory = senderDistinctInventory;
        }

        @Generated
        public int getReceiverDistinctInventory() {
            return this.receiverDistinctInventory;
        }

        @Generated
        public void setReceiverDistinctInventory(int receiverDistinctInventory) {
            this.receiverDistinctInventory = receiverDistinctInventory;
        }

        @Generated
        public TriggerMode getCurrentSendTrigger() {
            return this.currentSendTrigger;
        }

        @Generated
        public void setCurrentSendTrigger(TriggerMode currentSendTrigger) {
            this.currentSendTrigger = currentSendTrigger;
        }

        @Generated
        public int getCurrentInactivityTimeout() {
            return this.currentInactivityTimeout;
        }

        @Generated
        public void setCurrentInactivityTimeout(int currentInactivityTimeout) {
            this.currentInactivityTimeout = currentInactivityTimeout;
        }

        @Generated
        public CustomItemStackHandler getCurrentSendFilter() {
            return this.currentSendFilter;
        }

        public static enum TriggerMode implements EnumSelectorWidget.SelectableEnum
        {
            ITEM("Item", "transfer_any"),
            REDSTONE_SIGNAL("Redstone signal", "transfer_any"),
            INACTIVITY("Inactivity (seconds)", "transfer_any");

            public final String tooltip;
            public final IGuiTexture icon;

            private TriggerMode(String tooltip, String textureName) {
                this.tooltip = tooltip;
                this.icon = new ResourceTexture("gtceu:textures/gui/icon/transfer_mode/" + textureName + ".png");
            }

            @Generated
            public String getTooltip() {
                return this.tooltip;
            }

            @Generated
            public IGuiTexture getIcon() {
                return this.icon;
            }
        }
    }

    public static class NetworkReceiverConfigEntry {
        private int distinctInventory;
        private LogicMode currentMode;
        private int currentCooldown;

        public NetworkReceiverConfigEntry(int inv) {
            this.distinctInventory = inv;
            this.currentCooldown = 0;
            this.currentMode = LogicMode.COOLDOWN;
        }

        public NetworkReceiverConfigEntry(CompoundTag tag) {
            this.distinctInventory = tag.m_128451_("circuit");
            this.currentMode = LogicMode.values()[tag.m_128451_("currentMode")];
            this.currentCooldown = tag.m_128451_("currentCooldown");
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("circuit", this.distinctInventory);
            tag.m_128405_("currentMode", this.currentMode.ordinal());
            tag.m_128405_("currentCooldown", this.currentCooldown);
            return tag;
        }

        @Generated
        public int getDistinctInventory() {
            return this.distinctInventory;
        }

        @Generated
        public void setDistinctInventory(int distinctInventory) {
            this.distinctInventory = distinctInventory;
        }

        @Generated
        public LogicMode getCurrentMode() {
            return this.currentMode;
        }

        @Generated
        public void setCurrentMode(LogicMode currentMode) {
            this.currentMode = currentMode;
        }

        @Generated
        public int getCurrentCooldown() {
            return this.currentCooldown;
        }

        @Generated
        public void setCurrentCooldown(int currentCooldown) {
            this.currentCooldown = currentCooldown;
        }

        public static enum LogicMode implements EnumSelectorWidget.SelectableEnum
        {
            COOLDOWN("Cooldown after receiving (seconds)", "transfer_any"),
            REDSTONE_ENABLE("Enable when receiving redstone signal", "transfer_any"),
            REDSTONE_DISABLE("Disable when receiving redstone signal", "transfer_any");

            public final String tooltip;
            public final IGuiTexture icon;

            private LogicMode(String tooltip, String textureName) {
                this.tooltip = tooltip;
                this.icon = new ResourceTexture("gtceu:textures/gui/icon/transfer_mode/" + textureName + ".png");
            }

            @Generated
            public String getTooltip() {
                return this.tooltip;
            }

            @Generated
            public IGuiTexture getIcon() {
                return this.icon;
            }
        }
    }

    public static interface ILogisticsNetworkSender
    extends ILogisticsNetworkMachine {
        default public List<NetworkSenderConfigEntry> getSendConfigurations() {
            return Collections.unmodifiableList(Objects.requireNonNull(this.getLogisticsNetwork().getPart((DimensionalBlockPos)this.getDimensionalPos())).senderLogisticsConfigs);
        }
    }
}

