/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.tfgt.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.editor.EditableUI;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import su.terrafirmagreg.core.common.data.TFGFoodTraits;

public class FoodRefrigeratorMachine
extends TieredEnergyMachine
implements IControllable,
IFancyUIMachine,
IMachineLife {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FoodRefrigeratorMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private boolean currentlyWorking;
    @Persisted
    private final RefrigeratedStorage inventory;
    private final int inventorySize;
    protected ISubscription energySubscription;
    protected TickableSubscription tickSubscription;
    @Persisted
    private boolean unifyDatesEnabled = true;
    @Persisted
    private boolean workingEnabled;

    public static int INVENTORY_SIZE(int tier) {
        return 9 * (tier + (tier + 1) / 2);
    }

    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public boolean isActivelyRefrigerating() {
        return this.currentlyWorking;
    }

    public FoodRefrigeratorMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier, args);
        this.inventorySize = FoodRefrigeratorMachine.INVENTORY_SIZE(tier);
        this.inventory = new RefrigeratedStorage((MetaMachine)this, this.inventorySize);
        this.currentlyWorking = false;
    }

    @NotNull
    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        return new NotifiableEnergyContainer((MetaMachine)this, GTValues.V[this.tier] * 64L, GTValues.V[this.tier], 2L, 0L, 0L);
    }

    public void onLoad() {
        super.onLoad();
        if (this.isRemote()) {
            return;
        }
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateSubscription));
        }
        this.energySubscription = this.energyContainer.addChangedListener(this::updateSubscription);
    }

    public void onUnload() {
        super.onUnload();
        if (this.energySubscription != null) {
            this.energySubscription.unsubscribe();
            this.energySubscription = null;
        }
        if (this.tickSubscription != null) {
            this.tickSubscription.unsubscribe();
            this.tickSubscription = null;
        }
    }

    public void onMachineRemoved() {
        Level level;
        if (!this.isRemote() && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = this.getPos();
            for (ItemStack drop : this.inventory.drainAllForDrop()) {
                if (drop.m_41619_()) continue;
                Containers.m_18992_((Level)serverLevel, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)drop);
            }
        }
    }

    public void updateSubscription() {
        boolean canWork;
        if (this.isRemote()) {
            return;
        }
        boolean bl = canWork = this.workingEnabled && this.consumeEnergy(true);
        if (canWork && !this.inventory.isEmpty()) {
            if (!this.currentlyWorking) {
                this.inventory.changeTraitForAll(true);
                this.currentlyWorking = true;
                this.inventory.maintainNow();
                this.markDirty();
            }
            this.tickSubscription = this.subscribeServerTick(this.tickSubscription, this::tick);
        } else {
            if (this.currentlyWorking) {
                this.inventory.changeTraitForAll(false);
                this.currentlyWorking = false;
                this.markDirty();
            }
            if (this.tickSubscription != null) {
                this.tickSubscription.unsubscribe();
                this.tickSubscription = null;
            }
        }
    }

    public void tick() {
        if (this.workingEnabled && !this.inventory.isEmpty()) {
            this.consumeEnergy(false);
        }
        this.updateSubscription();
    }

    private long getEnergyAmount() {
        return (long)GTValues.VA[1] * (long)(this.inventorySize / 9);
    }

    private boolean consumeEnergy(boolean simulate) {
        long amount = this.energyContainer.getEnergyStored() - this.getEnergyAmount();
        if (amount < 0L || amount > this.energyContainer.getEnergyCapacity()) {
            return false;
        }
        if (!simulate) {
            this.energyContainer.removeEnergy(this.getEnergyAmount());
        }
        return true;
    }

    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (this.workingEnabled == isWorkingAllowed) {
            return;
        }
        this.workingEnabled = isWorkingAllowed;
        this.markDirty();
        if (!this.isRemote()) {
            this.updateSubscription();
        }
    }

    public void setUnifyDatesEnabled(boolean enabled) {
        if (this.unifyDatesEnabled == enabled) {
            return;
        }
        this.unifyDatesEnabled = enabled;
        if (!this.isRemote() && enabled && this.currentlyWorking) {
            this.inventory.maintainNow();
        }
        this.updateSubscription();
    }

    public Widget createUIWidget() {
        int perRow = 9;
        int slots = this.inventory.getSlots();
        int perCol = Math.max(1, (slots + perRow - 1) / perRow);
        WidgetGroup template = new WidgetGroup(0, 0, 18 * perRow + 8, 18 * perCol + 8);
        template.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        for (int i = 0; i < slots; ++i) {
            int x = i % perRow;
            int y = i / perRow;
            template.addWidget((Widget)new SlotWidget((IItemHandlerModifiable)this.inventory, i, 4 + x * 18, 4 + y * 18, true, true));
        }
        EditableUI editableUI = FoodRefrigeratorMachine.createEnergyBar();
        ProgressWidget energyBar = (ProgressWidget)editableUI.createDefault();
        int energyBarX = 3;
        int toggleY = 2;
        int toggleH = 18;
        int energyBarY = toggleY + toggleH + 4;
        int gridHeight = template.getSize().height;
        int energyBarHeight = Math.max(0, gridHeight - 20);
        energyBar.setSize(energyBar.getSize().width, energyBarHeight);
        int groupWidth = Math.max(energyBar.getSize().width + template.getSize().width + 4 + 8, 172);
        int groupHeight = Math.max(template.getSize().height + 8, energyBarY + energyBar.getSize().height + 8);
        WidgetGroup group = new WidgetGroup(0, 0, groupWidth, groupHeight);
        energyBar.setSelfPosition(new Position(energyBarX, energyBarY));
        Size size = group.getSize();
        int templateX = (size.width - energyBar.getSize().width - 4 - template.getSize().width) / 2 + 2 + energyBar.getSize().width + 2;
        int templateY = (size.height - template.getSize().height) / 2;
        template.setSelfPosition(new Position(templateX, templateY));
        group.addWidget((Widget)energyBar);
        group.addWidget((Widget)template);
        ResourceTexture overlayOn = new ResourceTexture("tfg:textures/gui/widgets/unify_dates_on.png");
        ResourceTexture overlayOff = new ResourceTexture("tfg:textures/gui/widgets/unify_dates_off.png");
        ToggleButtonWidget toggle = new ToggleButtonWidget(3, 2, 18, 18, this::isUnifyDatesEnabled, this::setUnifyDatesEnabled, (IGuiTexture)overlayOff, (IGuiTexture)overlayOn){
            final /* synthetic */ IGuiTexture val$overlayOff;
            final /* synthetic */ IGuiTexture val$overlayOn;
            {
                this.val$overlayOff = iGuiTexture;
                this.val$overlayOn = iGuiTexture2;
                super(xPosition, yPosition, width, height, isPressedCondition, setPressedExecutor);
                ResourceTexture backDisabled = GuiTextures.TOGGLE_BUTTON_BACK.getSubTexture(0.0, 0.0, 1.0, 0.5);
                ResourceTexture backEnabled = GuiTextures.TOGGLE_BUTTON_BACK.getSubTexture(0.0, 0.5, 1.0, 0.5);
                this.setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{backDisabled, this.val$overlayOff}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{backEnabled, this.val$overlayOn}));
                this.refreshTooltip();
            }

            private void refreshTooltip() {
                String base = "tfg.gui.refrigerator.unify_dates";
                this.setTooltipText(Component.m_237115_((String)base).getString());
            }

            public void drawInForeground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                this.refreshTooltip();
                super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
            }
        };
        group.addWidget((Widget)toggle);
        editableUI.setupUI(group, (Object)this);
        return group;
    }

    @Generated
    public boolean isUnifyDatesEnabled() {
        return this.unifyDatesEnabled;
    }

    public class RefrigeratedStorage
    extends NotifiableItemStackHandler {
        private boolean internalEdit;
        private boolean maintenancePending;
        private boolean maintenanceScheduled;

        public RefrigeratedStorage(MetaMachine machine, int slots) {
            super(machine, slots, IO.IN, IO.IN);
            this.internalEdit = false;
            this.maintenancePending = false;
            this.maintenanceScheduled = false;
        }

        private void setNotifying(int slot, ItemStack stack) {
            this.internalEdit = true;
            try {
                RefrigeratedStorage.super.setStackInSlot(slot, stack);
            }
            finally {
                this.internalEdit = false;
            }
        }

        private void scheduleMaintenance() {
            if (FoodRefrigeratorMachine.this.isRemote()) {
                return;
            }
            this.maintenancePending = true;
            if (this.maintenanceScheduled) {
                return;
            }
            this.maintenanceScheduled = true;
            Level level = FoodRefrigeratorMachine.this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::runMaintenanceIfPending));
            }
        }

        public void maintainNow() {
            if (FoodRefrigeratorMachine.this.isRemote()) {
                return;
            }
            this.maintenancePending = true;
            this.runMaintenanceIfPending();
        }

        private void runMaintenanceIfPending() {
            if (!this.maintenancePending) {
                return;
            }
            this.maintenancePending = false;
            this.maintenanceScheduled = false;
            this.internalEdit = true;
            try {
                if (FoodRefrigeratorMachine.this.currentlyWorking) {
                    this.unifyFoodDates();
                    this.combineStacks();
                }
                this.compactInventory();
                this.onContentsChanged();
            }
            finally {
                this.internalEdit = false;
            }
            FoodRefrigeratorMachine.this.updateSubscription();
        }

        public void changeTraitForAll(boolean add) {
            for (int i = 0; i < this.storage.getSlots(); ++i) {
                ItemStack stack = this.storage.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemStack copy = stack.m_41777_();
                if (add) {
                    FoodCapability.applyTrait((ItemStack)copy, (FoodTrait)TFGFoodTraits.REFRIGERATING);
                } else {
                    FoodCapability.removeTrait((ItemStack)copy, (FoodTrait)TFGFoodTraits.REFRIGERATING);
                }
                this.setNotifying(i, copy);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            IFood food = FoodCapability.get((ItemStack)stack);
            return food != null && !food.isRotten();
        }

        private void unifyFoodDates() {
            if (FoodRefrigeratorMachine.this.isRemote()) {
                return;
            }
            if (!FoodRefrigeratorMachine.this.currentlyWorking) {
                return;
            }
            if (!FoodRefrigeratorMachine.this.unifyDatesEnabled) {
                return;
            }
            int slots = this.storage.getSlots();
            boolean[] processed = new boolean[slots];
            for (int i = 0; i < slots; ++i) {
                int k;
                IFood baseFood;
                if (processed[i]) continue;
                ItemStack base = this.storage.getStackInSlot(i);
                IFood iFood = baseFood = base.m_41619_() ? null : FoodCapability.get((ItemStack)base);
                if (base.m_41619_() || baseFood == null || baseFood.isRotten()) {
                    processed[i] = true;
                    continue;
                }
                int[] group = new int[slots];
                int gSize = 0;
                boolean hasNonFull = false;
                long minDate = Long.MAX_VALUE;
                for (int j = i; j < slots; ++j) {
                    IFood otherFood;
                    if (processed[j]) continue;
                    ItemStack other = this.storage.getStackInSlot(j);
                    IFood iFood2 = otherFood = other.m_41619_() ? null : FoodCapability.get((ItemStack)other);
                    if (other.m_41619_() || otherFood == null || otherFood.isRotten() || !FoodCapability.areStacksStackableExceptCreationDate((ItemStack)other, (ItemStack)base)) continue;
                    group[gSize++] = j;
                    if (other.m_41613_() >= other.m_41741_()) continue;
                    hasNonFull = true;
                    long date = otherFood.getCreationDate();
                    if (date >= minDate) continue;
                    minDate = date;
                }
                if (!hasNonFull || minDate == Long.MAX_VALUE) {
                    for (k = 0; k < gSize; ++k) {
                        processed[group[k]] = true;
                    }
                    continue;
                }
                for (k = 0; k < gSize; ++k) {
                    int idx = group[k];
                    ItemStack st = this.storage.getStackInSlot(idx);
                    if (st.m_41619_()) {
                        processed[idx] = true;
                        continue;
                    }
                    if (st.m_41613_() < st.m_41741_()) {
                        ItemStack copy = st.m_41777_();
                        IFood food = FoodCapability.get((ItemStack)copy);
                        if (food != null) {
                            food.setCreationDate(minDate);
                        }
                        this.setNotifying(idx, copy);
                    }
                    processed[idx] = true;
                }
            }
        }

        private void combineStacks() {
            if (FoodRefrigeratorMachine.this.isRemote()) {
                return;
            }
            if (!FoodRefrigeratorMachine.this.currentlyWorking) {
                return;
            }
            int slots = this.storage.getSlots();
            boolean[] processed = new boolean[slots];
            for (int i = 0; i < slots; ++i) {
                int k;
                int k2;
                IFood baseFood;
                if (processed[i]) continue;
                ItemStack base = this.storage.getStackInSlot(i);
                IFood iFood = baseFood = base.m_41619_() ? null : FoodCapability.get((ItemStack)base);
                if (base.m_41619_() || baseFood == null || baseFood.isRotten()) {
                    processed[i] = true;
                    continue;
                }
                int[] group = new int[slots];
                int gSize = 0;
                for (int j = i; j < slots; ++j) {
                    IFood otherFood;
                    if (processed[j]) continue;
                    ItemStack other = this.storage.getStackInSlot(j);
                    IFood iFood2 = otherFood = other.m_41619_() ? null : FoodCapability.get((ItemStack)other);
                    if (other.m_41619_() || otherFood == null || otherFood.isRotten() || !FoodCapability.areStacksStackableExceptCreationDate((ItemStack)other, (ItemStack)base) || !FoodRefrigeratorMachine.this.unifyDatesEnabled && otherFood.getCreationDate() != baseFood.getCreationDate()) continue;
                    group[gSize++] = j;
                }
                int total = 0;
                int maxSize = 0;
                ItemStack template = ItemStack.f_41583_;
                for (k2 = 0; k2 < gSize; ++k2) {
                    ItemStack st = this.storage.getStackInSlot(group[k2]);
                    if (st.m_41619_() || st.m_41613_() >= st.m_41741_()) continue;
                    total += st.m_41613_();
                    maxSize = st.m_41741_();
                    if (!template.m_41619_()) continue;
                    template = st.m_41777_();
                }
                if (template.m_41619_() || total <= 1) {
                    for (k2 = 0; k2 < gSize; ++k2) {
                        processed[group[k2]] = true;
                    }
                    continue;
                }
                int remaining = total;
                for (k = 0; k < gSize; ++k) {
                    int idx = group[k];
                    ItemStack st = this.storage.getStackInSlot(idx);
                    if (st.m_41619_() || st.m_41613_() == st.m_41741_()) continue;
                    if (remaining <= 0) {
                        this.setNotifying(idx, ItemStack.f_41583_);
                        continue;
                    }
                    int put = Math.min(maxSize, remaining);
                    ItemStack filled = template.m_41777_();
                    filled.m_41764_(put);
                    this.setNotifying(idx, filled);
                    remaining -= put;
                }
                for (k = 0; k < gSize; ++k) {
                    processed[group[k]] = true;
                }
            }
        }

        private void compactInventory() {
            if (FoodRefrigeratorMachine.this.isRemote()) {
                return;
            }
            int slots = this.storage.getSlots();
            int nextFree = 0;
            for (int i = 0; i < slots; ++i) {
                ItemStack cur = this.storage.getStackInSlot(i);
                if (cur.m_41619_()) continue;
                if (i != nextFree) {
                    this.setNotifying(nextFree, cur.m_41777_());
                    this.setNotifying(i, ItemStack.f_41583_);
                }
                ++nextFree;
            }
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            IFood incoming = FoodCapability.get((ItemStack)stack);
            if (incoming == null || incoming.isRotten()) {
                return stack;
            }
            ItemStack toInsert = stack.m_41777_();
            if (FoodRefrigeratorMachine.this.currentlyWorking) {
                FoodCapability.applyTrait((ItemStack)toInsert, (FoodTrait)TFGFoodTraits.REFRIGERATING);
            }
            ItemStack result = this.storage.insertItem(slot, toInsert, simulate);
            if (FoodRefrigeratorMachine.this.currentlyWorking) {
                FoodCapability.removeTrait((ItemStack)result, (FoodTrait)TFGFoodTraits.REFRIGERATING);
            }
            if (!simulate) {
                this.scheduleMaintenance();
            }
            return result;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            ItemStack result = this.storage.extractItem(slot, amount, simulate);
            FoodCapability.removeTrait((ItemStack)result, (FoodTrait)TFGFoodTraits.REFRIGERATING);
            IFood food = FoodCapability.get((ItemStack)result);
            if (food != null) {
                long orig = food.getCreationDate();
                long rounded = FoodCapability.getRoundedCreationDate((long)orig);
                food.setCreationDate(Math.min(orig, rounded));
            }
            if (!simulate) {
                this.scheduleMaintenance();
            }
            return result;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            if (!this.internalEdit) {
                if (stack.m_41619_()) {
                    RefrigeratedStorage.super.setStackInSlot(slot, ItemStack.f_41583_);
                    this.scheduleMaintenance();
                    return;
                }
                IFood food = FoodCapability.get((ItemStack)stack);
                if (food == null || food.isRotten()) {
                    return;
                }
                ItemStack toSet = stack;
                if (FoodRefrigeratorMachine.this.currentlyWorking) {
                    toSet = stack.m_41777_();
                    FoodCapability.applyTrait((ItemStack)toSet, (FoodTrait)TFGFoodTraits.REFRIGERATING);
                }
                RefrigeratedStorage.super.setStackInSlot(slot, toSet);
                this.scheduleMaintenance();
                return;
            }
            RefrigeratedStorage.super.setStackInSlot(slot, stack);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<ItemStack> drainAllForDrop() {
            int i;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            int slots = this.storage.getSlots();
            for (i = 0; i < slots; ++i) {
                ItemStack st = this.storage.getStackInSlot(i);
                if (st.m_41619_()) continue;
                ItemStack copy = st.m_41777_();
                FoodCapability.removeTrait((ItemStack)copy, (FoodTrait)TFGFoodTraits.REFRIGERATING);
                IFood food = FoodCapability.get((ItemStack)copy);
                if (food != null) {
                    long orig = food.getCreationDate();
                    long rounded = FoodCapability.getRoundedCreationDate((long)orig);
                    food.setCreationDate(Math.min(orig, rounded));
                }
                drops.add(copy);
            }
            this.internalEdit = true;
            try {
                for (i = 0; i < slots; ++i) {
                    RefrigeratedStorage.super.setStackInSlot(i, ItemStack.f_41583_);
                }
            }
            finally {
                this.internalEdit = false;
            }
            return drops;
        }
    }
}

