/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.tfgt.machine.electric;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.gui.widget.GhostCircuitSlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.PhantomSlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectorWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.layout.Align;
import com.lowdragmc.lowdraglib.gui.widget.layout.Layout;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;
import su.terrafirmagreg.core.common.data.tfgt.InterplanetaryLogisticsNetwork;

public class InterplanetaryLogisticsMonitorMachine
extends MetaMachine
implements IUIMachine {
    private static final int GUI_WIDTH = 300;
    private static final int GUI_HEIGHT = 300;
    private static final int INNER_WIDTH = 292;
    private static final int INNER_HEIGHT = 292;

    public InterplanetaryLogisticsMonitorMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    public ModularUI createUI(Player entityPlayer) {
        ModularUI gui = new ModularUI(300, 300, (IUIHolder)this, entityPlayer);
        return gui.widget((Widget)new InterplanetaryLogisticsManagerWidget(entityPlayer));
    }

    private class InterplanetaryLogisticsManagerWidget
    extends WidgetGroup {
        private final List<InterplanetaryLogisticsNetwork.NetworkPart> parts;
        private InterplanetaryLogisticsNetwork network;
        private final DraggableScrollableWidgetGroup mainPage;

        private void updateIfServer() {
            if (this.network == null) {
                return;
            }
            this.network.markDirty();
        }

        public InterplanetaryLogisticsManagerWidget(Player accessor) {
            super(0, 0, 300, 300);
            this.mainPage = this.getDragContainer();
            if (!InterplanetaryLogisticsMonitorMachine.this.isRemote()) {
                this.network = InterplanetaryLogisticsNetwork.get(InterplanetaryLogisticsMonitorMachine.this.getHolder());
                this.parts = this.network.getPartsVisibleToPlayer(accessor);
                this.createUI();
            } else {
                this.parts = new ArrayList<InterplanetaryLogisticsNetwork.NetworkPart>();
            }
        }

        public void writeInitialData(FriendlyByteBuf buffer) {
            buffer.writeInt(this.parts.size());
            for (InterplanetaryLogisticsNetwork.NetworkPart part : this.parts) {
                buffer.m_130079_(part.save());
            }
        }

        private DraggableScrollableWidgetGroup getDragContainer() {
            return new DraggableScrollableWidgetGroup(4, 4, 292, 292).setDraggable(false).setScrollable(true).setScrollWheelDirection(DraggableScrollableWidgetGroup.ScrollWheelDirection.VERTICAL).setYScrollBarWidth(4).setYBarStyle((IGuiTexture)ColorPattern.RED.rectTexture(), (IGuiTexture)ColorPattern.WHITE.rectTexture().setRadius(2.0f));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void readInitialData(FriendlyByteBuf buffer) {
            int count = buffer.readInt();
            for (int i = 0; i < count; ++i) {
                CompoundTag nbt = buffer.m_130260_();
                if (nbt == null) continue;
                InterplanetaryLogisticsNetwork.NetworkPart part = new InterplanetaryLogisticsNetwork.NetworkPart(nbt);
                this.parts.add(part);
            }
            this.createUI();
        }

        private void createUI() {
            WidgetGroup container = new WidgetGroup(0, 0, 292, 0);
            container.setLayout(Layout.VERTICAL_CENTER);
            container.setDynamicSized(true);
            this.setAlign(Align.CENTER);
            this.setBackground(new IGuiTexture[]{ResourceBorderTexture.BORDERED_BACKGROUND});
            this.addWidget((Widget)this.mainPage);
            ArrayList<WidgetGroup> senderPages = new ArrayList<WidgetGroup>();
            ArrayList<WidgetGroup> receiverPages = new ArrayList<WidgetGroup>();
            for (InterplanetaryLogisticsNetwork.NetworkPart part : this.parts) {
                if (part.getUiLabel().isBlank()) {
                    part.setUiLabel("[unnamed]");
                }
                WidgetGroup rowGroup = new WidgetGroup(0, 0, 287, 22);
                rowGroup.setLayout(Layout.HORIZONTAL_CENTER);
                rowGroup.setLayoutPadding(2);
                rowGroup.addWidget((Widget)new TextFieldWidget(0, 0, 80, 16, part::getUiLabel, s -> {
                    part.setUiLabel((String)s);
                    this.updateIfServer();
                }));
                LabelWidget lbl = new LabelWidget(0, 0, part.getPartId().getUiString());
                rowGroup.addWidget((Widget)lbl);
                rowGroup.addWidget((Widget)new ButtonWidget(0, 0, 16, 16, (IGuiTexture)GuiTextures.BUTTON_RIGHT, v -> {
                    this.addWidget((Widget)(part.isReceiverPart() ? this.createReceiverPartStatusPage(part) : this.createSenderPartStatusPage(part)));
                    this.mainPage.setVisible(false);
                }));
                if (part.isReceiverPart()) {
                    receiverPages.add(rowGroup);
                    continue;
                }
                senderPages.add(rowGroup);
            }
            container.addWidget((Widget)new LabelWidget(0, 0, "Senders"));
            for (WidgetGroup page : senderPages) {
                container.addWidget((Widget)page);
            }
            container.addWidget((Widget)new LabelWidget(0, 0, "Receivers"));
            for (WidgetGroup page : receiverPages) {
                container.addWidget((Widget)page);
            }
            this.mainPage.addWidget((Widget)container);
        }

        private DraggableScrollableWidgetGroup createSenderPartStatusPage(InterplanetaryLogisticsNetwork.NetworkPart part) {
            DraggableScrollableWidgetGroup dragContainer = this.getDragContainer();
            dragContainer.setId(part.getPartId().getUiString());
            WidgetGroup group = new WidgetGroup(0, 0, 0, 0);
            group.setLayout(Layout.VERTICAL_CENTER);
            group.setDynamicSized(true);
            WidgetGroup topRow = new WidgetGroup(0, 0, 287, 20).addWidget((Widget)new ButtonWidget(2, 2, 16, 16, (IGuiTexture)GuiTextures.BUTTON_LEFT, v -> {
                this.removeWidget((Widget)dragContainer);
                this.mainPage.setVisible(true);
            })).addWidget((Widget)new TextFieldWidget(18, 2, 80, 16, part::getUiLabel, s -> {
                part.setUiLabel((String)s);
                this.updateIfServer();
            })).addWidget((Widget)new LabelWidget(102, 5, () -> part.getPartId().getUiString()));
            WidgetGroup configListContainer = new WidgetGroup(0, 0, 287, 20);
            configListContainer.setDynamicSized(true);
            configListContainer.setLayout(Layout.VERTICAL_CENTER);
            configListContainer.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
            for (InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry config : part.senderLogisticsConfigs) {
                configListContainer.addWidget((Widget)this.createSenderLogisticsConfigRow(part, config));
            }
            configListContainer.addWidget((Widget)new ButtonWidget(0, 0, 12, 12, (IGuiTexture)GuiTextures.BUTTON_INT_CIRCUIT_PLUS, c -> {
                WidgetGroup containerPadding = new WidgetGroup(0, 0, 279, 46);
                containerPadding.setDynamicSized(true);
                InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry newEntry = new InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry(part.getPartId());
                part.senderLogisticsConfigs.add(newEntry);
                this.updateIfServer();
                configListContainer.addWidget(configListContainer.widgets.size() - 1, (Widget)this.createSenderLogisticsConfigRow(part, newEntry));
            }));
            group.addWidget((Widget)topRow).addWidget((Widget)configListContainer);
            dragContainer.addWidget((Widget)group);
            return dragContainer;
        }

        private WidgetGroup createSenderLogisticsConfigRow(InterplanetaryLogisticsNetwork.NetworkPart part, InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry config) {
            WidgetGroup group = new WidgetGroup(4, 4, 279, 50);
            group.setId("sendConfigRow");
            group.addWidget((Widget)new ButtonWidget(262, 19, 12, 12, (IGuiTexture)GuiTextures.BUTTON_INT_CIRCUIT_MINUS, c -> {
                part.senderLogisticsConfigs.remove(config);
                this.updateIfServer();
                group.getParent().removeWidget((Widget)group);
            }));
            group.addWidget((Widget)new LabelWidget(0, 6, "Destination:"));
            SelectorWidget destinationSelector = new SelectorWidget(57, 2, 80, 18, new ArrayList(), -1).setButtonBackground(new IGuiTexture[]{GuiTextures.BUTTON});
            if (!this.isRemote()) {
                destinationSelector.setCandidatesSupplier(() -> this.parts.stream().filter(p -> p.isReceiverPart() && !Objects.equals(p.getUiLabel(), "[unnamed]")).map(InterplanetaryLogisticsNetwork.NetworkPart::getUiLabel).toList());
            }
            destinationSelector.setValue("[none]");
            for (InterplanetaryLogisticsNetwork.NetworkPart rPart : this.parts) {
                if (rPart.getPartId() != config.getReceiverPartID()) continue;
                destinationSelector.setValue(rPart.getUiLabel());
            }
            destinationSelector.setOnChanged(v -> {
                this.parts.stream().filter(p -> Objects.equals(p.getUiLabel(), v)).findFirst().ifPresent(s -> config.setReceiverPartID(s.getPartId()));
                this.updateIfServer();
            });
            group.addWidget((Widget)destinationSelector);
            IntInputWidget inactivityIntInput = new IntInputWidget(160, 1, 100, 20, config::getCurrentInactivityTimeout, v -> {
                config.setCurrentInactivityTimeout((int)v);
                this.updateIfServer();
            });
            WidgetGroup itemFilterGroup = new WidgetGroup(Position.of((int)160, (int)2)).addWidget((Widget)new PhantomSlotWidget((IItemHandlerModifiable)config.getCurrentSendFilter(), 0, 0, 0).setChangeListener(this::updateIfServer)).addWidget((Widget)new PhantomSlotWidget((IItemHandlerModifiable)config.getCurrentSendFilter(), 1, 18, 0).setChangeListener(this::updateIfServer)).addWidget((Widget)new PhantomSlotWidget((IItemHandlerModifiable)config.getCurrentSendFilter(), 2, 36, 0).setChangeListener(this::updateIfServer));
            inactivityIntInput.setVisible(config.getCurrentSendTrigger() == InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry.TriggerMode.INACTIVITY);
            itemFilterGroup.setVisible(config.getCurrentSendTrigger() == InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry.TriggerMode.ITEM);
            EnumSelectorWidget modeSelector = new EnumSelectorWidget(140, 1, 20, 20, (Enum[])InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry.TriggerMode.values(), (Enum)config.getCurrentSendTrigger(), v -> {
                config.setCurrentSendTrigger((InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry.TriggerMode)((Object)v));
                inactivityIntInput.setVisible(config.getCurrentSendTrigger() == InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry.TriggerMode.INACTIVITY);
                itemFilterGroup.setVisible(config.getCurrentSendTrigger() == InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry.TriggerMode.ITEM);
                this.updateIfServer();
            });
            group.addWidget((Widget)inactivityIntInput).addWidget((Widget)itemFilterGroup).addWidget((Widget)modeSelector);
            group.addWidget((Widget)new LabelWidget(0, 27, "Sender:"));
            CustomItemStackHandler senderCircuitInv = new CustomItemStackHandler(1);
            CustomItemStackHandler receiverCircuitInv = new CustomItemStackHandler(1);
            GhostCircuitSlotWidget senderDistinctCircuit = new GhostCircuitSlotWidget();
            senderDistinctCircuit.setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.INT_CIRCUIT_OVERLAY}).setSelfPosition(40, 25);
            senderDistinctCircuit.setCircuitInventory((IItemHandlerModifiable)senderCircuitInv);
            senderDistinctCircuit.setCircuitValue(config.getSenderDistinctInventory());
            senderCircuitInv.setOnContentsChanged(() -> {
                config.setSenderDistinctInventory(IntCircuitBehaviour.getCircuitConfiguration((ItemStack)senderCircuitInv.getStackInSlot(0)));
                this.updateIfServer();
            });
            group.addWidget((Widget)new LabelWidget(65, 27, "Receiver:"));
            GhostCircuitSlotWidget receiverDistinctCircuit = new GhostCircuitSlotWidget();
            receiverDistinctCircuit.setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.INT_CIRCUIT_OVERLAY}).setSelfPosition(115, 25);
            receiverDistinctCircuit.setCircuitInventory((IItemHandlerModifiable)receiverCircuitInv);
            receiverDistinctCircuit.setCircuitValue(config.getReceiverDistinctInventory());
            receiverCircuitInv.setOnContentsChanged(() -> {
                config.setReceiverDistinctInventory(IntCircuitBehaviour.getCircuitConfiguration((ItemStack)receiverCircuitInv.getStackInSlot(0)));
                this.updateIfServer();
            });
            group.addWidget((Widget)senderDistinctCircuit).addWidget((Widget)receiverDistinctCircuit);
            WidgetGroup containerPadding = new WidgetGroup(0, 0, 279, 46);
            containerPadding.setDynamicSized(true);
            return containerPadding.addWidget((Widget)group);
        }

        private DraggableScrollableWidgetGroup createReceiverPartStatusPage(InterplanetaryLogisticsNetwork.NetworkPart part) {
            DraggableScrollableWidgetGroup dragContainer = this.getDragContainer();
            dragContainer.setId(part.getPartId().getUiString());
            WidgetGroup group = new WidgetGroup(0, 0, 0, 0);
            group.setLayout(Layout.VERTICAL_CENTER);
            group.setDynamicSized(true);
            WidgetGroup topRow = new WidgetGroup(0, 0, 287, 20).addWidget((Widget)new ButtonWidget(2, 2, 16, 16, (IGuiTexture)GuiTextures.BUTTON_LEFT, v -> {
                dragContainer.setVisible(false);
                this.mainPage.setVisible(true);
            })).addWidget((Widget)new TextFieldWidget(18, 2, 80, 16, part::getUiLabel, s -> {
                part.setUiLabel((String)s);
                this.updateIfServer();
            })).addWidget((Widget)new LabelWidget(102, 5, part.getPartId().getUiString()));
            WidgetGroup configListContainer = new WidgetGroup(0, 0, 287, 20);
            configListContainer.setDynamicSized(true);
            configListContainer.setLayout(Layout.VERTICAL_CENTER);
            configListContainer.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
            for (InterplanetaryLogisticsNetwork.NetworkReceiverConfigEntry config : part.receiverLogisticsConfigs) {
                WidgetGroup logisticsConfigGroup = new WidgetGroup(4, 4, 279, 30);
                GuiTextureGroup circuitTexture = config.getDistinctInventory() == 0 ? new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, new ItemStackTexture(new ItemStack[]{IntCircuitBehaviour.stack((int)0)}), new ItemStackTexture(new Item[]{Items.f_42127_})}) : new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, new ItemStackTexture(new ItemStack[]{IntCircuitBehaviour.stack((int)config.getDistinctInventory())})});
                ImageWidget circuitWidget = new ImageWidget(6, 6, 18, 18, (IGuiTexture)circuitTexture);
                IntInputWidget cooldownIntInput = new IntInputWidget(160, 5, 100, 20, config::getCurrentCooldown, v -> {
                    config.setCurrentCooldown((int)v);
                    this.updateIfServer();
                });
                cooldownIntInput.setMin((Number)0).setMax((Number)1800);
                cooldownIntInput.setVisible(config.getCurrentMode() == InterplanetaryLogisticsNetwork.NetworkReceiverConfigEntry.LogicMode.COOLDOWN);
                EnumSelectorWidget modeSelector = new EnumSelectorWidget(140, 5, 20, 20, (Enum[])InterplanetaryLogisticsNetwork.NetworkReceiverConfigEntry.LogicMode.values(), (Enum)config.getCurrentMode(), v -> {
                    config.setCurrentMode((InterplanetaryLogisticsNetwork.NetworkReceiverConfigEntry.LogicMode)((Object)v));
                    cooldownIntInput.setVisible(v == InterplanetaryLogisticsNetwork.NetworkReceiverConfigEntry.LogicMode.COOLDOWN);
                    this.updateIfServer();
                });
                logisticsConfigGroup.addWidget((Widget)circuitWidget).addWidget((Widget)modeSelector).addWidget((Widget)cooldownIntInput);
                configListContainer.addWidget((Widget)logisticsConfigGroup);
            }
            group.addWidget((Widget)topRow).addWidget((Widget)configListContainer);
            dragContainer.addWidget((Widget)group);
            return dragContainer;
        }
    }
}

