/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.tfgt.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.common.machine.multiblock.part.EnergyHatchPartMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import su.terrafirmagreg.core.common.data.TFGParticles;
import su.terrafirmagreg.core.common.data.tfgt.InterplanetaryLogisticsNetwork;
import su.terrafirmagreg.core.common.data.tfgt.machine.multiblock.part.RailgunAmmoLoaderMachine;
import su.terrafirmagreg.core.common.data.tfgt.machine.multiblock.part.RailgunItemBusMachine;
import su.terrafirmagreg.core.network.TFGNetworkHandler;

public class InterplanetaryItemLauncherMachine
extends WorkableElectricMultiblockMachine
implements InterplanetaryLogisticsNetwork.ILogisticsNetworkSender,
IMachineLife,
IFancyUIMachine,
IDisplayUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(InterplanetaryItemLauncherMachine.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    public long energyBuffer = 0L;
    public static long energyCapacity = GTValues.V[3] * 32L;
    protected TickableSubscription energyTickSubscription;
    protected TickableSubscription tickSubscription;
    private EnergyContainerList energyInputs;
    private final List<RailgunItemBusMachine> itemInputs = new ArrayList<RailgunItemBusMachine>();
    private final long[] lastActiveTime = new long[33];
    private RailgunAmmoLoaderMachine ammoLoaderPart;

    public InterplanetaryItemLauncherMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    public InterplanetaryItemLauncherMachine getMachine() {
        return this;
    }

    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void setWorkingEnabled(boolean isWorkingAllowed) {
        super.setWorkingEnabled(isWorkingAllowed);
        this.updateEnergySubscription();
        this.updateSubscription();
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel sLvl = (ServerLevel)level;
            if (!InterplanetaryLogisticsNetwork.DIMENSION_DISTANCES.containsKey(this.getDimensionalPos().dimension())) {
                return;
            }
            sLvl.m_7654_().m_6937_((Runnable)new TickTask(0, () -> this.getLogisticsNetwork().loadOrCreatePart(this)));
        }
    }

    public void onUnload() {
        super.onUnload();
        if (!this.isRemote()) {
            this.getLogisticsNetwork().unloadPart(this);
        }
    }

    public void onMachineRemoved() {
        if (!this.isRemote()) {
            this.getLogisticsNetwork().destroyPart(this);
        }
    }

    @Override
    public boolean isMachineInvalid() {
        return !this.isFormed() || this.isInValid();
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        ArrayList<NotifiableEnergyContainer> energyHatches = new ArrayList<NotifiableEnergyContainer>();
        this.itemInputs.clear();
        for (IMultiPart part : this.getParts()) {
            if (part instanceof EnergyHatchPartMachine) {
                EnergyHatchPartMachine energyHatch = (EnergyHatchPartMachine)part;
                energyHatches.add(energyHatch.energyContainer);
            }
            if (part instanceof RailgunAmmoLoaderMachine) {
                RailgunAmmoLoaderMachine ammo;
                this.ammoLoaderPart = ammo = (RailgunAmmoLoaderMachine)part;
            }
            if (!(part instanceof RailgunItemBusMachine)) continue;
            RailgunItemBusMachine bus = (RailgunItemBusMachine)part;
            this.itemInputs.add(bus);
            bus.getInventory().addChangedListener(() -> {
                this.lastActiveTime[IntCircuitBehaviour.getCircuitConfiguration((ItemStack)bus.getCircuitInventory().getStackInSlot((int)0))] = Objects.requireNonNull(this.getLevel()).m_46467_();
            });
        }
        this.energyInputs = new EnergyContainerList(energyHatches);
        this.updateEnergySubscription();
        this.updateSubscription();
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.energyInputs = null;
        this.energyBuffer = 0L;
        this.ammoLoaderPart = null;
        this.itemInputs.clear();
    }

    @Override
    public List<RailgunItemBusMachine> getInventories() {
        if (this.isMachineInvalid()) {
            return List.of();
        }
        ArrayList<RailgunItemBusMachine> parts = new ArrayList<RailgunItemBusMachine>();
        for (IMultiPart part : this.getParts()) {
            if (!(part instanceof RailgunItemBusMachine)) continue;
            RailgunItemBusMachine r = (RailgunItemBusMachine)part;
            parts.add(r);
        }
        return parts;
    }

    private void updateEnergySubscription() {
        if (this.isRemote()) {
            return;
        }
        if (this.isFormed()) {
            this.energyTickSubscription = this.subscribeServerTick(this.energyTickSubscription, this::energyTick);
        } else if (this.energyTickSubscription != null) {
            this.energyTickSubscription.unsubscribe();
        }
    }

    private void updateSubscription() {
        if (this.isRemote()) {
            return;
        }
        if (this.isFormed() && this.isWorkingEnabled()) {
            this.tickSubscription = this.subscribeServerTick(this.tickSubscription, this::tick);
        } else if (this.tickSubscription != null) {
            this.tickSubscription.unsubscribe();
        }
    }

    private void energyTick() {
        if (this.isWorkingEnabled() && this.isFormed() && this.energyInputs != null && this.energyBuffer < energyCapacity) {
            this.energyBuffer += this.energyInputs.removeEnergy(Math.min(energyCapacity - this.energyBuffer, GTValues.V[2]));
        }
        this.updateEnergySubscription();
    }

    private void tick() {
        if (Objects.requireNonNull(this.getLevel()).m_46467_() % 20L != 0L) {
            this.updateSubscription();
            return;
        }
        for (InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry config : this.getSendConfigurations()) {
            boolean result;
            List<RailgunItemBusMachine> withCircuit;
            if (!this.ammoLoaderPart.getInventory().isEmpty() && ((withCircuit = this.itemInputs.stream().filter(c -> IntCircuitBehaviour.getCircuitConfiguration((ItemStack)c.getCircuitInventory().getStackInSlot(0)) == config.getSenderDistinctInventory() && c.isWorkingEnabled() && !c.getInventory().isEmpty()).toList()).isEmpty() || config.getReceiverPartID() == null || !(result = this.tryLaunchItemPayload(config)))) continue;
            break;
        }
        this.updateSubscription();
    }

    private boolean tryLaunchItemPayload(InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry config) {
        Level level;
        InterplanetaryLogisticsNetwork.ILogisticsNetworkMachine destination = this.getLogisticsNetwork().getNetworkMachine(config.getReceiverPartID());
        if (!(destination instanceof InterplanetaryLogisticsNetwork.ILogisticsNetworkReceiver)) {
            return false;
        }
        InterplanetaryLogisticsNetwork.ILogisticsNetworkReceiver receiver = (InterplanetaryLogisticsNetwork.ILogisticsNetworkReceiver)destination;
        ArrayList<ItemStack> itemsToExtract = new ArrayList<ItemStack>();
        List<RailgunItemBusMachine> itemBuses = this.itemInputs.stream().filter(c -> IntCircuitBehaviour.getCircuitConfiguration((ItemStack)c.getCircuitInventory().getStackInSlot(0)) == config.getSenderDistinctInventory() && c.isWorkingEnabled() && !c.getInventory().isEmpty()).toList();
        if (itemBuses.isEmpty()) {
            return false;
        }
        if (config.getCurrentSendTrigger() == InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry.TriggerMode.ITEM) {
            for (int i = 0; i < config.getCurrentSendFilter().getSlots(); ++i) {
                itemsToExtract.add(config.getCurrentSendFilter().getStackInSlot(i));
            }
        } else if (config.getCurrentSendTrigger() == InterplanetaryLogisticsNetwork.NetworkSenderConfigEntry.TriggerMode.REDSTONE_SIGNAL) {
            boolean hasAnySignal = false;
            for (RailgunItemBusMachine bus : itemBuses) {
                if (!Objects.requireNonNull(this.getLevel()).m_276867_(bus.getPos())) continue;
                hasAnySignal = true;
                break;
            }
            if (!hasAnySignal) {
                return false;
            }
        } else {
            long inactivityTime = this.lastActiveTime[config.getSenderDistinctInventory()];
            long currentTick = Objects.requireNonNull(this.getLevel()).m_46467_();
            if (inactivityTime + 20L * (long)config.getCurrentInactivityTimeout() >= currentTick) {
                return false;
            }
        }
        if (itemsToExtract.isEmpty()) {
            int matched = 0;
            for (RailgunItemBusMachine bus : itemBuses) {
                if (bus.getInventory().isEmpty()) continue;
                for (int i = 0; i < bus.getInventory().getSlots(); ++i) {
                    ItemStack stack = bus.getInventory().getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    itemsToExtract.add(stack);
                    if (this.tryExtractFromCircuitInventory(itemsToExtract, config.getSenderDistinctInventory(), true) && receiver.canAcceptItems(config.getReceiverDistinctInventory(), itemsToExtract)) {
                        ++matched;
                    } else {
                        itemsToExtract.remove(stack);
                    }
                    if (++matched == 3) break;
                }
                if (matched != 3) continue;
                break;
            }
        }
        Integer sendPos = InterplanetaryLogisticsNetwork.DIMENSION_DISTANCES.get(this.getDimensionalPos().dimension());
        Integer receiverPos = InterplanetaryLogisticsNetwork.DIMENSION_DISTANCES.get(receiver.getDimensionalPos().dimension());
        int travelTime = Math.abs(sendPos - receiverPos);
        if (!this.tryExtractFromCircuitInventory(itemsToExtract, config.getSenderDistinctInventory(), true) || itemsToExtract.isEmpty() || itemsToExtract.stream().allMatch(ItemStack::m_41619_)) {
            return false;
        }
        this.ammoLoaderPart.getInventory().extractItemInternal(0, 1, false);
        this.energyBuffer -= 16L * GTValues.V[3];
        boolean extracted = this.tryExtractFromCircuitInventory(itemsToExtract, config.getSenderDistinctInventory(), false);
        if (extracted) {
            receiver.onPackageSent(config.getReceiverDistinctInventory(), itemsToExtract, 20 * travelTime);
        }
        if ((level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos basePos = this.getPos();
            BlockState state = this.getBlockState();
            Direction facing = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            double x = (double)basePos.m_123341_() + 0.5;
            double y = (double)basePos.m_123342_() + 1.0;
            double z = (double)basePos.m_123343_() + 0.5;
            switch (facing) {
                case NORTH: {
                    z += 2.0;
                    break;
                }
                case SOUTH: {
                    z -= 2.0;
                    break;
                }
                case WEST: {
                    x += 2.0;
                    break;
                }
                case EAST: {
                    x -= 2.0;
                }
            }
            assert (TFGParticles.RAILGUN_AMMO.getKey() != null);
            TFGNetworkHandler.sendParticle(serverLevel, x, y, z, new Vec3(0.0, 1.0, 0.0), TFGParticles.RAILGUN_AMMO.getKey().m_135782_(), 1, 0.0, 0.0, 0.0);
            assert (TFGParticles.RAILGUN_BOOM.getKey() != null);
            TFGNetworkHandler.sendParticle(serverLevel, x, y + 13.0, z, Vec3.f_82478_, TFGParticles.RAILGUN_BOOM.getKey().m_135782_(), 1, 0.0, 0.0, 0.0);
            TFGNetworkHandler.sendParticle(serverLevel, x, y + 3.0, z, new Vec3(1.0, 1.0, 1.0), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"explosion"), 10, 1.0, 1.0, 1.0);
            TFGNetworkHandler.sendParticle(serverLevel, x, y + 23.0, z, new Vec3(0.0, 0.0, 0.0), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"wax_off"), 100, 0.0, 10.0, 0.0);
            ResourceLocation boomSound = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entity.warden.sonic_boom");
            TFGNetworkHandler.sendSound(serverLevel, x, y + 13.0, z, boomSound, 10.0f, 0.1f);
            ResourceLocation rocketSound = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entity.firework_rocket.blast");
            TFGNetworkHandler.sendSound(serverLevel, x, y, z, rocketSound, 10.0f, 0.1f);
            ResourceLocation explosionSound = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entity.generic.explode");
            TFGNetworkHandler.sendSound(serverLevel, x, y, z, explosionSound, 10.0f, 2.0f);
        }
        return true;
    }

    @Override
    public Component getCurrentStatusText() {
        if (!this.isFormed()) {
            return Component.m_237113_((String)"\u00a7cMultiblock not formed");
        }
        return null;
    }

    public void addDisplayText(@NotNull List<Component> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isFormed()).setWorkingStatus(this.recipeLogic.isWorkingEnabled(), this.recipeLogic.isActive()).addWorkingStatusLine();
        textList.add((Component)Component.m_237113_((String)"Power stored: %s".formatted(FormattingUtil.formatNumbers((long)this.energyBuffer))));
        textList.add((Component)Component.m_237113_((String)"Power capacity: %s".formatted(FormattingUtil.formatNumbers((long)energyCapacity))));
        for (IMultiPart part : this.getParts()) {
            part.addMultiText(textList);
        }
    }

    private boolean tryExtractFromCircuitInventory(List<ItemStack> toExtract, int circuit, boolean simulated) {
        ArrayList<ItemStack> remainingItems = new ArrayList<ItemStack>();
        for (ItemStack v : toExtract) {
            remainingItems.add(v.m_41777_());
        }
        List<RailgunItemBusMachine> itemBuses = this.itemInputs.stream().filter(c -> IntCircuitBehaviour.getCircuitConfiguration((ItemStack)c.getCircuitInventory().getStackInSlot(0)) == circuit && c.isWorkingEnabled()).toList();
        for (RailgunItemBusMachine bus : itemBuses) {
            InterplanetaryItemLauncherMachine.tryExtractFromInventory(remainingItems, bus.getInventory().storage, simulated);
            if (!remainingItems.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static void tryExtractFromInventory(List<ItemStack> remainingItems, CustomItemStackHandler inventory, boolean simulated) {
        ListIterator<ItemStack> iter = remainingItems.listIterator();
        block0: while (iter.hasNext()) {
            ItemStack stack = iter.next();
            for (int slotIndex = 0; slotIndex < inventory.getSlots(); ++slotIndex) {
                if (ItemStack.m_41656_((ItemStack)inventory.getStackInSlot(slotIndex), (ItemStack)stack)) {
                    ItemStack extracted = inventory.extractItem(slotIndex, stack.m_41613_(), simulated);
                    stack.m_41764_(stack.m_41613_() - extracted.m_41613_());
                }
                if (stack.m_41613_() != 0) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    @Generated
    public long getEnergyBuffer() {
        return this.energyBuffer;
    }
}

