/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.tfgt.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import su.terrafirmagreg.core.common.data.tfgt.InterplanetaryLogisticsNetwork;
import su.terrafirmagreg.core.common.data.tfgt.machine.multiblock.part.RailgunItemBusMachine;

public class InterplanetaryItemReceiverMachine
extends WorkableElectricMultiblockMachine
implements InterplanetaryLogisticsNetwork.ILogisticsNetworkReceiver,
IMachineLife,
IFancyUIMachine,
IDisplayUIMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(InterplanetaryItemReceiverMachine.class, WorkableElectricMultiblockMachine.MANAGED_FIELD_HOLDER);
    private final List<ItemPayload> payloads = new ArrayList<ItemPayload>();
    private final List<RailgunItemBusMachine> itemOutputs = new ArrayList<RailgunItemBusMachine>();
    private final long[] lastActiveTime = new long[33];

    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public InterplanetaryItemReceiverMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    public InterplanetaryItemReceiverMachine getMachine() {
        return this;
    }

    @Override
    public boolean isMachineInvalid() {
        return !this.isFormed() || this.isInValid();
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel sLvl = (ServerLevel)level;
            sLvl.m_7654_().m_6937_((Runnable)new TickTask(0, () -> {
                this.getLogisticsNetwork().loadOrCreatePart(this);
                this.payloads.forEach(p -> sLvl.m_7654_().m_6937_((Runnable)new TickTask(p.travelDuration, () -> this.onPackageArrival((ItemPayload)p))));
            }));
        }
    }

    public void onUnload() {
        super.onUnload();
        if (!this.isRemote()) {
            this.getLogisticsNetwork().unloadPart(this);
        }
    }

    public void onStructureFormed() {
        super.onStructureFormed();
        MinecraftServer server = Objects.requireNonNull(this.getLevel()).m_7654_();
        if (server == null) {
            return;
        }
        Arrays.fill(this.lastActiveTime, this.getLevel().m_46467_());
        this.itemOutputs.clear();
        this.itemOutputs.addAll(this.getInventories());
    }

    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.itemOutputs.clear();
    }

    public void onMachineRemoved() {
        if (!this.isRemote()) {
            this.getLogisticsNetwork().destroyPart(this);
        }
    }

    @Override
    public List<RailgunItemBusMachine> getInventories() {
        if (this.isMachineInvalid()) {
            return List.of();
        }
        ArrayList<RailgunItemBusMachine> parts = new ArrayList<RailgunItemBusMachine>();
        for (IMultiPart part : this.getParts()) {
            if (!(part instanceof RailgunItemBusMachine)) continue;
            RailgunItemBusMachine r = (RailgunItemBusMachine)part;
            parts.add(r);
        }
        return parts;
    }

    @Override
    public boolean canAcceptItems(int inventoryIndex, List<ItemStack> stacks) {
        List<RailgunItemBusMachine> withCircuit = this.itemOutputs.stream().filter(c -> IntCircuitBehaviour.getCircuitConfiguration((ItemStack)c.getCircuitInventory().getStackInSlot(0)) == inventoryIndex && c.isWorkingEnabled()).toList();
        if (withCircuit.isEmpty()) {
            return false;
        }
        InterplanetaryLogisticsNetwork.NetworkReceiverConfigEntry config = Objects.requireNonNull(this.getLogisticsNetwork().getPart((InterplanetaryLogisticsNetwork.DimensionalBlockPos)this.getDimensionalPos())).receiverLogisticsConfigs.get(inventoryIndex);
        long currentTick = Objects.requireNonNull(this.getLevel()).m_46467_();
        if (config.getCurrentMode() == InterplanetaryLogisticsNetwork.NetworkReceiverConfigEntry.LogicMode.COOLDOWN && this.lastActiveTime[inventoryIndex] + 20L * (long)config.getCurrentCooldown() > currentTick) {
            return false;
        }
        if (config.getCurrentMode() == InterplanetaryLogisticsNetwork.NetworkReceiverConfigEntry.LogicMode.REDSTONE_DISABLE) {
            for (RailgunItemBusMachine bus : withCircuit) {
                if (!this.getLevel().m_276867_(bus.getPos())) continue;
                return false;
            }
        } else if (config.getCurrentMode() == InterplanetaryLogisticsNetwork.NetworkReceiverConfigEntry.LogicMode.REDSTONE_ENABLE) {
            boolean hasFoundSignal = false;
            for (RailgunItemBusMachine bus : withCircuit) {
                if (!this.getLevel().m_276867_(bus.getPos())) continue;
                hasFoundSignal = true;
                break;
            }
            if (!hasFoundSignal) {
                return false;
            }
        }
        ArrayList<ItemStack> remaining = new ArrayList<ItemStack>();
        for (ItemStack stack : stacks) {
            remaining.add(stack.m_41777_());
        }
        for (RailgunItemBusMachine outputBus : withCircuit) {
            NotifiableItemStackHandler inventory = outputBus.getInventory();
            CustomItemStackHandler simulatedInsert = new CustomItemStackHandler(outputBus.getInventory().getSlots());
            for (int i = 0; i < inventory.getSlots(); ++i) {
                simulatedInsert.setStackInSlot(i, inventory.getStackInSlot(i).m_41777_());
            }
            ListIterator iter = remaining.listIterator();
            while (iter.hasNext()) {
                ItemStack stack = (ItemStack)iter.next();
                for (int i = 0; i < simulatedInsert.getSlots(); ++i) {
                    stack = simulatedInsert.insertItem(i, stack, false);
                }
                if (!stack.m_41619_()) continue;
                iter.remove();
            }
        }
        return remaining.isEmpty();
    }

    private void onPackageArrival(ItemPayload payload) {
        this.payloads.remove(payload);
        this.lastActiveTime[payload.inventoryIndex] = Objects.requireNonNull(this.getLevel()).m_46467_();
        List<RailgunItemBusMachine> withCircuit = this.itemOutputs.stream().filter(c -> IntCircuitBehaviour.getCircuitConfiguration((ItemStack)c.getCircuitInventory().getStackInSlot(0)) == payload.inventoryIndex && c.isWorkingEnabled()).toList();
        block0: for (ItemStack itemToInsert : payload.items) {
            ItemStack amountLeft = itemToInsert.m_41777_();
            for (RailgunItemBusMachine outputBus : withCircuit) {
                NotifiableItemStackHandler inventory = outputBus.getInventory();
                for (int i = 0; i < inventory.getSlots() && (amountLeft = inventory.insertItemInternal(i, amountLeft, false)) != ItemStack.f_41583_; ++i) {
                }
                if (amountLeft != ItemStack.f_41583_) continue;
                continue block0;
            }
        }
    }

    @Override
    public void onPackageSent(int inventoryIndex, List<ItemStack> items, int travelDuration) {
        MinecraftServer server = Objects.requireNonNull(this.getLevel()).m_7654_();
        ItemPayload payload = new ItemPayload(travelDuration, items, inventoryIndex);
        this.payloads.add(payload);
        assert (server != null);
        server.m_6937_((Runnable)new TickTask(travelDuration, () -> this.onPackageArrival(payload)));
    }

    @Override
    public Component getCurrentStatusText() {
        if (!this.isFormed()) {
            return Component.m_237113_((String)"\u00a7cMultiblock not formed");
        }
        return null;
    }

    public void saveCustomPersistedData(@NotNull CompoundTag tag, boolean forDrop) {
        super.saveCustomPersistedData(tag, forDrop);
        if (forDrop) {
            return;
        }
        ListTag newTag = new ListTag();
        for (ItemPayload payload : this.payloads) {
            newTag.add((Object)payload.serializeNBT());
        }
        tag.m_128365_("payloads", (Tag)newTag);
    }

    public void loadCustomPersistedData(@NotNull CompoundTag tag) {
        super.loadCustomPersistedData(tag);
        ListTag listTag = tag.m_128437_("payloads", 10);
        for (Tag entry : listTag) {
            if (!(entry instanceof CompoundTag)) {
                return;
            }
            CompoundTag ctag = (CompoundTag)entry;
            ItemPayload saved = new ItemPayload();
            saved.deserializeNBT(ctag);
            this.payloads.add(saved);
        }
    }

    private static class ItemPayload
    implements ITagSerializable<CompoundTag> {
        public int travelDuration;
        public List<ItemStack> items;
        public int inventoryIndex;

        public ItemPayload() {
            this.travelDuration = 0;
            this.items = new ArrayList<ItemStack>();
            this.inventoryIndex = 0;
        }

        public ItemPayload(int travelDuration, List<ItemStack> items, int inventoryIndex) {
            this.travelDuration = travelDuration;
            this.items = items;
            this.inventoryIndex = inventoryIndex;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("travelDuration", this.travelDuration);
            tag.m_128405_("inventoryIndex", this.inventoryIndex);
            ListTag list = new ListTag();
            for (ItemStack s : this.items) {
                list.add((Object)s.m_41739_(new CompoundTag()));
            }
            tag.m_128365_("items", (Tag)list);
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.travelDuration = nbt.m_128451_("travelDuration");
            this.inventoryIndex = nbt.m_128451_("inventoryIndex");
            ListTag list = nbt.m_128437_("items", 10);
            for (Tag tag : list) {
                this.items.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)tag)));
            }
        }
    }
}

