/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.tfgt.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.ActionResult;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.IFood;
import net.dries007.tfc.common.recipes.RecipeHelpers;
import net.dries007.tfc.common.recipes.outputs.ItemStackProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import su.terrafirmagreg.core.TFGCore;

public class ISPOutputRecipeLogic
extends RecipeLogic {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ISPOutputRecipeLogic.class, RecipeLogic.MANAGED_FIELD_HOLDER);
    private static final Map<String, TFCRecipeData> TFCRecipes = new HashMap<String, TFCRecipeData>();
    @Persisted
    List<ItemStack> currentItems = new ArrayList<ItemStack>();
    List<ItemStack> currentItemsSimulated = new ArrayList<ItemStack>();

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public static void RegisterRecipeData(String id, List<Ingredient> inputs, ItemStackProvider output, List<ItemStack> secondaryOutputs) {
        ArrayList<SizedIngredient> sizedIngredients = new ArrayList<SizedIngredient>();
        for (Ingredient in : inputs) {
            if (in instanceof SizedIngredient) {
                SizedIngredient sized = (SizedIngredient)in;
                sizedIngredients.add(sized);
                continue;
            }
            sizedIngredients.add(SizedIngredient.create((Ingredient)in, (int)1));
        }
        TFCRecipes.put(id, new TFCRecipeData(sizedIngredients, output, secondaryOutputs));
    }

    public ISPOutputRecipeLogic(IRecipeLogicMachine machine) {
        super(machine);
    }

    private IRecipeCapabilityHolder getCapHolder() {
        return (IRecipeCapabilityHolder)this.getMachine();
    }

    protected ActionResult checkRecipe(GTRecipe recipe) {
        ActionResult result = super.checkRecipe(recipe);
        TFCRecipeData recipeData = TFCRecipes.get(recipe.id.m_135815_());
        if (result.isSuccess() && recipeData != null) {
            if (!this.consumeRecipeInputItems(recipeData, true)) {
                return ActionResult.fail((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_in").m_130946_(": ").m_7220_((Component)ItemRecipeCapability.CAP.getName()), (RecipeCapability)ItemRecipeCapability.CAP, (IO)IO.IN);
            }
            if (!this.handleOutput(recipeData, true)) {
                return ActionResult.fail((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_out").m_130946_(": ").m_7220_((Component)ItemRecipeCapability.CAP.getName()), (RecipeCapability)ItemRecipeCapability.CAP, (IO)IO.OUT);
            }
        }
        return result;
    }

    protected ActionResult handleRecipeIO(GTRecipe recipe, IO io) {
        TFCRecipeData currentRecipe = TFCRecipes.get(recipe.id.m_135815_());
        if (currentRecipe == null) {
            return super.handleRecipeIO(recipe, io);
        }
        List fluids = io == IO.IN ? recipe.getInputContents((RecipeCapability)FluidRecipeCapability.CAP) : recipe.getOutputContents((RecipeCapability)FluidRecipeCapability.CAP);
        RecipeHelper.handleRecipe((IRecipeCapabilityHolder)this.getCapHolder(), (GTRecipe)recipe, (IO)io, Map.of(FluidRecipeCapability.CAP, fluids), (Map)this.chanceCaches, (boolean)false, (boolean)false);
        if (io == IO.IN) {
            return this.consumeRecipeInputItems(currentRecipe, false) ? ActionResult.SUCCESS : ActionResult.fail((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_in").m_130946_(": ").m_7220_((Component)ItemRecipeCapability.CAP.getName()), (RecipeCapability)ItemRecipeCapability.CAP, (IO)io);
        }
        return this.handleOutput(currentRecipe, false) ? ActionResult.SUCCESS : ActionResult.fail((Component)Component.m_237115_((String)"gtceu.recipe_logic.insufficient_out").m_130946_(": ").m_7220_((Component)ItemRecipeCapability.CAP.getName()), (RecipeCapability)ItemRecipeCapability.CAP, (IO)io);
    }

    private boolean consumeRecipeInputItems(TFCRecipeData currentRecipe, boolean simulate) {
        if (currentRecipe.inputs.isEmpty()) {
            return true;
        }
        ArrayList inputHandlers = new ArrayList();
        this.getCapHolder().getCapabilitiesForIO(IO.IN).forEach(v -> inputHandlers.addAll(v.getCapability((RecipeCapability)ItemRecipeCapability.CAP)));
        inputHandlers.sort(IRecipeHandler.ENTRY_COMPARATOR);
        ArrayList<SizedIngredient> inputsToConsume = new ArrayList<SizedIngredient>(currentRecipe.inputs);
        ArrayList<ItemStack> extracted = new ArrayList<ItemStack>();
        for (IRecipeHandler inputHandler : inputHandlers) {
            if (inputHandler instanceof NotifiableItemStackHandler) {
                NotifiableItemStackHandler stackHandler = (NotifiableItemStackHandler)inputHandler;
                Iterator iter = inputsToConsume.iterator();
                block1: while (iter.hasNext()) {
                    SizedIngredient sized = (SizedIngredient)iter.next();
                    int amount = sized.getAmount();
                    for (int index = 0; index < stackHandler.getSlots(); ++index) {
                        ItemStack iStack = stackHandler.getStackInSlot(index);
                        IFood food = FoodCapability.get((ItemStack)iStack);
                        if (!sized.getInner().test(iStack) || food != null && food.isRotten()) continue;
                        ItemStack result = stackHandler.extractItemInternal(index, amount, simulate);
                        if (result.m_41613_() < amount) {
                            amount -= result.m_41613_();
                            extracted.add(result);
                            continue;
                        }
                        iter.remove();
                        extracted.add(result);
                        continue block1;
                    }
                }
                continue;
            }
            TFGCore.LOGGER.warn("Unexpected input capability proxy: Expected NotifiableItemStackHandler, actual: {}", inputHandler.getClass());
        }
        if (!inputsToConsume.isEmpty()) {
            return false;
        }
        if (simulate) {
            this.currentItemsSimulated = extracted;
        } else {
            this.currentItems = extracted;
        }
        return true;
    }

    private boolean handleOutput(TFCRecipeData currentRecipe, boolean simulate) {
        if (currentRecipe.outputISP == null) {
            return true;
        }
        if (simulate && this.currentItemsSimulated.isEmpty() || !simulate && this.currentItems.isEmpty()) {
            return false;
        }
        ArrayList outputHandlers = new ArrayList();
        this.getCapHolder().getCapabilitiesForIO(IO.OUT).forEach(v -> outputHandlers.addAll(v.getCapability((RecipeCapability)ItemRecipeCapability.CAP)));
        outputHandlers.sort(IRecipeHandler.ENTRY_COMPARATOR);
        RecipeHelpers.setCraftingInput((CraftingContainer)new SimulatedCraftingContainer(simulate ? this.currentItemsSimulated : this.currentItems));
        ItemStack ispResult = currentRecipe.outputISP.getStack(simulate ? this.currentItemsSimulated.get(0) : this.currentItems.get(0));
        ArrayList<ItemStack> allOutputs = new ArrayList<ItemStack>(currentRecipe.secondaryOutputs);
        allOutputs.add(0, ispResult);
        for (IRecipeHandler outputHandler : outputHandlers) {
            if (outputHandler instanceof NotifiableItemStackHandler) {
                NotifiableItemStackHandler stackHandler = (NotifiableItemStackHandler)outputHandler;
                for (int index = 0; index < stackHandler.getSlots(); ++index) {
                    Iterator iter = allOutputs.iterator();
                    while (iter.hasNext()) {
                        ItemStack itemStack = (ItemStack)iter.next();
                        if (!stackHandler.isItemValid(index, itemStack)) continue;
                        ItemStack inSlot = stackHandler.getStackInSlot(index);
                        if (inSlot.m_41619_()) {
                            itemStack = stackHandler.insertItemInternal(index, itemStack, simulate);
                        } else if (FoodCapability.has((ItemStack)itemStack) && FoodCapability.has((ItemStack)inSlot) && FoodCapability.areStacksStackableExceptCreationDate((ItemStack)itemStack, (ItemStack)inSlot)) {
                            long date1 = FoodCapability.get((ItemStack)inSlot).getCreationDate();
                            long date2 = FoodCapability.get((ItemStack)itemStack).getCreationDate();
                            if (FoodCapability.getRoundedCreationDate((long)date1) == FoodCapability.getRoundedCreationDate((long)date2)) {
                                FoodCapability.get((ItemStack)itemStack).setCreationDate(date1);
                                itemStack = stackHandler.insertItemInternal(index, itemStack, simulate);
                            }
                        }
                        if (!itemStack.m_41619_()) continue;
                        iter.remove();
                    }
                    if (!allOutputs.isEmpty()) continue;
                    return true;
                }
                continue;
            }
            TFGCore.LOGGER.warn("Unexpected output capability proxy: Expected NotifiableItemStackHandler, actual: {}", outputHandler.getClass());
        }
        return false;
    }

    record TFCRecipeData(List<SizedIngredient> inputs, ItemStackProvider outputISP, List<ItemStack> secondaryOutputs) {
    }

    static class SimulatedCraftingContainer
    implements CraftingContainer {
        private final List<ItemStack> _items = new ArrayList<ItemStack>();

        public SimulatedCraftingContainer(List<ItemStack> items) {
            for (ItemStack itemStack : items) {
                for (int i = 0; i < itemStack.m_41613_(); ++i) {
                    this._items.add(itemStack.m_255036_(1));
                }
            }
        }

        public int m_6643_() {
            return this._items.size();
        }

        public boolean m_7983_() {
            return this._items.isEmpty();
        }

        @NotNull
        public ItemStack m_8020_(int pSlot) {
            return pSlot >= this._items.size() ? ItemStack.f_41583_ : this._items.get(pSlot);
        }

        @NotNull
        public ItemStack m_7407_(int pSlot, int pAmount) {
            return pSlot >= this._items.size() ? ItemStack.f_41583_ : this._items.get(pSlot);
        }

        @NotNull
        public ItemStack m_8016_(int pSlot) {
            return ItemStack.f_41583_;
        }

        public void m_6836_(int pSlot, @NotNull ItemStack pStack) {
        }

        public void m_6596_() {
        }

        public boolean m_6542_(@NotNull Player pPlayer) {
            return false;
        }

        public void m_6211_() {
        }

        public void m_5809_(@NotNull StackedContents pContents) {
        }

        public int m_39347_() {
            return 1;
        }

        public int m_39346_() {
            return 1;
        }

        @NotNull
        public List<ItemStack> m_280657_() {
            return this._items;
        }
    }
}

