/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.compat.kjs;

import com.notenoughmail.kubejs_tfc.block.internal.ExtendedPropertiesBlockBuilder;
import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.Lazy;
import su.terrafirmagreg.core.common.data.blocks.ParticleEmitterBlock;

public class ParticleEmitterBlockBuilder
extends ExtendedPropertiesBlockBuilder {
    public static final List<Block> REGISTERED_BLOCKS = new ArrayList<Block>();
    public transient VoxelShape cachedShape;
    public transient Supplier<Item> preexistingItem;
    public transient Supplier<Item> itemBuilder;
    public transient Supplier<SimpleParticleType> particleType = () -> ParticleTypes.f_123778_;
    public transient double baseX = 0.5;
    public transient double baseY = 0.5;
    public transient double baseZ = 0.5;
    public transient double offsetX = 0.25;
    public transient double offsetY = 1.0;
    public transient double offsetZ = 0.25;
    public transient double velocityX = 0.0;
    public transient double velocityY = 0.0;
    public transient double velocityZ = 0.0;
    public transient int particleCount = 1;
    public transient boolean particleForced = false;
    public transient boolean useDustOptions = false;
    public transient float dustRed = 1.0f;
    public transient float dustGreen = 0.0f;
    public transient float dustBlue = 0.0f;
    public transient float dustScale = 1.0f;
    private transient boolean hasTicker = false;
    public transient int emitDelay = 0;

    public ParticleEmitterBlockBuilder(ResourceLocation id) {
        super(id);
        this.soundType = SoundType.f_56742_;
        this.hardness = 1.5f;
        this.resistance = 6.0f;
        this.mapColor(MapColor.f_283947_);
    }

    @Info(value="Enable/disable block entity ticker (default false).")
    public ParticleEmitterBlockBuilder hasTicker(boolean enabled) {
        this.hasTicker = enabled;
        return this;
    }

    @Info(value="Random emission delay scale")
    public ParticleEmitterBlockBuilder emitDelay(int delay) {
        this.emitDelay = Math.max(0, delay);
        return this;
    }

    @Info(value="Starting emission position (default: center -> 0.5, 0.5, 0.5).")
    public ParticleEmitterBlockBuilder particleBase(double x, double y, double z) {
        this.baseX = x;
        this.baseY = y;
        this.baseZ = z;
        return this;
    }

    @Info(value="Particle type id (SimpleParticleType 'minecraft:dust' enables dust options).")
    public ParticleEmitterBlockBuilder particle(String id) {
        ResourceLocation rl = ResourceLocation.m_135820_((String)id);
        this.particleType = Lazy.of(() -> {
            ParticleType pt = (ParticleType)RegistryInfo.PARTICLE_TYPE.getValue(rl);
            if (pt instanceof SimpleParticleType) {
                SimpleParticleType simple = (SimpleParticleType)pt;
                if (id.equals("minecraft:dust")) {
                    this.useDustOptions = true;
                }
                return simple;
            }
            throw new IllegalArgumentException("Particle type '" + id + "' is not a SimpleParticleType");
        });
        return this;
    }

    @Info(value="Random spread ranges (default 0.25, 1.0, 0.25).")
    public ParticleEmitterBlockBuilder particleOffset(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
        return this;
    }

    @Info(value="Particle velocity (default 0, 0, 0).")
    public ParticleEmitterBlockBuilder particleVelocity(double x, double y, double z) {
        this.velocityX = x;
        this.velocityY = y;
        this.velocityZ = z;
        return this;
    }

    @Info(value="Particles per emission (>=1; default 1).")
    public ParticleEmitterBlockBuilder particleCount(int count) {
        this.particleCount = count;
        return this;
    }

    @Info(value="Always visible (default false).")
    public ParticleEmitterBlockBuilder particleForced(boolean forced) {
        this.particleForced = forced;
        return this;
    }

    @Info(value="Dust color r, g, b + scale (only if dust particle chosen).")
    public ParticleEmitterBlockBuilder dustColor(float r, float g, float b, float scale) {
        this.dustRed = r;
        this.dustGreen = g;
        this.dustBlue = b;
        this.dustScale = scale;
        return this;
    }

    @Info(value="Attach existing item instead of generating new.")
    public ParticleEmitterBlockBuilder withPreexistingItem(ResourceLocation item) {
        this.itemBuilder = null;
        this.preexistingItem = Lazy.of(() -> (Item)RegistryInfo.ITEM.getValue(item));
        return this;
    }

    @HideFromJS
    public VoxelShape getShape() {
        if (this.customShape.isEmpty()) {
            return ParticleEmitterBlock.DEFAULT_SHAPE;
        }
        if (this.cachedShape == null) {
            this.cachedShape = BlockBuilder.createShape((List)this.customShape);
        }
        return this.cachedShape;
    }

    @HideFromJS
    public Supplier<Item> itemSupplier() {
        if (this.preexistingItem != null) {
            return this.preexistingItem;
        }
        if (this.itemBuilder != null) {
            return this.itemBuilder;
        }
        return null;
    }

    public ParticleEmitterBlock createObject() {
        BlockBehaviour.Properties props = this.createProperties();
        ParticleEmitterBlock block = new ParticleEmitterBlock(props, this.getShape(), this.itemSupplier(), this.particleType, this.baseX, this.baseY, this.baseZ, this.offsetX, this.offsetY, this.offsetZ, this.velocityX, this.velocityY, this.velocityZ, this.particleCount, this.particleForced, this.useDustOptions, this.dustRed, this.dustGreen, this.dustBlue, this.dustScale, this.hasTicker, this.emitDelay);
        if (this.hasTicker) {
            REGISTERED_BLOCKS.add(block);
        }
        return block;
    }
}

