/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.compat.tfcambiental;

import com.eerussianguy.beneath.common.blocks.LavaAqueductBlock;
import com.eerussianguy.firmalife.common.blocks.OvenBottomBlock;
import com.gregtechceu.gtceu.api.block.property.GTBlockStateProperties;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IWorkable;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.lumintorious.tfcambiental.api.AmbientalRegistry;
import com.lumintorious.tfcambiental.modifier.TempModifier;
import com.simibubi.create.AllItems;
import earth.terrarium.adastra.common.registry.ModItems;
import java.util.Arrays;
import java.util.Optional;
import net.dries007.tfc.common.blocks.SeaIceBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.rock.AqueductBlock;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.RegistryObject;

public final class TFCAmbientalCompat {
    public static final float HEATPROOF = -9.0f;
    public static final float FULLY_INSULATED = -10.0f;

    public static void register() {
        Rock[] magmaRocks;
        for (Rock rock : magmaRocks = new Rock[]{Rock.ANDESITE, Rock.DIORITE, Rock.DACITE, Rock.RHYOLITE, Rock.GABBRO, Rock.GRANITE}) {
            AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("magma_" + rock.m_7912_(), 5.0f, 1.0f)).filter(mod -> state.m_60734_() == ((RegistryObject)TFCBlocks.MAGMA_BLOCKS.get(rock)).get()));
        }
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("hp_steam_solid_boiler", 5.0f, 2.0f)).filter(mod -> {
            boolean isTargetBlock = state.m_60734_() == ((MachineDefinition)GTMachines.STEAM_SOLID_BOILER.right()).getBlock();
            IWorkable cap = GTCapabilityHelper.getWorkable((Level)player.m_9236_(), (BlockPos)blockPos, null);
            return cap != null && cap.isActive() && cap.isWorkingEnabled() && isTargetBlock;
        }));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("hp_steam_liquid_boiler", 5.0f, 2.0f)).filter(mod -> {
            boolean isTargetBlock = state.m_60734_() == ((MachineDefinition)GTMachines.STEAM_LIQUID_BOILER.right()).getBlock();
            IWorkable cap = GTCapabilityHelper.getWorkable((Level)player.m_9236_(), (BlockPos)blockPos, null);
            return cap != null && cap.isActive() && cap.isWorkingEnabled() && isTargetBlock;
        }));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("hp_steam_furnace", 8.0f, 2.0f)).filter(mod -> {
            boolean isTargetBlock = state.m_60734_() == ((MachineDefinition)GTMachines.STEAM_FURNACE.right()).getBlock();
            IWorkable cap = GTCapabilityHelper.getWorkable((Level)player.m_9236_(), (BlockPos)blockPos, null);
            return cap != null && cap.isActive() && cap.isWorkingEnabled() && isTargetBlock;
        }));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("hp_steam_alloy_smelter", 6.0f, 2.0f)).filter(mod -> {
            boolean isTargetBlock = state.m_60734_() == ((MachineDefinition)GTMachines.STEAM_ALLOY_SMELTER.right()).getBlock();
            IWorkable cap = GTCapabilityHelper.getWorkable((Level)player.m_9236_(), (BlockPos)blockPos, null);
            return cap != null && cap.isActive() && cap.isWorkingEnabled() && isTargetBlock;
        }));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("bronze_firebox", 6.0f, 3.0f)).filter(mod -> state.m_60734_() == GTBlocks.FIREBOX_BRONZE.get() && (Boolean)state.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("steel_firebox", 8.0f, 3.0f)).filter(mod -> state.m_60734_() == GTBlocks.FIREBOX_STEEL.get() && (Boolean)state.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("titanium_firebox", 10.0f, 3.0f)).filter(mod -> state.m_60734_() == GTBlocks.FIREBOX_TITANIUM.get() && (Boolean)state.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("tungstensteel_firebox", 12.0f, 3.0f)).filter(mod -> state.m_60734_() == GTBlocks.FIREBOX_TUNGSTENSTEEL.get() && (Boolean)state.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("electric_furnace", 10.0f, 3.0f)).filter(mod -> {
            boolean isTargetBlock = Arrays.stream(GTMachines.ELECTRIC_FURNACE).anyMatch(element -> {
                if (element != null) {
                    return element.getBlock() == state.m_60734_();
                }
                return false;
            });
            RecipeLogic cap = GTCapabilityHelper.getRecipeLogic((Level)player.m_9236_(), (BlockPos)blockPos, null);
            return cap != null && cap.isActive() && cap.isWorkingEnabled() && isTargetBlock;
        }));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("arc_furnace", 12.0f, 3.0f)).filter(mod -> {
            boolean isTargetBlock = Arrays.stream(GTMachines.ARC_FURNACE).anyMatch(element -> {
                if (element != null) {
                    return element.getBlock() == state.m_60734_();
                }
                return false;
            });
            RecipeLogic cap = GTCapabilityHelper.getRecipeLogic((Level)player.m_9236_(), (BlockPos)blockPos, null);
            return cap != null && cap.isActive() && cap.isWorkingEnabled() && isTargetBlock;
        }));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("alloy_smelter", 9.0f, 3.0f)).filter(mod -> {
            boolean isTargetBlock = Arrays.stream(GTMachines.ALLOY_SMELTER).anyMatch(element -> {
                if (element != null) {
                    return element.getBlock() == state.m_60734_();
                }
                return false;
            });
            RecipeLogic cap = GTCapabilityHelper.getRecipeLogic((Level)player.m_9236_(), (BlockPos)blockPos, null);
            return cap != null && cap.isActive() && cap.isWorkingEnabled() && isTargetBlock;
        }));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("fluid_heater", 11.0f, 3.0f)).filter(mod -> {
            boolean isTargetBlock = Arrays.stream(GTMachines.FLUID_HEATER).anyMatch(element -> {
                if (element != null) {
                    return element.getBlock() == state.m_60734_();
                }
                return false;
            });
            RecipeLogic cap = GTCapabilityHelper.getRecipeLogic((Level)player.m_9236_(), (BlockPos)blockPos, null);
            return cap != null && cap.isActive() && cap.isWorkingEnabled() && isTargetBlock;
        }));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("cupronickel_coil", 18.0f, 3.0f)).filter(mod -> state.m_60734_() == GTBlocks.COIL_CUPRONICKEL.get() && (Boolean)state.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("kanthal_coil", 28.0f, 3.0f)).filter(mod -> state.m_60734_() == GTBlocks.COIL_KANTHAL.get() && (Boolean)state.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("nichrome_coil", 38.0f, 3.0f)).filter(mod -> state.m_60734_() == GTBlocks.COIL_NICHROME.get() && (Boolean)state.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("tungstensteel_coil", 48.0f, 3.0f)).filter(mod -> state.m_60734_() == GTBlocks.COIL_RTMALLOY.get() && (Boolean)state.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("hssg_coil", 58.0f, 3.0f)).filter(mod -> state.m_60734_() == GTBlocks.COIL_HSSG.get() && (Boolean)state.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("naquadah_coil", 78.0f, 3.0f)).filter(mod -> state.m_60734_() == GTBlocks.COIL_NAQUADAH.get() && (Boolean)state.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("trinium_coil", 88.0f, 3.0f)).filter(mod -> state.m_60734_() == GTBlocks.COIL_TRINIUM.get() && (Boolean)state.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("tritanium_coil", 98.0f, 3.0f)).filter(mod -> state.m_60734_() == GTBlocks.COIL_TRITANIUM.get() && (Boolean)state.m_61143_((Property)GTBlockStateProperties.ACTIVE) != false));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("aqueduct_lava", 5.0f, 1.0f)).filter(mod -> state.m_60734_() instanceof LavaAqueductBlock && ((FluidProperty.FluidKey)state.m_61143_((Property)LavaAqueductBlock.FLUID)).getFluid() == Fluids.f_76195_));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("aqueduct_spring_water", 2.0f, 1.0f)).filter(mod -> state.m_60734_() instanceof AqueductBlock && ((FluidProperty.FluidKey)state.m_61143_((Property)AqueductBlock.FLUID)).getFluid() == TFCFluids.SPRING_WATER.getFlowing()));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("packed_block", -6.0f, 1.0f)).filter(mod -> state.m_60734_() == Blocks.f_50354_));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("blue_ice", -8.0f, 1.0f)).filter(mod -> state.m_60734_() == Blocks.f_50568_));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("ice_block", -4.0f, 1.0f)).filter(mod -> state.m_60734_() instanceof IceBlock));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("sea_ice", -6.0f, 1.0f)).filter(mod -> state.m_60734_() instanceof SeaIceBlock));
        AmbientalRegistry.BLOCKS.register((player, blockPos, state) -> Optional.of(new TempModifier("firmalife_oven", 6.0f, 1.0f)).filter(mod -> state.m_60734_() instanceof OvenBottomBlock && (Boolean)state.m_61143_((Property)OvenBottomBlock.LIT) != false));
        AmbientalRegistry.EQUIPMENT.register((player, stack) -> Optional.of(new TempModifier("copper_diving_equipment", -1.0f, 0.1f)).filter(mod -> {
            Item item = stack.m_41720_();
            return item == AllItems.COPPER_DIVING_HELMET.m_5456_() || item == AllItems.COPPER_DIVING_BOOTS.m_5456_() || item == AllItems.COPPER_BACKTANK.m_5456_();
        }));
        AmbientalRegistry.EQUIPMENT.register((player, stack) -> Optional.of(new TempModifier("blue_steel_diving_equipment", -3.0f, -9.0f)).filter(mod -> {
            Item item = stack.m_41720_();
            return item == AllItems.NETHERITE_DIVING_HELMET.m_5456_() || item == AllItems.NETHERITE_DIVING_BOOTS.m_5456_() || item == AllItems.NETHERITE_BACKTANK.m_5456_() || item == Items.f_42482_.m_5456_();
        }));
        AmbientalRegistry.EQUIPMENT.register((player, stack) -> Optional.of(new TempModifier("nanomuscle_armor", 0.0f, -10.0f)).filter(mod -> {
            Item item = stack.m_41720_();
            return item == GTItems.NANO_HELMET.m_5456_() || item == GTItems.NANO_CHESTPLATE.m_5456_() || item == GTItems.NANO_LEGGINGS.m_5456_() || item == GTItems.NANO_BOOTS.m_5456_() || item == GTItems.NANO_CHESTPLATE_ADVANCED.m_5456_();
        }));
        AmbientalRegistry.EQUIPMENT.register((player, stack) -> Optional.of(new TempModifier("quarktech_armor", 0.0f, -10.0f)).filter(mod -> {
            Item item = stack.m_41720_();
            return item == GTItems.QUANTUM_HELMET.m_5456_() || item == GTItems.QUANTUM_CHESTPLATE.m_5456_() || item == GTItems.QUANTUM_LEGGINGS.m_5456_() || item == GTItems.QUANTUM_BOOTS.m_5456_() || item == GTItems.QUANTUM_CHESTPLATE_ADVANCED.m_5456_();
        }));
        AmbientalRegistry.EQUIPMENT.register((player, stack) -> Optional.of(new TempModifier("space_suit", 0.0f, -10.0f)).filter(mod -> {
            Item item = stack.m_41720_();
            return item == ModItems.SPACE_HELMET.get() || item == ModItems.NETHERITE_SPACE_HELMET.get() || item == ModItems.JET_SUIT_HELMET.get() || item == ModItems.SPACE_SUIT.get() || item == ModItems.NETHERITE_SPACE_SUIT.get() || item == ModItems.JET_SUIT.get() || item == ModItems.SPACE_PANTS.get() || item == ModItems.NETHERITE_SPACE_PANTS.get() || item == ModItems.JET_SUIT_PANTS.get() || item == ModItems.SPACE_BOOTS.get() || item == ModItems.NETHERITE_SPACE_BOOTS.get() || item == ModItems.JET_SUIT_BOOTS.get();
        }));
    }
}

