/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.mixins.client.tfc;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ConcurrentModificationException;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.SheetPileBlockModel;
import net.dries007.tfc.client.model.SimpleStaticBlockEntityModel;
import net.dries007.tfc.common.blockentities.SheetPileBlockEntity;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.devices.SheetPileBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.client.TFGClientEventHandler;
import su.terrafirmagreg.core.client.TFGClientHelpers;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
@Mixin(value={SheetPileBlockModel.class}, remap=false)
public abstract class SheetPileBlockModelMixin
implements SimpleStaticBlockEntityModel<SheetPileBlockModel, SheetPileBlockEntity> {
    public TextureAtlasSprite render(SheetPileBlockEntity pile, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        BlockState state = pile.m_58900_();
        TextureAtlasSprite sprite = null;
        Function textureAtlas = Minecraft.m_91087_().m_91258_(RenderHelpers.BLOCKS_ATLAS);
        for (Direction direction : Helpers.DIRECTIONS) {
            MaterialStack material;
            if (!((Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty((Direction)direction))).booleanValue()) continue;
            ItemStack stack = pile.getSheet(direction);
            try {
                material = ChemicalHelper.getMaterialStack((ItemStack)stack);
            }
            catch (ArrayIndexOutOfBoundsException | ConcurrentModificationException ex) {
                TFGCore.LOGGER.error("Encountered exception when attempting to get material from item stack: {}: {}", (Object)stack, (Object)ex);
                return RenderHelpers.missingTexture();
            }
            int primaryColor = material.material().getMaterialARGB(0);
            int secondaryColor = material.material().getMaterialARGB(1);
            Metal metalAtPos = pile.getOrCacheMetal(direction);
            boolean shouldUseTFCRender = metalAtPos.getId() != Metal.unknown().getId() || material.isEmpty();
            ResourceLocation metalResource = shouldUseTFCRender ? metalAtPos.getTextureId() : TFGClientEventHandler.TFCMetalBlockTexturePattern;
            sprite = (TextureAtlasSprite)textureAtlas.apply(metalResource);
            this.tfg$renderSheet(poseStack, sprite, buffer, direction, packedLight, packedOverlay, shouldUseTFCRender, primaryColor, secondaryColor);
        }
        if (sprite == null) {
            sprite = RenderHelpers.missingTexture();
        }
        return sprite;
    }

    @Unique
    private void tfg$renderSheet(PoseStack poseStack, TextureAtlasSprite sprite, VertexConsumer buffer, Direction direction, int packedLight, int packedOverlay, boolean shouldUseTFCRender, int primaryColor, int secondaryColor) {
        if (shouldUseTFCRender) {
            RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)sprite, (int)packedLight, (int)packedOverlay, (AABB)SheetPileBlock.getShapeForSingleFace((Direction)direction).m_83215_());
        } else {
            TFGClientHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, SheetPileBlock.getShapeForSingleFace((Direction)direction).m_83215_(), primaryColor, secondaryColor);
        }
    }
}

