/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.network.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import su.terrafirmagreg.core.client.OreHighlightVeinRenderer;

public record OreHighlightVeinPacket(List<BlockPos> veinCenters) {
    public static void encode(@NotNull OreHighlightVeinPacket pkt, @NotNull FriendlyByteBuf buf) {
        buf.m_130130_(pkt.veinCenters.size());
        for (BlockPos pos : pkt.veinCenters) {
            buf.m_130064_(pos);
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    public static OreHighlightVeinPacket decode(@NotNull FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(size);
        for (int i = 0; i < size; ++i) {
            positions.add(buf.m_130135_());
        }
        return new OreHighlightVeinPacket(positions);
    }

    public static void handle(OreHighlightVeinPacket pkt, @NotNull Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> OreHighlightVeinRenderer.addVeinHighlights(pkt.veinCenters));
        ctx.get().setPacketHandled(true);
    }
}

