/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.network.packet;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.network.NetworkEvent;

public class SoundPacket {
    private final double x;
    private final double y;
    private final double z;
    private final ResourceLocation soundId;
    private final float volume;
    private final float pitch;

    public SoundPacket(double x, double y, double z, ResourceLocation soundId, float volume, float pitch) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.soundId = soundId;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static void encode(SoundPacket pkt, FriendlyByteBuf buf) {
        buf.writeDouble(pkt.x);
        buf.writeDouble(pkt.y);
        buf.writeDouble(pkt.z);
        buf.m_130085_(pkt.soundId);
        buf.writeFloat(pkt.volume);
        buf.writeFloat(pkt.pitch);
    }

    public static SoundPacket decode(FriendlyByteBuf buf) {
        return new SoundPacket(buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.m_130281_(), buf.readFloat(), buf.readFloat());
    }

    public static void handle(SoundPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level == null) {
                return;
            }
            SoundEvent sound = (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(pkt.soundId);
            if (sound != null) {
                level.m_7785_(pkt.x, pkt.y, pkt.z, sound, SoundSource.BLOCKS, pkt.volume, pkt.pitch, false);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

